/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ctera;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostUrlProvider;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.MacUniqueIdService;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.ctera.CteraAuthenticationHandler;
import ch.cyberduck.core.ctera.CteraCustomActions;
import ch.cyberduck.core.ctera.CteraProtocol;
import ch.cyberduck.core.ctera.auth.CteraTokens;
import ch.cyberduck.core.ctera.model.AttachDeviceResponse;
import ch.cyberduck.core.ctera.model.Attachment;
import ch.cyberduck.core.ctera.model.PortalSession;
import ch.cyberduck.core.ctera.model.PublicInfo;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.dav.DAVRedirectStrategy;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.features.CustomActions;
import ch.cyberduck.core.features.Lock;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import ch.cyberduck.core.http.PreferencesRedirectCallback;
import ch.cyberduck.core.http.RedirectCallback;
import ch.cyberduck.core.local.BrowserLauncherFactory;
import ch.cyberduck.core.oauth.OAuth2TokenListenerRegistry;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.AbstractResponseHandler;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CteraSession
extends DAVSession {
    private static final Logger log = LogManager.getLogger(CteraSession.class);
    private final CteraAuthenticationHandler authentication = new CteraAuthenticationHandler(this);

    public CteraSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
    }

    protected DAVClient connect(Proxy proxy, HostKeyCallback key, LoginCallback prompt, CancelCallback cancel) {
        HttpClientBuilder configuration = this.builder.build(proxy, (TranscriptListener)this, prompt);
        configuration.setRedirectStrategy((RedirectStrategy)new DAVRedirectStrategy((RedirectCallback)new PreferencesRedirectCallback()));
        configuration.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)this.authentication);
        return new DAVClient(new HostUrlProvider().withUsername(false).get(this.host), configuration);
    }

    public void login(Proxy proxy, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        Credentials credentials = this.host.getCredentials();
        if (StringUtils.isBlank((CharSequence)credentials.getToken())) {
            CteraTokens tokens = this.getTokens(credentials, prompt, cancel);
            this.authenticateWithTokens(tokens);
            credentials.setToken(tokens.toString());
            credentials.setSaved(true);
        } else {
            try {
                this.authenticateWithTokens(CteraTokens.parse(credentials.getToken()));
            }
            catch (AccessDeniedException e) {
                CteraTokens tokens = this.getTokens(credentials, prompt, cancel);
                this.authenticateWithTokens(tokens);
                credentials.setToken(tokens.toString());
                credentials.setSaved(true);
            }
        }
        if (StringUtils.isBlank((CharSequence)credentials.getUsername())) {
            credentials.setUsername(this.getCurrentSession().username);
            credentials.setSaved(true);
        }
    }

    private CteraTokens getTokens(Credentials credentials, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        AttachDeviceResponse response = this.getPublicInfo().hasWebSSO ? this.startWebSSOFlow(cancel) : this.startDesktopFlow(prompt, credentials);
        return new CteraTokens(response.deviceUID, response.sharedSecret);
    }

    private void authenticateWithTokens(CteraTokens tokens) throws BackgroundException {
        this.authentication.setTokens(tokens);
        this.authentication.authenticate();
    }

    protected void logout() throws BackgroundException {
        try {
            this.logoutCurrentSession();
        }
        finally {
            super.logout();
        }
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == Lock.class) {
            return null;
        }
        if (type == CustomActions.class) {
            return (T)new CteraCustomActions(this);
        }
        return (T)super._getFeature(type);
    }

    private AttachDeviceResponse startWebSSOFlow(CancelCallback cancel) throws BackgroundException {
        String url = String.format("%s/ServicesPortal/activate?scheme=%s", new HostUrlProvider().withUsername(false).withPath(false).get(this.host), CteraProtocol.CTERA_REDIRECT_URI);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Open browser with URL %s", url));
        }
        if (!BrowserLauncherFactory.get().open(url)) {
            log.warn(String.format("Failed to launch web browser for %s", url));
        }
        AtomicReference activationCode = new AtomicReference();
        CountDownLatch signal = new CountDownLatch(1);
        OAuth2TokenListenerRegistry registry = OAuth2TokenListenerRegistry.get();
        registry.register("", code -> {
            if (log.isInfoEnabled()) {
                log.info(String.format("Callback with code %s", code));
            }
            if (!StringUtils.isBlank((CharSequence)code)) {
                activationCode.set(code);
            }
            signal.countDown();
        });
        while (!Uninterruptibles.awaitUninterruptibly((CountDownLatch)signal, (long)500L, (TimeUnit)TimeUnit.MILLISECONDS)) {
            cancel.verify();
        }
        return this.attachDeviceWithActivationCode((String)activationCode.get());
    }

    private AttachDeviceResponse startDesktopFlow(LoginCallback prompt, Credentials credentials) throws BackgroundException {
        if (StringUtils.isNotBlank((CharSequence)credentials.getUsername()) && StringUtils.isNotBlank((CharSequence)credentials.getPassword())) {
            try {
                return this.attachDeviceWithUsernamePassword(credentials.getUsername(), credentials.getPassword());
            }
            catch (LoginFailureException e) {
                this.prompt(prompt, credentials);
                return this.startDesktopFlow(prompt, credentials);
            }
        }
        this.prompt(prompt, credentials);
        return this.startDesktopFlow(prompt, credentials);
    }

    private void prompt(LoginCallback prompt, Credentials credentials) throws LoginCanceledException {
        Credentials input = prompt.prompt(this.host, credentials.getUsername(), MessageFormat.format(LocaleFactory.localizedString((String)"Login {0} with username and password", (String)"Credentials"), BookmarkNameProvider.toString((Host)this.host)), LocaleFactory.localizedString((String)"No login credentials could be found in the Keychain", (String)"Credentials"), new LoginOptions(this.host.getProtocol()).token(false).user(true).password(true));
        credentials.setUsername(input.getUsername());
        credentials.setPassword(input.getPassword());
        credentials.setSaved(input.isSaved());
    }

    private AttachDeviceResponse attachDeviceWithActivationCode(String activationCode) throws BackgroundException {
        HttpPost attach = new HttpPost("/ServicesPortal/public/users?format=jsonext");
        try {
            attach.setEntity((HttpEntity)new StringEntity(CteraSession.getAttachmentAsString(activationCode, new HostPreferences(this.host).getProperty("ctera.attach.devicetype"), null, URIEncoder.encode((String)InetAddress.getLocalHost().getHostName()), new MacUniqueIdService().getUUID()), ContentType.create((String)"application/xml", (String)StandardCharsets.UTF_8.name())));
            return this.attachDevice(attach);
        }
        catch (IOException e) {
            throw new HttpExceptionMappingService().map(e);
        }
    }

    private AttachDeviceResponse attachDeviceWithUsernamePassword(String username, String password) throws BackgroundException {
        HttpPost attach = new HttpPost(String.format("/ServicesPortal/public/users/%s?format=jsonext", username));
        try {
            attach.setEntity((HttpEntity)new StringEntity(CteraSession.getAttachmentAsString(null, new HostPreferences(this.host).getProperty("ctera.attach.devicetype"), password, URIEncoder.encode((String)InetAddress.getLocalHost().getHostName()), new MacUniqueIdService().getUUID()), ContentType.create((String)"application/xml", (String)StandardCharsets.UTF_8.name())));
            return this.attachDevice(attach);
        }
        catch (IOException e) {
            throw new HttpExceptionMappingService().map(e);
        }
    }

    private AttachDeviceResponse attachDevice(HttpPost attach) throws IOException, BackgroundException {
        AttachDeviceResponse response;
        final AtomicReference error = new AtomicReference();
        try {
            response = (AttachDeviceResponse)((DAVClient)this.client).execute((HttpRequestBase)attach, (ResponseHandler)new AbstractResponseHandler<AttachDeviceResponse>(){

                public AttachDeviceResponse handleResponse(HttpResponse response) throws IOException {
                    switch (response.getStatusLine().getStatusCode()) {
                        case 500: {
                            XmlMapper mapper = new XmlMapper();
                            try {
                                error.set((Attachment)mapper.readValue(response.getEntity().getContent(), Attachment.class));
                                for (Attachment.Attribute attr : ((Attachment)error.get()).getAttributes()) {
                                    if (!"msg".equals(attr.getId())) continue;
                                    if ("Invalid username or password".equals(attr.getVal())) {
                                        log.error(attr.getVal());
                                        continue;
                                    }
                                    log.error(String.format("Failure attaching the device %s", attr.getVal()));
                                    error.set(null);
                                }
                                break;
                            }
                            catch (IOException e) {
                                log.error("Error parsing response", (Throwable)e);
                            }
                        }
                    }
                    return (AttachDeviceResponse)super.handleResponse(response);
                }

                public AttachDeviceResponse handleEntity(HttpEntity entity) throws IOException {
                    ObjectMapper mapper = new ObjectMapper();
                    return (AttachDeviceResponse)mapper.readValue(entity.getContent(), AttachDeviceResponse.class);
                }
            });
        }
        catch (IOException e) {
            if (error.get() != null) {
                throw new LoginFailureException("Invalid username or password");
            }
            throw e;
        }
        return response;
    }

    private PublicInfo getPublicInfo() throws BackgroundException {
        HttpGet request = new HttpGet("/ServicesPortal/public/publicInfo?format=jsonext");
        try {
            return (PublicInfo)((DAVClient)this.client).execute((HttpRequestBase)request, (ResponseHandler)new AbstractResponseHandler<PublicInfo>(){

                public PublicInfo handleEntity(HttpEntity entity) throws IOException {
                    ObjectMapper mapper = new ObjectMapper();
                    return (PublicInfo)mapper.readValue(entity.getContent(), PublicInfo.class);
                }
            });
        }
        catch (IOException e) {
            throw new HttpExceptionMappingService().map(e);
        }
    }

    private PortalSession getCurrentSession() throws BackgroundException {
        HttpGet request = new HttpGet("/ServicesPortal/api/currentSession?format=jsonext");
        try {
            return (PortalSession)((DAVClient)this.client).execute((HttpRequestBase)request, (ResponseHandler)new AbstractResponseHandler<PortalSession>(){

                public PortalSession handleEntity(HttpEntity entity) throws IOException {
                    ObjectMapper mapper = new ObjectMapper();
                    return (PortalSession)mapper.readValue(entity.getContent(), PortalSession.class);
                }
            });
        }
        catch (IOException e) {
            throw new HttpExceptionMappingService().map(e);
        }
    }

    private void logoutCurrentSession() throws BackgroundException {
        HttpPost request = new HttpPost("/ServicesPortal/api/logout?format=jsonext");
        try {
            ((DAVClient)this.client).execute((HttpRequestBase)request, (ResponseHandler)new BasicResponseHandler());
        }
        catch (IOException e) {
            throw new HttpExceptionMappingService().map(e);
        }
    }

    private static Attachment getAttachment(String activationCode, String attachDeviceType, String password, String hostname, String mac) {
        Attachment attachment = new Attachment();
        ArrayList<Attachment.Attribute> attributes = new ArrayList<Attachment.Attribute>();
        attachment.setAttributes(attributes);
        Attachment.Attribute type = new Attachment.Attribute();
        type.setId("type");
        type.setVal("user-defined");
        attributes.add(type);
        Attachment.Attribute name = new Attachment.Attribute();
        name.setId("name");
        name.setVal("attachMobileDevice");
        attributes.add(name);
        Attachment.Attribute param = new Attachment.Attribute();
        param.setId("param");
        Attachment.AttachedMobileDeviceParams params = new Attachment.AttachedMobileDeviceParams();
        param.setParams(params);
        attributes.add(param);
        ArrayList<Attachment.Attribute> paramsAttributes = new ArrayList<Attachment.Attribute>();
        params.setAtt(paramsAttributes);
        Attachment.Attribute deviceType = new Attachment.Attribute();
        deviceType.setId("deviceType");
        deviceType.setVal(attachDeviceType);
        paramsAttributes.add(deviceType);
        Attachment.Attribute deviceMac = new Attachment.Attribute();
        deviceMac.setId("deviceMac");
        deviceMac.setVal(mac);
        paramsAttributes.add(deviceMac);
        Attachment.Attribute ssoActivationCode = new Attachment.Attribute();
        ssoActivationCode.setId("ssoActivationCode");
        ssoActivationCode.setVal(activationCode);
        paramsAttributes.add(ssoActivationCode);
        Attachment.Attribute pwd = new Attachment.Attribute();
        pwd.setId("password");
        pwd.setVal(password);
        paramsAttributes.add(pwd);
        Attachment.Attribute host = new Attachment.Attribute();
        host.setId("hostname");
        host.setVal(URIEncoder.encode((String)hostname));
        paramsAttributes.add(host);
        return attachment;
    }

    private static String getAttachmentAsString(String activationCode, String attachDeviceType, String password, String hostname, String mac) throws JsonProcessingException {
        Attachment attachment = CteraSession.getAttachment(activationCode, attachDeviceType, password, hostname, mac);
        XmlMapper xmlMapper = new XmlMapper();
        return xmlMapper.writeValueAsString((Object)attachment);
    }
}

