/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ctera;

import ch.cyberduck.core.AbstractProtocol;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.dav.DAVSSLProtocol;
import ch.cyberduck.core.preferences.PreferencesFactory;

public class CteraProtocol
extends AbstractProtocol {
    public static final String CTERA_REDIRECT_URI = String.format("%s:websso", PreferencesFactory.get().getProperty("oauth.handler.scheme"));

    public Protocol.Type getType() {
        return Protocol.Type.ctera;
    }

    public String getIdentifier() {
        return Protocol.Type.ctera.name();
    }

    public String getName() {
        return "CTERA";
    }

    public String getDescription() {
        return "CTERA Portal";
    }

    public Scheme getScheme() {
        return Scheme.https;
    }

    public String disk() {
        return new DAVSSLProtocol().disk();
    }

    public String icon() {
        return new DAVSSLProtocol().icon();
    }

    public boolean isTokenConfigurable() {
        return true;
    }

    public boolean validate(Credentials credentials, LoginOptions options) {
        return super.validate(credentials, new LoginOptions(options).token(false).password(false).user(false));
    }

    public String getTokenPlaceholder() {
        return "CTERA Token";
    }
}

