/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ctera;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ctera.CteraCustomActionVersioning;
import ch.cyberduck.core.ctera.CteraSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.CustomActions;
import java.util.Collections;
import java.util.Set;

public class CteraCustomActions
implements CustomActions {
    private final CteraSession session;

    public CteraCustomActions(CteraSession session) {
        this.session = session;
    }

    public void run(CustomActions.Action type, Path file) throws BackgroundException {
        switch (CteraActions.valueOf(type.name())) {
            case versioning: {
                new CteraCustomActionVersioning(this.session, file).run();
                break;
            }
        }
    }

    public Set<CustomActions.Action> list(Path file) {
        if (file.isFile()) {
            return Collections.singleton(CteraActions.versioning);
        }
        return Collections.emptySet();
    }

    private static enum CteraActions implements CustomActions.Action
    {
        versioning{

            public String getTitle() {
                return LocaleFactory.localizedString((String)"Versions", (String)"Info");
            }
        }
        ,
        share{

            public String getTitle() {
                return LocaleFactory.localizedString((String)"Share\u2026", (String)"Main");
            }
        };

    }
}

