/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ctera;

import ch.cyberduck.core.AlphanumericRandomStringService;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.HostUrlProvider;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathRelativizer;
import ch.cyberduck.core.ctera.CteraSession;
import ch.cyberduck.core.ctera.auth.CteraTokens;
import ch.cyberduck.core.ctera.model.Attachment;
import ch.cyberduck.core.ctera.model.Device;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import ch.cyberduck.core.local.BrowserLauncherFactory;
import ch.cyberduck.core.local.TemporaryFileServiceFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.AbstractResponseHandler;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CteraCustomActionVersioning {
    private static final Logger log = LogManager.getLogger(CteraCustomActionVersioning.class);
    private final CteraSession session;
    private final Path file;

    public CteraCustomActionVersioning(CteraSession session, Path file) {
        this.session = session;
        this.file = file;
    }

    public void run() throws BackgroundException {
        String token = this.getSessionToken();
        Local html = this.writeTemporaryHtml(token);
        BrowserLauncherFactory.get().open(html.toURL());
    }

    private Local writeTemporaryHtml(String token) throws BackgroundException {
        try {
            String content = String.format("<!doctype html>\n<html> <head> <script>\nfunction _onload(){document.getElementById(\"sForm\").submit();}\n</script> </head> <body onload = \"_onload()\">\n<form id=\"sForm\" method=\"POST\" action=\"%s/ServicesPortal/sso\">\n<input type=\"hidden\" name=\"targeturi\" value=\"?GUI_openFmFolder=%s&GUI_fmVersions=true\"/>\n<input type=\"hidden\" name=\"ctera_ticket\" value=\"%s\"/>\n</form> </body> </html>", new HostUrlProvider().withUsername(false).get(this.session.getHost()), URLEncoder.encode(String.format("/%s", PathRelativizer.relativize((String)this.session.getHost().getProtocol().getDefaultPath(), (String)this.file.getAbsolute())), StandardCharsets.UTF_8.name()), token);
            Local file = TemporaryFileServiceFactory.get().create(String.format("%s.html", new AlphanumericRandomStringService().random()));
            try (OutputStream out = file.getOutputStream(false);){
                IOUtils.write((String)content, (OutputStream)out, (Charset)StandardCharsets.UTF_8);
            }
            return file;
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Error writing temporary file", (Throwable)e);
        }
    }

    protected String getSessionToken() throws BackgroundException {
        try {
            String device = this.getDeviceName();
            if (log.isDebugEnabled()) {
                log.debug(String.format("Using device %s to request a session token", device));
            }
            HttpPost post = new HttpPost(String.format("/ServicesPortal/api/devices/%s?format=jsonext", device));
            post.setEntity((HttpEntity)new StringEntity(CteraCustomActionVersioning.getSessionTokenPayloadAsString(), ContentType.APPLICATION_JSON));
            return (String)((DAVClient)this.session.getClient()).execute((HttpRequestBase)post, response -> StringUtils.remove((String)EntityUtils.toString((HttpEntity)response.getEntity()), (String)"\""));
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(String.format("Unable to redirect to the portal for %s", this.file), (Throwable)e);
        }
    }

    private String getDeviceName() throws BackgroundException {
        String token = this.getCteraTokens();
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new InteroperabilityException("No token found");
        }
        try {
            Device[] devices;
            CteraTokens tokens = CteraTokens.parse(token);
            String id = tokens.getDeviceId();
            HttpGet request = new HttpGet("/ServicesPortal/api/devices?format=jsonext");
            for (Device device : devices = (Device[])((DAVClient)this.session.getClient()).execute((HttpRequestBase)request, (ResponseHandler)new AbstractResponseHandler<Device[]>(){

                public Device[] handleEntity(HttpEntity entity) throws IOException {
                    ObjectMapper mapper = new ObjectMapper();
                    return (Device[])mapper.readValue(entity.getContent(), Device[].class);
                }
            })) {
                if (!device.uid.equals(id)) continue;
                return device.name;
            }
            throw new InteroperabilityException(String.format("No device for token %s found", token));
        }
        catch (IOException e) {
            throw new HttpExceptionMappingService().map(e);
        }
    }

    protected String getCteraTokens() {
        HostPasswordStore keychain = PasswordStoreFactory.get();
        return keychain.findLoginToken(this.session.getHost());
    }

    private static String getSessionTokenPayloadAsString() throws JsonProcessingException {
        Attachment attachment = new Attachment();
        ArrayList<Attachment.Attribute> attributes = new ArrayList<Attachment.Attribute>();
        Attachment.Attribute type = new Attachment.Attribute();
        type.setId("type");
        type.setVal("user-defined");
        attributes.add(type);
        Attachment.Attribute name = new Attachment.Attribute();
        name.setId("name");
        name.setVal("getSessionToken");
        attributes.add(name);
        attachment.setAttributes(attributes);
        XmlMapper xmlMapper = new XmlMapper();
        return xmlMapper.writeValueAsString((Object)attachment);
    }
}

