/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ctera;

import ch.cyberduck.core.ctera.CteraSession;
import ch.cyberduck.core.ctera.auth.CteraTokens;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.AbstractResponseHandler;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CteraAuthenticationHandler
implements ServiceUnavailableRetryStrategy {
    private static final Logger log = LogManager.getLogger(CteraAuthenticationHandler.class);
    private static final String SAML_LOCATION = "https://myapps.microsoft.com/signin/CTERA/e8e5145e-4fac-412e-b87b-fbfc26123827";
    private static final int MAX_RETRIES = 1;
    private final CteraSession session;
    private CteraTokens tokens = CteraTokens.EMPTY;

    public CteraAuthenticationHandler(CteraSession session) {
        this.session = session;
    }

    public void setTokens(CteraTokens tokens) {
        this.tokens = tokens;
    }

    public void authenticate() throws BackgroundException {
        HttpPost login = new HttpPost("/ServicesPortal/api/login?format=jsonext");
        try {
            login.setEntity((HttpEntity)new StringEntity(String.format("j_username=device%%5c%s&j_password=%s", this.tokens.getDeviceId(), this.tokens.getSharedSecret()), ContentType.APPLICATION_FORM_URLENCODED));
            ((DAVClient)this.session.getClient()).execute((HttpRequestBase)login, (ResponseHandler)new AbstractResponseHandler<Void>(){

                public Void handleResponse(HttpResponse response) throws IOException {
                    Header header = response.getFirstHeader("Set-Cookie");
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Received cookie %s", header.getValue()));
                    }
                    return (Void)super.handleResponse(response);
                }

                public Void handleEntity(HttpEntity entity) {
                    return null;
                }
            });
        }
        catch (HttpResponseException e) {
            throw new DefaultHttpResponseExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new HttpExceptionMappingService().map(e);
        }
    }

    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        if (executionCount <= 1) {
            switch (response.getStatusLine().getStatusCode()) {
                case 302: {
                    try {
                        log.info(String.format("Attempt to refresh cookie for failure %s", response));
                        this.authenticate();
                        return true;
                    }
                    catch (BackgroundException e) {
                        log.error(String.format("Failure refreshing cookie. %s", new Object[]{e}));
                        return false;
                    }
                }
            }
        } else if (log.isWarnEnabled()) {
            log.warn(String.format("Skip retry for response %s after %d executions", response, executionCount));
        }
        return false;
    }

    public long getRetryInterval() {
        return 0L;
    }
}

