/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp.openssh;

import ch.cyberduck.core.sftp.openssh.OpenSSHAgentAuthenticator;
import com.jcraft.jsch.agentproxy.AgentProxy;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.USocketFactory;
import com.jcraft.jsch.agentproxy.connector.SSHAgentConnector;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class WindowsOpenSSHAgentAuthenticator
extends OpenSSHAgentAuthenticator {
    public WindowsOpenSSHAgentAuthenticator() throws AgentProxyException {
        super(new AgentProxy((Connector)new SSHAgentConnector((USocketFactory)new RandomAccessFileSocketFactory(), "\\\\.\\pipe\\openssh-ssh-agent")));
    }

    private static class RandomAccessFileSocketFactory
    implements USocketFactory {
        private RandomAccessFileSocketFactory() {
        }

        public USocketFactory.Socket open(String path) throws IOException {
            return new WindowsSocket(path);
        }

        static class WindowsSocket
        extends USocketFactory.Socket {
            private final RandomAccessFile raf;

            WindowsSocket(String path) throws IOException {
                this.raf = new RandomAccessFile(path, "rw");
            }

            public int readFull(byte[] buf, int s, int len) throws IOException {
                try {
                    this.raf.readFully(buf, s, len);
                }
                catch (EOFException e) {
                    return -1;
                }
                return len;
            }

            public void write(byte[] buf, int s, int len) throws IOException {
                this.raf.write(buf, s, len);
            }

            public void close() throws IOException {
                this.raf.close();
            }
        }
    }
}

