/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp.openssh;

import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.schmizz.sshj.userauth.keyprovider.KeyFormat;
import net.schmizz.sshj.userauth.keyprovider.KeyProviderUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OpenSSHPrivateKeyConfigurator {
    private static final Logger log = LogManager.getLogger(OpenSSHPrivateKeyConfigurator.class);
    private final Local directory;

    public OpenSSHPrivateKeyConfigurator() {
        this(LocalFactory.get((Local)LocalFactory.get(), (String)".ssh"));
    }

    public OpenSSHPrivateKeyConfigurator(Local directory) {
        this.directory = directory;
    }

    public List<Local> list() {
        ArrayList<Local> keys = new ArrayList<Local>();
        try {
            for (Local file : this.directory.list((Filter)new Filter<String>(){

                public boolean accept(String file) {
                    return !StringUtils.endsWith((CharSequence)file, (CharSequence)".pub");
                }

                public Pattern toPattern() {
                    return Pattern.compile(".*\\.pub");
                }
            })) {
                KeyFormat format;
                try {
                    format = KeyProviderUtil.detectKeyFileFormat((Reader)new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8), (boolean)true);
                }
                catch (AccessDeniedException | IOException e) {
                    log.debug(String.format("Ignore file %s with unknown format. %s", file, e.getMessage()));
                    continue;
                }
                switch (format) {
                    case PKCS8: 
                    case OpenSSH: 
                    case OpenSSHv1: 
                    case PuTTY: {
                        keys.add(file);
                    }
                }
            }
        }
        catch (AccessDeniedException e) {
            log.warn(String.format("Failure loading keys from directory %s", this.directory));
        }
        return keys;
    }
}

