/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp.openssh;

import ch.cyberduck.core.HostnameConfigurator;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.sftp.openssh.config.transport.OpenSshConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OpenSSHHostnameConfigurator
implements HostnameConfigurator {
    private static final Logger log = LogManager.getLogger(OpenSSHHostnameConfigurator.class);
    private final OpenSshConfig configuration;

    public OpenSSHHostnameConfigurator() {
        this(new OpenSshConfig(LocalFactory.get((Local)LocalFactory.get((Local)LocalFactory.get(), (String)".ssh"), (String)"config")));
    }

    public OpenSSHHostnameConfigurator(OpenSshConfig configuration) {
        this.configuration = configuration;
    }

    public String getHostname(String alias) {
        if (StringUtils.isBlank((CharSequence)alias)) {
            return alias;
        }
        String hostname = this.configuration.lookup(alias).getHostName();
        if (StringUtils.isBlank((CharSequence)hostname)) {
            return alias;
        }
        if (log.isInfoEnabled()) {
            log.info(String.format("Using hostname alias %s from %s", alias, this.configuration));
        }
        return hostname;
    }

    public int getPort(String alias) {
        if (StringUtils.isBlank((CharSequence)alias)) {
            return -1;
        }
        return this.configuration.lookup(alias).getPort();
    }

    public HostnameConfigurator reload() {
        this.configuration.refresh();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OpenSSHHostnameConfigurator{");
        sb.append("configuration=").append(this.configuration);
        sb.append('}');
        return sb.toString();
    }
}

