/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp.openssh;

import ch.cyberduck.core.sftp.auth.AgentAuthenticator;
import com.jcraft.jsch.agentproxy.AgentProxy;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.Identity;
import com.jcraft.jsch.agentproxy.USocketFactory;
import com.jcraft.jsch.agentproxy.connector.SSHAgentConnector;
import com.jcraft.jsch.agentproxy.usocket.JNAUSocketFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OpenSSHAgentAuthenticator
extends AgentAuthenticator {
    private static final Logger log = LogManager.getLogger(OpenSSHAgentAuthenticator.class);
    private final AgentProxy proxy;

    public OpenSSHAgentAuthenticator(String socket) throws AgentProxyException {
        this(new AgentProxy((Connector)new SSHAgentConnector((USocketFactory)new JNAUSocketFactory(), socket)));
    }

    public OpenSSHAgentAuthenticator(AgentProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public AgentProxy getProxy() {
        return this.proxy;
    }

    @Override
    public Collection<Identity> getIdentities() {
        if (null == this.proxy) {
            log.warn(String.format("SSH agent %s is not running", this));
            return Collections.emptyList();
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Retrieve identities from proxy %s", this.proxy));
        }
        List<Identity> identities = Arrays.asList(this.proxy.getIdentities());
        if (log.isDebugEnabled()) {
            log.debug(String.format("Found %d identities", identities.size()));
        }
        return identities;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OpenSSHAgentAuthenticator{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

