/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.sftp.SFTPDeleteFeature;
import ch.cyberduck.core.sftp.SFTPExceptionMappingService;
import ch.cyberduck.core.sftp.SFTPSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.util.Collections;
import net.schmizz.sshj.sftp.RenameFlags;

public class SFTPMoveFeature
implements Move {
    private final SFTPSession session;
    private final Delete delete;

    public SFTPMoveFeature(SFTPSession session) {
        this.session = session;
        this.delete = new SFTPDeleteFeature(session);
    }

    public Path move(Path file, Path renamed, TransferStatus status, Delete.Callback callback, ConnectionCallback connectionCallback) throws BackgroundException {
        try {
            if (status.isExists()) {
                this.delete.delete(Collections.singletonMap(renamed, status), (PasswordCallback)connectionCallback, callback);
            }
            this.session.sftp().rename(file.getAbsolute(), renamed.getAbsolute(), Collections.singleton(RenameFlags.OVERWRITE));
            return renamed.withAttributes(file.attributes());
        }
        catch (IOException e) {
            throw new SFTPExceptionMappingService().map("Cannot rename {0}", e, file);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }
}

