/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.sftp.SFTPExceptionMappingService;
import ch.cyberduck.core.sftp.SFTPSession;
import ch.cyberduck.core.shared.AbstractHomeFeature;
import java.io.IOException;
import java.util.EnumSet;

public class SFTPHomeDirectoryService
extends AbstractHomeFeature {
    private final SFTPSession session;

    public SFTPHomeDirectoryService(SFTPSession session) {
        this.session = session;
    }

    public Path find() throws BackgroundException {
        try {
            String directory = this.session.sftp().canonicalize(".");
            return new Path(PathNormalizer.normalize((String)directory), directory.equals(String.valueOf('/')) ? EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.directory));
        }
        catch (IOException e) {
            throw new SFTPExceptionMappingService().map(e);
        }
    }
}

