/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.sftp.SFTPAttributesFinderFeature;
import ch.cyberduck.core.sftp.SFTPExceptionMappingService;
import ch.cyberduck.core.sftp.SFTPSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import net.schmizz.sshj.sftp.FileAttributes;

public class SFTPDirectoryFeature
implements Directory<Void> {
    private final SFTPSession session;

    public SFTPDirectoryFeature(SFTPSession session) {
        this.session = session;
    }

    public Path mkdir(Path folder, TransferStatus status) throws BackgroundException {
        try {
            FileAttributes attrs = Permission.EMPTY != status.getPermission() ? new FileAttributes.Builder().withPermissions(Integer.parseInt(status.getPermission().getMode(), 8)).build() : FileAttributes.EMPTY;
            this.session.sftp().makeDir(folder.getAbsolute(), attrs);
        }
        catch (IOException e) {
            throw new SFTPExceptionMappingService().map("Cannot create folder {0}", e, folder);
        }
        return folder.withAttributes(new SFTPAttributesFinderFeature(this.session).find(folder));
    }

    public SFTPDirectoryFeature withWriter(Write<Void> writer) {
        return this;
    }
}

