/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.bonjour;

import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.bonjour.AbstractRendezvous;
import ch.cyberduck.core.threading.ActionOperationBatcher;
import ch.cyberduck.core.threading.ActionOperationBatcherFactory;
import com.apple.dnssd.BrowseListener;
import com.apple.dnssd.DNSSD;
import com.apple.dnssd.DNSSDException;
import com.apple.dnssd.DNSSDService;
import com.apple.dnssd.ResolveListener;
import com.apple.dnssd.TXTRecord;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RendezvousResponder
extends AbstractRendezvous
implements BrowseListener,
ResolveListener {
    private static final Logger log = LogManager.getLogger(RendezvousResponder.class);
    private final Map<String, DNSSDService> browsers = new ConcurrentHashMap<String, DNSSDService>();

    public RendezvousResponder() {
        this(ProtocolFactory.get());
    }

    public RendezvousResponder(ProtocolFactory protocols) {
        super(protocols);
    }

    @Override
    public void init() {
        if (log.isDebugEnabled()) {
            log.debug("Initialize responder by browsing DNSSD");
        }
        super.init();
        try {
            for (String protocol : this.getServiceTypes()) {
                if (log.isInfoEnabled()) {
                    log.info(String.format("Adding service listener for %s", protocol));
                }
                this.browsers.put(protocol, DNSSD.browse((String)protocol, (BrowseListener)this));
            }
        }
        catch (DNSSDException e) {
            log.error(String.format("Failure initializing Bonjour discovery: %s", e.getMessage()), (Throwable)e);
            this.quit();
        }
    }

    @Override
    public void quit() {
        for (String protocol : this.getServiceTypes()) {
            DNSSDService service;
            if (log.isInfoEnabled()) {
                log.info(String.format("Removing service listener for %s", protocol));
            }
            if (null == (service = this.browsers.get(protocol))) continue;
            service.stop();
        }
        super.quit();
    }

    public void serviceFound(DNSSDService browser, int flags, int ifIndex, String serviceName, String regType, String domain) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Browser found service at %s not yet resolved", serviceName));
        }
        try {
            DNSSD.resolve((int)flags, (int)ifIndex, (String)serviceName, (String)regType, (String)domain, (ResolveListener)this);
        }
        catch (DNSSDException e) {
            log.error(String.format("Failure resolving service %s: %s", serviceName, e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceLost(DNSSDService browser, int flags, int ifIndex, String serviceName, String regType, String domain) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Service lost for %s", serviceName));
        }
        ActionOperationBatcher autorelease = ActionOperationBatcherFactory.get();
        try {
            String identifier = DNSSD.constructFullName((String)serviceName, (String)regType, (String)domain);
            this.remove(identifier);
        }
        catch (DNSSDException e) {
            log.error(String.format("Failure removing service %s: %s", serviceName, e.getMessage()), (Throwable)e);
        }
        finally {
            autorelease.operate();
        }
    }

    public void operationFailed(DNSSDService resolver, int errorCode) {
        log.warn(String.format("Operation failed with error code %d", errorCode));
        resolver.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceResolved(DNSSDService resolver, int flags, int ifIndex, String fullname, String hostname, int port, TXTRecord txtRecord) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Resolved service with name %s to %s", fullname, hostname));
        }
        ActionOperationBatcher autorelease = ActionOperationBatcherFactory.get();
        try {
            String user = null;
            String password = null;
            String path = null;
            if (log.isDebugEnabled()) {
                log.debug(String.format("TXT Record %s", txtRecord));
            }
            if (txtRecord.contains("u")) {
                user = txtRecord.getValueAsString("u");
            }
            if (txtRecord.contains("p")) {
                password = txtRecord.getValueAsString("p");
            }
            if (txtRecord.contains("path")) {
                path = txtRecord.getValueAsString("path");
            }
            this.add(fullname, hostname, port, user, password, path);
        }
        finally {
            resolver.stop();
            autorelease.operate();
        }
    }
}

