/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.bonjour;

import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.bonjour.Rendezvous;
import ch.cyberduck.core.bonjour.RendezvousFactory;
import ch.cyberduck.core.bonjour.RendezvousListener;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public final class RendezvousCollection
extends AbstractHostCollection
implements RendezvousListener {
    private static final long serialVersionUID = 6468881403370416829L;
    private static RendezvousCollection RENDEZVOUS_COLLECTION;
    private static final Object lock;
    private final Rendezvous rendezvous;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RendezvousCollection defaultCollection() {
        Object object = lock;
        synchronized (object) {
            if (null == RENDEZVOUS_COLLECTION) {
                RENDEZVOUS_COLLECTION = new RendezvousCollection();
            }
            return RENDEZVOUS_COLLECTION;
        }
    }

    private RendezvousCollection() {
        this(RendezvousFactory.instance());
    }

    public RendezvousCollection(Rendezvous rendezvous) {
        this.rendezvous = rendezvous;
        this.rendezvous.addListener(this);
        this.collectionLoaded();
    }

    @Override
    public void serviceResolved(String identifier, Host host) {
        this.collectionItemAdded(host);
    }

    @Override
    public void serviceLost(Host host) {
        this.collectionItemRemoved(host);
    }

    public Host get(int row) {
        return this.rendezvous.getService(row);
    }

    public int size() {
        return this.rendezvous.numberOfServices();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Host remove(int row) {
        return null;
    }

    public Object[] toArray() {
        Object[] content = new Host[this.size()];
        int i = 0;
        Iterator<Host> iterator = this.iterator();
        while (iterator.hasNext()) {
            Host host = iterator.next();
            content[i] = host;
        }
        return content;
    }

    public Iterator<Host> iterator() {
        return this.rendezvous.iterator();
    }

    public Host lookup(String uuid) {
        for (int i = 0; i < this.rendezvous.numberOfServices(); ++i) {
            Host host = this.rendezvous.getService(i);
            if (!StringUtils.equals((CharSequence)uuid, (CharSequence)host.getUuid())) continue;
            return host;
        }
        return null;
    }

    public Spliterator<Host> spliterator() {
        throw new UnsupportedOperationException();
    }

    public Stream<Host> stream() {
        throw new UnsupportedOperationException();
    }

    public boolean allowsAdd() {
        return false;
    }

    public boolean allowsDelete() {
        return false;
    }

    public boolean allowsEdit() {
        return false;
    }

    static {
        lock = new Object();
    }
}

