/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn.matchers;

import com.nulabinc.zxcvbn.Context;
import com.nulabinc.zxcvbn.WipeableString;
import com.nulabinc.zxcvbn.matchers.BaseMatcher;
import com.nulabinc.zxcvbn.matchers.DictionaryMatcher;
import com.nulabinc.zxcvbn.matchers.Match;
import com.nulabinc.zxcvbn.matchers.MatchFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReverseDictionaryMatcher
extends BaseMatcher {
    private final Map<String, Map<String, Integer>> rankedDictionaries;

    public ReverseDictionaryMatcher(Context context, Map<String, Map<String, Integer>> rankedDictionaries) {
        super(context);
        this.rankedDictionaries = rankedDictionaries == null ? new HashMap<String, Map<String, Integer>>() : rankedDictionaries;
    }

    @Override
    public List<Match> execute(CharSequence password) {
        WipeableString reversedPassword = WipeableString.reversed(password);
        ArrayList<Match> matches = new ArrayList<Match>();
        for (Match match : new DictionaryMatcher(this.getContext(), this.rankedDictionaries).execute(reversedPassword)) {
            matches.add(MatchFactory.createReversedDictionaryMatch(password.length() - 1 - match.j, password.length() - 1 - match.i, WipeableString.reversed(match.token), match.matchedWord, match.rank, match.dictionaryName));
        }
        return this.sorted(matches);
    }
}

