/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.dropbox.DropboxAttributesFinderFeature;
import ch.cyberduck.core.dropbox.DropboxChecksumCompute;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxPathContainerService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.AbstractHttpWriteFeature;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.DefaultStreamCloser;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.files.CommitInfo;
import com.dropbox.core.v2.files.DbxUserFilesRequests;
import com.dropbox.core.v2.files.Metadata;
import com.dropbox.core.v2.files.UploadSessionAppendV2Uploader;
import com.dropbox.core.v2.files.UploadSessionCursor;
import com.dropbox.core.v2.files.UploadSessionFinishUploader;
import com.dropbox.core.v2.files.UploadSessionStartResult;
import com.dropbox.core.v2.files.UploadSessionStartUploader;
import com.dropbox.core.v2.files.WriteMode;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DropboxWriteFeature
extends AbstractHttpWriteFeature<Metadata> {
    private static final Logger log = LogManager.getLogger(DropboxWriteFeature.class);
    private final DropboxSession session;
    private final Long chunksize;
    private final PathContainerService containerService;

    public DropboxWriteFeature(DropboxSession session) {
        this(session, new HostPreferences(session.getHost()).getLong("dropbox.upload.chunksize"));
    }

    public DropboxWriteFeature(DropboxSession session, Long chunksize) {
        super((AttributesAdapter)new DropboxAttributesFinderFeature(session));
        this.session = session;
        this.chunksize = chunksize;
        this.containerService = new DropboxPathContainerService(session);
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return new Write.Append(false).withStatus(status);
    }

    public HttpResponseOutputStream<Metadata> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            DbxUserFilesRequests files = new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient(file));
            UploadSessionStartUploader start = files.uploadSessionStart();
            new DefaultStreamCloser().close(start.getOutputStream());
            String sessionId = ((UploadSessionStartResult)start.finish()).getSessionId();
            if (log.isDebugEnabled()) {
                log.debug(String.format("Obtained session id %s for upload %s", sessionId, file));
            }
            UploadSessionAppendV2Uploader uploader = this.open(files, sessionId, 0L);
            return new SegmentingUploadProxyOutputStream(file, status, files, uploader, sessionId);
        }
        catch (DbxException ex) {
            throw new DropboxExceptionMappingService().map("Upload failed.", ex, file);
        }
    }

    public boolean timestamp() {
        return true;
    }

    private UploadSessionAppendV2Uploader open(DbxUserFilesRequests files, String sessionId, Long offset) throws DbxException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Open next segment for upload session %s", sessionId));
        }
        return files.uploadSessionAppendV2(new UploadSessionCursor(sessionId, offset.longValue()));
    }

    private void close(UploadSessionAppendV2Uploader uploader) throws DbxException, IOException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Close uploader %s", uploader));
        }
        uploader.getOutputStream().close();
        uploader.finish();
    }

    public ChecksumCompute checksum(Path file, TransferStatus status) {
        return new DropboxChecksumCompute();
    }

    private final class SegmentingUploadProxyOutputStream
    extends HttpResponseOutputStream<Metadata> {
        private final Path file;
        private final TransferStatus status;
        private final DbxUserFilesRequests client;
        private final String sessionId;
        private final AtomicReference<Metadata> response;
        private Long offset;
        private Long written;
        private UploadSessionAppendV2Uploader uploader;

        public SegmentingUploadProxyOutputStream(Path file, TransferStatus status, DbxUserFilesRequests client, UploadSessionAppendV2Uploader uploader, String sessionId) {
            super(uploader.getOutputStream(), (AttributesAdapter)new DropboxAttributesFinderFeature(DropboxWriteFeature.this.session), status);
            this.response = new AtomicReference();
            this.offset = 0L;
            this.written = 0L;
            this.file = file;
            this.status = status;
            this.client = client;
            this.uploader = uploader;
            this.sessionId = sessionId;
        }

        protected void beforeWrite(int n) throws IOException {
            if (this.offset + (long)n > DropboxWriteFeature.this.chunksize) {
                try {
                    DropboxWriteFeature.this.close(this.uploader);
                    this.next();
                }
                catch (DbxException e) {
                    throw new IOException((Throwable)new DropboxExceptionMappingService().map(e));
                }
            }
        }

        private void next() throws DbxException {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Open next segment for upload session %s for file %s", this.sessionId, this.file));
            }
            this.uploader = DropboxWriteFeature.this.open(this.client, this.sessionId, this.written);
            this.out = this.uploader.getOutputStream();
            this.offset = 0L;
        }

        protected void afterWrite(int n) {
            this.offset = this.offset + (long)n;
            this.written = this.written + (long)n;
        }

        public Metadata getStatus() {
            return this.response.get();
        }

        public void close() throws IOException {
            try {
                DropboxWriteFeature.this.close(this.uploader);
                UploadSessionFinishUploader finish = this.client.uploadSessionFinish(new UploadSessionCursor(this.sessionId, this.written.longValue()), CommitInfo.newBuilder((String)DropboxWriteFeature.this.containerService.getKey(this.file)).withClientModified(this.status.getTimestamp() != null ? new Date(this.status.getTimestamp()) : null).withMode(WriteMode.OVERWRITE).build());
                finish.getOutputStream().close();
                this.response.set((Metadata)finish.finish());
            }
            catch (IllegalStateException finish) {
            }
            catch (DbxException e) {
                throw new IOException("Upload failed.", (Throwable)new DropboxExceptionMappingService().map(e));
            }
            finally {
                super.close();
            }
        }
    }
}

