/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.VersioningConfiguration;
import ch.cyberduck.core.dropbox.DropboxAttributesFinderFeature;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxPathContainerService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.features.Versioning;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.files.DbxUserFilesRequests;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.ListRevisionsResult;
import com.dropbox.core.v2.files.Metadata;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DropboxVersioningFeature
implements Versioning {
    private static final Logger log = LogManager.getLogger(DropboxVersioningFeature.class);
    private final DropboxSession session;
    private final PathContainerService containerService;

    public DropboxVersioningFeature(DropboxSession session) {
        this.session = session;
        this.containerService = new DropboxPathContainerService(session);
    }

    public VersioningConfiguration getConfiguration(Path container) {
        return VersioningConfiguration.empty();
    }

    public void setConfiguration(Path container, PasswordCallback prompt, VersioningConfiguration configuration) throws BackgroundException {
        throw new UnsupportedException();
    }

    public void revert(Path file) throws BackgroundException {
        try {
            new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient(file)).restore(this.containerService.getKey(file), file.attributes().getVersionId());
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
    }

    public boolean isRevertable(Path file) {
        return true;
    }

    public AttributedList<Path> list(final Path file, ListProgressListener listener) throws BackgroundException {
        try {
            AttributedList versions = new AttributedList();
            ListRevisionsResult result = new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient(file)).listRevisions(this.containerService.getKey(file));
            List entries = result.getEntries();
            DropboxAttributesFinderFeature attr = new DropboxAttributesFinderFeature(this.session);
            for (FileMetadata revision : entries) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Found revision %s", revision));
                }
                PathAttributes attributes = attr.toAttributes((Metadata)revision);
                attributes.setDuplicate(true);
                versions.add((Referenceable)new Path(file.getParent(), PathNormalizer.name((String)revision.getName()), file.getType(), attributes));
            }
            return versions.filter((Filter)new NullFilter<Path>(){

                public boolean accept(Path test) {
                    return !StringUtils.equals((CharSequence)test.attributes().getVersionId(), (CharSequence)file.attributes().getVersionId());
                }
            });
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
    }
}

