/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.dropbox.DropboxContentHasher;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.dropbox.DropboxWriteFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpUploadFeature;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.preferences.HostPreferences;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.Metadata;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DropboxUploadFeature
extends HttpUploadFeature<Metadata, MessageDigest> {
    private static final Logger log = LogManager.getLogger(DropboxUploadFeature.class);
    final DropboxSession session;

    public DropboxUploadFeature(DropboxSession session, DropboxWriteFeature writer) {
        super((Write)writer);
        this.session = session;
    }

    protected InputStream decorate(InputStream in, MessageDigest digest) throws IOException {
        if (null == digest) {
            log.warn("Checksum calculation disabled");
            return super.decorate(in, null);
        }
        return new DigestInputStream(in, digest);
    }

    protected MessageDigest digest() throws IOException {
        DropboxContentHasher digest = null;
        if (new HostPreferences(this.session.getHost()).getBoolean("queue.upload.checksum.calculate")) {
            try {
                digest = new DropboxContentHasher(MessageDigest.getInstance("SHA-256"), MessageDigest.getInstance("SHA-256"), 0);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        return digest;
    }

    protected void post(Path file, MessageDigest digest, Metadata response) throws BackgroundException {
        this.verify(file, digest, Checksum.parse((String)((FileMetadata)response).getContentHash()));
    }
}

