/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.dropbox.DropboxBatchDeleteFeature;
import ch.cyberduck.core.dropbox.DropboxDeleteFeature;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Map;

public class DropboxThresholdDeleteFeature
implements Delete {
    private final DropboxSession session;

    public DropboxThresholdDeleteFeature(DropboxSession session) {
        this.session = session;
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        if (files.size() == 1) {
            new DropboxDeleteFeature(this.session).delete(files, prompt, callback);
        } else {
            new DropboxBatchDeleteFeature(this.session).delete(files, prompt, callback);
        }
    }

    public boolean isRecursive() {
        return true;
    }

    public boolean isSupported(Path file) {
        return !file.attributes().isDuplicate();
    }
}

