/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.sharing.DbxUserSharingRequests;
import com.dropbox.core.v2.sharing.ListFoldersResult;
import com.dropbox.core.v2.sharing.SharedFolderMetadata;
import java.util.EnumSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DropboxSharedFoldersListService
implements ListService {
    private static final Logger log = LogManager.getLogger(DropboxSharedFoldersListService.class);
    private final DropboxSession session;

    public DropboxSharedFoldersListService(DropboxSession session) {
        this.session = session;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        try {
            AttributedList children = new AttributedList();
            ListFoldersResult listFoldersResult = new DbxUserSharingRequests((DbxRawClientV2)this.session.getClient()).listFolders();
            this.parse(directory, listener, (AttributedList<Path>)children, listFoldersResult);
            while (listFoldersResult.getCursor() != null) {
                listFoldersResult = new DbxUserSharingRequests((DbxRawClientV2)this.session.getClient()).listMountableFoldersContinue(listFoldersResult.getCursor());
                this.parse(directory, listener, (AttributedList<Path>)children, listFoldersResult);
            }
            return children;
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
    }

    private void parse(Path directory, ListProgressListener listener, AttributedList<Path> children, ListFoldersResult result) throws ConnectionCanceledException {
        for (SharedFolderMetadata metadata : result.getEntries()) {
            Path f = this.parse(directory, metadata);
            f.attributes().withFileId(metadata.getSharedFolderId());
            children.add((Referenceable)f);
            listener.chunk(directory, children);
        }
    }

    protected Path parse(Path directory, SharedFolderMetadata metadata) {
        PathAttributes attr = new PathAttributes();
        return new Path(directory, PathNormalizer.name((String)metadata.getName()), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.volume, AbstractPath.Type.shared), attr);
    }
}

