/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.dropbox.DropboxAttributesFinderFeature;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxPathContainerService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Search;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.files.DbxUserFilesRequests;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.FolderMetadata;
import com.dropbox.core.v2.files.Metadata;
import com.dropbox.core.v2.files.SearchMatchV2;
import com.dropbox.core.v2.files.SearchOptions;
import com.dropbox.core.v2.files.SearchV2Result;
import java.util.EnumSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DropboxSearchFeature
implements Search {
    private static final Logger log = LogManager.getLogger(DropboxSearchFeature.class);
    private final DropboxSession session;
    private final DropboxAttributesFinderFeature attributes;
    private final PathContainerService containerService;

    public DropboxSearchFeature(DropboxSession session) {
        this.session = session;
        this.attributes = new DropboxAttributesFinderFeature(session);
        this.containerService = new DropboxPathContainerService(session);
    }

    public AttributedList<Path> search(Path workdir, Filter<Path> regex, ListProgressListener listener) throws BackgroundException {
        try {
            AttributedList list = new AttributedList();
            long start = 0L;
            SearchV2Result result = new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient(workdir)).searchV2Builder(regex.toPattern().pattern()).withOptions(SearchOptions.newBuilder().withPath(this.containerService.getKey(workdir)).build()).start();
            this.parse(workdir, listener, (AttributedList<Path>)list, result);
            while (result.getHasMore()) {
                result = new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient(workdir)).searchContinueV2(result.getCursor());
                this.parse(workdir, listener, (AttributedList<Path>)list, result);
                if (!this.parse(workdir, listener, (AttributedList<Path>)list, result)) continue;
                return null;
            }
            return list;
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map("Failure to read attributes of {0}", e, workdir);
        }
    }

    protected boolean parse(Path workdir, ListProgressListener listener, AttributedList<Path> list, SearchV2Result result) throws ConnectionCanceledException {
        List matches = result.getMatches();
        for (SearchMatchV2 match : matches) {
            EnumSet<AbstractPath.Type> type;
            Metadata metadata = match.getMetadata().getMetadataValue();
            if (metadata instanceof FileMetadata) {
                type = EnumSet.of(AbstractPath.Type.file);
            } else if (metadata instanceof FolderMetadata) {
                type = EnumSet.of(AbstractPath.Type.directory);
            } else {
                log.warn(String.format("Skip file %s", metadata));
                return true;
            }
            list.add((Referenceable)new Path(metadata.getPathDisplay(), type, this.attributes.toAttributes(metadata)));
            listener.chunk(workdir, list);
        }
        return false;
    }

    public boolean isRecursive() {
        return true;
    }
}

