/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.IndexedListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxListService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.users.DbxUserUsersRequests;
import com.dropbox.core.v2.users.FullAccount;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DropboxRootListService
implements ListService {
    private static final Logger log = LogManager.getLogger(DropboxRootListService.class);
    private final DropboxSession session;

    public DropboxRootListService(DropboxSession session) {
        this.session = session;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        try {
            if (directory.isRoot()) {
                FullAccount account = new DbxUserUsersRequests((DbxRawClientV2)this.session.getClient()).getCurrentAccount();
                switch (account.getAccountType()) {
                    case BUSINESS: {
                        if (log.isInfoEnabled()) {
                            log.info("Connect to business account type");
                        }
                        return new DropboxListService(this.session).list(directory.withAttributes(new PathAttributes().withFileId(account.getRootInfo().getRootNamespaceId())), (ListProgressListener)new HomeNamespaceListProgressListener(listener, account));
                    }
                }
            }
            return new DropboxListService(this.session).list(directory, listener);
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
    }

    private static final class HomeNamespaceListProgressListener
    extends IndexedListProgressListener {
        private final ListProgressListener listener;
        private final FullAccount account;

        public HomeNamespaceListProgressListener(ListProgressListener listener, FullAccount account) {
            this.listener = listener;
            this.account = account;
        }

        public void chunk(Path folder, AttributedList<Path> list) throws ConnectionCanceledException {
            super.chunk(folder, list);
            this.listener.chunk(folder, list);
        }

        public void visit(AttributedList<Path> list, int index, Path file) {
            if (StringUtils.isBlank((CharSequence)file.attributes().getFileId()) && file.isVolume()) {
                file.attributes().setFileId(this.account.getRootInfo().getHomeNamespaceId());
            }
        }

        public void message(String message) {
            this.listener.message(message);
        }
    }
}

