/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxPathContainerService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dropbox.core.DbxDownloader;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.files.DbxUserFilesRequests;
import com.dropbox.core.v2.files.DownloadBuilder;
import java.io.InputStream;

public class DropboxReadFeature
implements Read {
    private final DropboxSession session;
    private final PathContainerService containerService;

    public DropboxReadFeature(DropboxSession session) {
        this.session = session;
        this.containerService = new DropboxPathContainerService(session);
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            DownloadBuilder builder = new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient(file)).downloadBuilder(this.containerService.getKey(file)).withRev(file.attributes().getVersionId());
            if (status.isAppend()) {
                HttpRange range = HttpRange.withStatus((TransferStatus)status);
                builder.range(range.getStart());
            }
            DbxDownloader downloader = builder.start();
            return downloader.getInputStream();
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map("Download {0} failed", e, file);
        }
    }
}

