/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.dropbox.DropboxAttributesFinderFeature;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxPathContainerService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.dropbox.DropboxTouchFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.files.CreateFolderResult;
import com.dropbox.core.v2.files.DbxUserFilesRequests;
import com.dropbox.core.v2.files.Metadata;

public class DropboxDirectoryFeature
implements Directory<String> {
    private final DropboxSession session;
    private final PathContainerService containerService;

    public DropboxDirectoryFeature(DropboxSession session) {
        this.session = session;
        this.containerService = new DropboxPathContainerService(session);
    }

    public Path mkdir(Path folder, TransferStatus status) throws BackgroundException {
        try {
            CreateFolderResult result = new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient(folder.getParent())).createFolderV2(this.containerService.getKey(folder), false);
            return folder.withAttributes(new DropboxAttributesFinderFeature(this.session).toAttributes((Metadata)result.getMetadata()));
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map("Cannot create folder {0}", e, folder);
        }
    }

    public boolean isSupported(Path workdir, String name) {
        return new DropboxTouchFeature(this.session).isSupported(workdir, name);
    }

    public DropboxDirectoryFeature withWriter(Write<String> writer) {
        return this;
    }
}

