/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxPathContainerService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.files.DbxUserFilesRequests;
import java.util.Map;

public class DropboxDeleteFeature
implements Delete {
    private final DropboxSession session;
    private final PathContainerService containerService;

    public DropboxDeleteFeature(DropboxSession session) {
        this.session = session;
        this.containerService = new DropboxPathContainerService(session);
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        for (Path file : files.keySet()) {
            try {
                callback.delete(file);
                if (this.containerService.isContainer(file)) {
                    new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient(file.getParent())).deleteV2(file.getAbsolute());
                    continue;
                }
                if (file.attributes().isDuplicate()) {
                    new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient(file)).permanentlyDelete(this.containerService.getKey(file), file.attributes().getVersionId());
                    continue;
                }
                new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient(file)).deleteV2(this.containerService.getKey(file));
            }
            catch (DbxException e) {
                throw new DropboxExceptionMappingService().map("Cannot delete {0}", e, file);
            }
        }
    }

    public boolean isRecursive() {
        return true;
    }

    public boolean isSupported(Path file) {
        return !file.attributes().isDuplicate();
    }
}

