/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.dropbox.DropboxAttributesFinderFeature;
import ch.cyberduck.core.dropbox.DropboxDeleteFeature;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxPathContainerService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.files.DbxUserFilesRequests;
import com.dropbox.core.v2.files.RelocationResult;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DropboxCopyFeature
implements Copy {
    private static final Logger log = LogManager.getLogger(DropboxCopyFeature.class);
    private final DropboxSession session;
    private final PathContainerService containerService;

    public DropboxCopyFeature(DropboxSession session) {
        this.session = session;
        this.containerService = new DropboxPathContainerService(session);
    }

    public Path copy(Path file, Path target, TransferStatus status, ConnectionCallback callback, StreamListener listener) throws BackgroundException {
        try {
            if (status.isExists()) {
                if (log.isWarnEnabled()) {
                    log.warn(String.format("Delete file %s to be replaced with %s", target, file));
                }
                new DropboxDeleteFeature(this.session).delete(Collections.singletonMap(target, status), (PasswordCallback)callback, (Delete.Callback)new Delete.DisabledCallback());
            }
            RelocationResult result = new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient(file)).copyV2(this.containerService.getKey(file), this.containerService.getKey(target));
            listener.sent(status.getLength());
            return target.withAttributes(new DropboxAttributesFinderFeature(this.session).toAttributes(result.getMetadata()));
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map("Cannot copy {0}", e, file);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }
}

