/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.threading.LoggingUncaughtExceptionHandler;
import ch.cyberduck.core.threading.ScheduledThreadPool;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.files.DbxUserFilesRequests;
import com.dropbox.core.v2.files.DeleteArg;
import com.dropbox.core.v2.files.DeleteBatchJobStatus;
import com.dropbox.core.v2.files.DeleteBatchLaunch;
import com.dropbox.core.v2.files.DeleteBatchResultEntry;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Uninterruptibles;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class DropboxBatchDeleteFeature
implements Delete {
    private final DropboxSession session;

    public DropboxBatchDeleteFeature(DropboxSession session) {
        this.session = session;
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        final CountDownLatch signal = new CountDownLatch(1);
        final AtomicReference failure = new AtomicReference();
        ScheduledThreadPool scheduler = new ScheduledThreadPool((Thread.UncaughtExceptionHandler)new LoggingUncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                super.uncaughtException(t, e);
                failure.set(new BackgroundException(e));
                signal.countDown();
            }
        });
        try {
            for (Path f2 : files.keySet()) {
                callback.delete(f2);
            }
            DbxUserFilesRequests requests = new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient());
            DeleteBatchLaunch job = requests.deleteBatch(files.keySet().stream().map(f -> new DeleteArg(f.getAbsolute())).collect(Collectors.toList()));
            ScheduledFuture f3 = scheduler.repeat(() -> {
                try {
                    DeleteBatchJobStatus status = requests.deleteBatchCheck(job.getAsyncJobIdValue());
                    if (status.isComplete()) {
                        List entries = status.getCompleteValue().getEntries();
                        block5: for (DeleteBatchResultEntry entry : entries) {
                            if (!entry.isFailure()) continue;
                            switch (entry.getFailureValue().tag()) {
                                case PATH_LOOKUP: {
                                    failure.set(new NotfoundException(entry.getFailureValue().toString()));
                                    continue block5;
                                }
                            }
                            failure.set(new InteroperabilityException());
                        }
                        signal.countDown();
                    }
                    if (status.isFailed()) {
                        signal.countDown();
                    }
                }
                catch (DbxException e) {
                    failure.set(new DropboxExceptionMappingService().map(e));
                    signal.countDown();
                }
            }, Long.valueOf(new HostPreferences(this.session.getHost()).getLong("dropbox.delete.poll.interval.ms")), TimeUnit.MILLISECONDS);
            while (!Uninterruptibles.awaitUninterruptibly((CountDownLatch)signal, (Duration)Duration.ofSeconds(1L))) {
                try {
                    if (!f3.isDone()) continue;
                    Uninterruptibles.getUninterruptibly((Future)f3);
                }
                catch (ExecutionException e) {
                    Throwables.throwIfInstanceOf((Throwable)Throwables.getRootCause((Throwable)e), BackgroundException.class);
                    throw new DefaultExceptionMappingService().map(Throwables.getRootCause((Throwable)e));
                }
            }
            if (null != failure.get()) {
                throw (BackgroundException)failure.get();
            }
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map(e);
        }
        finally {
            scheduler.shutdown();
        }
    }

    public boolean isRecursive() {
        return true;
    }

    public boolean isSupported(Path file) {
        return !file.attributes().isDuplicate();
    }
}

