/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxPathContainerService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.HashAlgorithm;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.files.DbxUserFilesRequests;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.FolderMetadata;
import com.dropbox.core.v2.files.Metadata;
import com.dropbox.core.v2.users.DbxUserUsersRequests;
import com.dropbox.core.v2.users.FullAccount;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DropboxAttributesFinderFeature
implements AttributesFinder,
AttributesAdapter<Metadata> {
    private static final Logger log = LogManager.getLogger(DropboxAttributesFinderFeature.class);
    private final DropboxSession session;
    private final PathContainerService containerService;

    public DropboxAttributesFinderFeature(DropboxSession session) {
        this.session = session;
        this.containerService = new DropboxPathContainerService(session);
    }

    public PathAttributes find(Path file, ListProgressListener listener) throws BackgroundException {
        try {
            if (file.isRoot()) {
                FullAccount account = new DbxUserUsersRequests((DbxRawClientV2)this.session.getClient()).getCurrentAccount();
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Set root namespace %s", account.getRootInfo().getRootNamespaceId()));
                }
                return new PathAttributes().withFileId(account.getRootInfo().getRootNamespaceId());
            }
            Metadata metadata = new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient(file)).getMetadata(this.containerService.getKey(file));
            if (metadata instanceof FileMetadata && file.isDirectory()) {
                throw new NotfoundException(file.getAbsolute());
            }
            if (metadata instanceof FolderMetadata && file.isFile()) {
                throw new NotfoundException(file.getAbsolute());
            }
            return this.toAttributes(metadata);
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
    }

    public PathAttributes toAttributes(Metadata metadata) {
        PathAttributes attributes = new PathAttributes();
        if (metadata instanceof FileMetadata) {
            FileMetadata file = (FileMetadata)metadata;
            attributes.setSize(file.getSize());
            attributes.setModificationDate(file.getClientModified().getTime());
            if (file.getFileLockInfo() != null) {
                attributes.setLockId(String.valueOf(file.getFileLockInfo().getIsLockholder()));
            }
            attributes.setChecksum(new Checksum(HashAlgorithm.dropbox_content_hash, file.getContentHash()));
            attributes.setVersionId(file.getRev());
        }
        if (metadata instanceof FolderMetadata) {
            FolderMetadata folder = (FolderMetadata)metadata;
            attributes.setFileId(folder.getSharedFolderId());
        }
        return attributes;
    }
}

