/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.PasswordStore;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.importer.ThirdpartyBookmarkCollection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class XmlBookmarkCollection
extends ThirdpartyBookmarkCollection {
    private static final Logger log = LogManager.getLogger(XmlBookmarkCollection.class);
    private static final long serialVersionUID = -3145592458663362423L;

    public XmlBookmarkCollection() {
    }

    public XmlBookmarkCollection(PasswordStore keychain) {
        super(keychain);
    }

    protected abstract AbstractHandler getHandler(ProtocolFactory var1);

    @Override
    protected void parse(ProtocolFactory protocols, Local file) throws AccessDeniedException {
        this.read(protocols, file);
    }

    protected void read(ProtocolFactory protocols, Local child) throws AccessDeniedException {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(child.getInputStream(), StandardCharsets.UTF_8));
            AbstractHandler handler = this.getHandler(protocols);
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setContentHandler(handler);
            xr.setErrorHandler(handler);
            xr.parse(new InputSource(in));
        }
        catch (IOException | SAXException e) {
            log.error(String.format("Error reading %s:%s", this.getFile(), e.getMessage()));
        }
    }

    protected static abstract class AbstractHandler
    extends DefaultHandler {
        private StringBuilder currentText = null;

        protected AbstractHandler() {
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) {
            this.currentText = new StringBuilder();
            this.startElement(name, attrs);
        }

        public abstract void startElement(String var1, Attributes var2);

        @Override
        public void endElement(String uri, String name, String qName) {
            String elementText = this.currentText.toString();
            this.endElement(name, elementText);
        }

        public abstract void endElement(String var1, String var2);

        @Override
        public void characters(char[] ch, int start, int length) {
            this.currentText.append(ch, start, length);
        }
    }
}

