/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSData;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSEnumerator;
import ch.cyberduck.binding.foundation.NSKeyedUnarchiver;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.importer.ThirdpartyBookmarkCollection;
import ch.cyberduck.core.preferences.PreferencesFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rococoa.ObjCClass;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;

public class Transmit3BookmarkCollection
extends ThirdpartyBookmarkCollection {
    private static final Logger log = LogManager.getLogger(Transmit3BookmarkCollection.class);
    private static final long serialVersionUID = 6406786269501430927L;

    @Override
    public Local getFile() {
        return LocalFactory.get((String)PreferencesFactory.get().getProperty("bookmark.import.transmit3.location"));
    }

    @Override
    public String getBundleIdentifier() {
        return "com.panic.Transmit";
    }

    @Override
    public String getName() {
        return "Transmit 3";
    }

    @Override
    protected void parse(ProtocolFactory protocols, Local file) throws AccessDeniedException {
        NSObject next;
        NSDictionary serialized = NSDictionary.dictionaryWithContentsOfFile((String)file.getAbsolute());
        if (null == serialized) {
            throw new LocalAccessDeniedException(String.format("Invalid bookmark file %s", file));
        }
        TransmitFavoriteCollection c = (TransmitFavoriteCollection)Rococoa.createClass((String)"TransmitFavoriteCollection", TransmitFavoriteCollection.class);
        TransmitFavorite f = (TransmitFavorite)Rococoa.createClass((String)"TransmitFavorite", TransmitFavorite.class);
        NSData collectionsData = (NSData)Rococoa.cast((ObjCObject)serialized.objectForKey("FavoriteCollections"), NSData.class);
        if (null == collectionsData) {
            throw new LocalAccessDeniedException(String.format("Error unarchiving bookmark file %s", file));
        }
        NSKeyedUnarchiver reader = NSKeyedUnarchiver.createForReadingWithData((NSData)collectionsData);
        reader.setClass_forClassName((ObjCClass)c, "FavoriteCollection");
        reader.setClass_forClassName((ObjCClass)c, "HistoryCollection");
        reader.setClass_forClassName((ObjCClass)f, "Favorite");
        reader.setClass_forClassName((ObjCClass)f, "DotMacFavorite");
        if (!reader.containsValueForKey("FavoriteCollection")) {
            log.warn("Missing key FavoriteCollection");
            return;
        }
        TransmitFavoriteCollection rootCollection = (TransmitFavoriteCollection)Rococoa.cast((ObjCObject)reader.decodeObjectForKey("FavoriteCollection"), TransmitFavoriteCollection.class);
        reader.finishDecoding();
        if (null == rootCollection) {
            throw new LocalAccessDeniedException(String.format("Error unarchiving bookmark file %s", file));
        }
        NSArray collections = rootCollection.favorites();
        NSEnumerator collectionsEnumerator = collections.objectEnumerator();
        while ((next = collectionsEnumerator.nextObject()) != null) {
            NSObject favorite;
            TransmitFavoriteCollection collection = (TransmitFavoriteCollection)Rococoa.cast((ObjCObject)next, TransmitFavoriteCollection.class);
            if ("History".equals(collection.name())) continue;
            NSArray favorites = collection.favorites();
            NSEnumerator favoritesEnumerator = favorites.objectEnumerator();
            while ((favorite = favoritesEnumerator.nextObject()) != null) {
                this.parse(protocols, (TransmitFavorite)Rococoa.cast((ObjCObject)favorite, TransmitFavorite.class));
            }
        }
    }

    private void parse(ProtocolFactory protocols, TransmitFavorite favorite) {
        String user;
        Protocol protocol;
        String protocolstring;
        String server = favorite.server();
        if (StringUtils.isBlank((CharSequence)server)) {
            return;
        }
        int port = favorite.port();
        if (0 == port) {
            port = -1;
        }
        if (StringUtils.isBlank((CharSequence)(protocolstring = favorite.protocol()))) {
            log.warn("Unknown protocol:" + protocolstring);
            return;
        }
        switch (protocolstring) {
            case "FTP": {
                protocol = protocols.forScheme(Scheme.ftp);
                break;
            }
            case "SFTP": {
                protocol = protocols.forScheme(Scheme.sftp);
                break;
            }
            case "FTPTLS": 
            case "FTPSSL": {
                protocol = protocols.forScheme(Scheme.ftps);
                break;
            }
            case "S3": {
                protocol = protocols.forScheme(Scheme.s3);
                break;
            }
            case "WebDAV": {
                protocol = protocols.forScheme(Scheme.dav);
                break;
            }
            case "WebDAVS": {
                protocol = protocols.forScheme(Scheme.davs);
                break;
            }
            default: {
                log.warn(String.format("Unknown protocol %s", protocolstring));
                return;
            }
        }
        Host bookmark = new Host(protocol, server, port);
        String nickname = favorite.nickname();
        if (StringUtils.isNotBlank((CharSequence)nickname)) {
            bookmark.setNickname(nickname);
        }
        if (StringUtils.isNotBlank((CharSequence)(user = favorite.username()))) {
            bookmark.setCredentials(new Credentials(user));
        } else {
            bookmark.getCredentials().setUsername(PreferencesFactory.get().getProperty("connection.login.anon.name"));
        }
        String path = favorite.path();
        if (StringUtils.isNotBlank((CharSequence)path)) {
            bookmark.setDefaultPath(path);
        }
        this.add(bookmark);
    }

    public static interface TransmitFavoriteCollection
    extends ObjCClass {
        public String name();

        public NSArray favorites();
    }

    public static interface TransmitFavorite
    extends ObjCClass {
        public String server();

        public String nickname();

        public String username();

        public String protocol();

        public String path();

        public int port();
    }
}

