/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.PasswordStore;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ThirdpartyBookmarkCollection
extends Collection<Host> {
    private static final Logger log = LogManager.getLogger(ThirdpartyBookmarkCollection.class);
    private final Preferences preferences = PreferencesFactory.get();
    private final PasswordStore keychain;

    public ThirdpartyBookmarkCollection() {
        this.keychain = PasswordStoreFactory.get();
    }

    public ThirdpartyBookmarkCollection(PasswordStore keychain) {
        this.keychain = keychain;
    }

    public void load() throws AccessDeniedException {
        Local file = this.getFile();
        if (file.exists()) {
            if (log.isInfoEnabled()) {
                log.info(String.format("Found bookmarks file at %s", file));
            }
            Checksum current = Checksum.NONE;
            if (file.isFile()) {
                try {
                    current = ChecksumComputeFactory.get((HashAlgorithm)HashAlgorithm.md5).compute(file.getInputStream(), new TransferStatus());
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Current checksum for %s is %s", file, current));
                    }
                }
                catch (BackgroundException e) {
                    log.warn(String.format("Failure obtaining checksum for %s", file));
                }
            }
            if (this.preferences.getBoolean(this.getConfiguration())) {
                Checksum previous = new Checksum(HashAlgorithm.md5, this.preferences.getProperty(String.format("%s.checksum", this.getConfiguration())));
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Saved previous checksum %s for bookmark %s", previous, file));
                }
                if (StringUtils.isNotBlank((CharSequence)previous.hash)) {
                    if (previous.equals((Object)current)) {
                        if (log.isInfoEnabled()) {
                            log.info(String.format("Skip importing bookmarks from %s with previously saved checksum %s", file, previous));
                        }
                    } else if (log.isInfoEnabled()) {
                        log.info(String.format("Checksum changed for bookmarks file at %s", file));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug(String.format("Skip importing bookmarks from %s", file));
                }
            } else {
                this.parse(ProtocolFactory.get(), file);
            }
            if (current != null) {
                this.preferences.setProperty(String.format("%s.checksum", this.getConfiguration()), current.hash);
            }
        } else if (log.isInfoEnabled()) {
            log.info(String.format("No bookmarks file at %s", file));
        }
        super.load();
    }

    public abstract String getName();

    public abstract Local getFile();

    protected void parse(Local file) throws AccessDeniedException {
        this.parse(ProtocolFactory.get(), file);
    }

    protected abstract void parse(ProtocolFactory var1, Local var2) throws AccessDeniedException;

    public boolean isInstalled() {
        return this.getFile().exists();
    }

    public abstract String getBundleIdentifier();

    public String getConfiguration() {
        return String.format("bookmark.import.%s", this.getBundleIdentifier());
    }

    public boolean add(Host bookmark) {
        Credentials credentials;
        if (null == bookmark) {
            log.warn("Parsing bookmark failed.");
            return false;
        }
        StringBuilder comment = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)bookmark.getComment())) {
            comment.append(bookmark.getComment());
            if (!comment.toString().endsWith(".")) {
                comment.append(".");
            }
            comment.append(" ");
        }
        comment.append(MessageFormat.format(LocaleFactory.localizedString((String)"Imported from {0}", (String)"Configuration"), this.getName()));
        bookmark.setComment(comment.toString());
        if (log.isDebugEnabled()) {
            log.debug(String.format("Create new bookmark from import %s", bookmark));
        }
        if (StringUtils.isNotBlank((CharSequence)(credentials = bookmark.getCredentials()).getPassword())) {
            if (credentials.isPublicKeyAuthentication()) {
                try {
                    this.keychain.addPassword(bookmark.getHostname(), credentials.getIdentity().getAbbreviatedPath(), credentials.getPassword());
                }
                catch (LocalAccessDeniedException e) {
                    log.error(String.format("Failure %s saving credentials for %s in password store", new Object[]{e, bookmark}));
                }
            } else if (!credentials.isAnonymousLogin()) {
                try {
                    this.keychain.addPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), bookmark.getHostname(), credentials.getUsername(), credentials.getPassword());
                }
                catch (LocalAccessDeniedException e) {
                    log.error(String.format("Failure %s saving credentials for %s in password store", new Object[]{e, bookmark}));
                }
                credentials.setPassword(null);
            }
        }
        return super.add((Object)bookmark);
    }

    public void filter(AbstractHostCollection bookmarks) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Host i = (Host)iter.next();
            if (!bookmarks.find((Predicate)new AbstractHostCollection.HostComparePredicate(i)).isPresent()) continue;
            if (log.isInfoEnabled()) {
                log.info(String.format("Remove %s from import as we found it in bookmarks", i));
            }
            iter.remove();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ThirdpartyBookmarkCollection{");
        sb.append("file=").append(this.getFile());
        sb.append('}');
        return sb.toString();
    }
}

