/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.importer.ThirdpartyBookmarkCollection;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class FlashFxpBookmarkCollection
extends ThirdpartyBookmarkCollection {
    private static final Logger log = LogManager.getLogger(FlashFxpBookmarkCollection.class);
    private static final long serialVersionUID = 5122804563710604658L;

    @Override
    protected void parse(ProtocolFactory protocols, Local file) throws AccessDeniedException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            Host current = null;
            while ((line = in.readLine()) != null) {
                if (line.startsWith("[")) {
                    current = new Host(protocols.forScheme(Scheme.ftp));
                    current.getCredentials().setUsername(PreferencesFactory.get().getProperty("connection.login.anon.name"));
                    Pattern pattern = Pattern.compile("\\[(.*)\\]");
                    Matcher matcher = pattern.matcher(line);
                    if (!matcher.matches()) continue;
                    current.setNickname(matcher.group(1));
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)line)) {
                    this.add(current);
                    current = null;
                    continue;
                }
                if (null == current) {
                    log.warn("Failed to detect start of bookmark");
                    continue;
                }
                Scanner scanner = new Scanner(line);
                scanner.useDelimiter("=");
                if (!scanner.hasNext()) {
                    log.warn("Missing key in line:" + line);
                    continue;
                }
                String name = scanner.next().toLowerCase(Locale.ROOT);
                if (!scanner.hasNext()) {
                    log.warn("Missing value in line:" + line);
                    continue;
                }
                String value = scanner.next();
                switch (name) {
                    case "ip": {
                        current.setHostname(StringUtils.substringBefore((String)value, (String)"\u0001"));
                        break;
                    }
                    case "port": {
                        try {
                            current.setPort(Integer.parseInt(value));
                        }
                        catch (NumberFormatException e) {
                            log.warn("Invalid Port:" + e.getMessage());
                        }
                        break;
                    }
                    case "path": {
                        current.setDefaultPath(value);
                        break;
                    }
                    case "notes": {
                        current.setComment(value);
                        break;
                    }
                    case "user": {
                        current.getCredentials().setUsername(value);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new AccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }
}

