/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.ftp.FTPConnectMode;
import ch.cyberduck.core.importer.ThirdpartyBookmarkCollection;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FireFtpBookmarkCollection
extends ThirdpartyBookmarkCollection {
    private static final Logger log = LogManager.getLogger(FireFtpBookmarkCollection.class);
    private static final long serialVersionUID = -1802799231453221690L;

    @Override
    public String getBundleIdentifier() {
        return "org.mozdev.fireftp";
    }

    @Override
    public String getName() {
        return "FireFTP";
    }

    @Override
    public Local getFile() {
        return LocalFactory.get((String)PreferencesFactory.get().getProperty("bookmark.import.fireftp.location"));
    }

    @Override
    protected void parse(ProtocolFactory protocols, Local folder) throws AccessDeniedException {
        for (Local settings : folder.list().filter((Filter)new NullFilter<Local>(){

            public boolean accept(Local file) {
                return file.isDirectory();
            }
        })) {
            for (Local child : settings.list().filter((Filter)new NullFilter<Local>(){

                public boolean accept(Local file) {
                    if (file.isFile()) {
                        return "fireFTPsites.dat".equals(file.getName());
                    }
                    return false;
                }
            })) {
                this.read(protocols, child);
            }
        }
    }

    protected void read(ProtocolFactory protocols, Local file) throws AccessDeniedException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8));){
            String l;
            while ((l = in.readLine()) != null) {
                Matcher array = Pattern.compile("\\[(.*?)\\]").matcher(l);
                while (array.find()) {
                    Matcher entries = Pattern.compile("\\{(.*?)\\}").matcher(array.group(1));
                    while (entries.find()) {
                        String entry = entries.group(1);
                        this.read(protocols, entry);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new AccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }

    private void read(ProtocolFactory protocols, String entry) {
        Host current = new Host(protocols.forScheme(Scheme.ftp));
        current.getCredentials().setUsername(PreferencesFactory.get().getProperty("connection.login.anon.name"));
        block32: for (String attribute : entry.split(", ")) {
            Scanner scanner = new Scanner(attribute);
            scanner.useDelimiter(":");
            if (!scanner.hasNext()) {
                log.warn("Missing key in line:" + attribute);
                continue;
            }
            String name = scanner.next().toLowerCase(Locale.ROOT);
            if (!scanner.hasNext()) {
                log.warn("Missing value in line:" + attribute);
                continue;
            }
            String value = scanner.next().replaceAll("\"", "");
            switch (name) {
                case "host": {
                    current.setHostname(value);
                    continue block32;
                }
                case "port": {
                    try {
                        current.setPort(Integer.parseInt(value));
                    }
                    catch (NumberFormatException e) {
                        log.warn("Invalid Port:" + e.getMessage());
                    }
                    continue block32;
                }
                case "remotedir": {
                    current.setDefaultPath(value);
                    continue block32;
                }
                case "webhost": {
                    current.setWebURL(value);
                    continue block32;
                }
                case "encoding": {
                    current.setEncoding(value);
                    continue block32;
                }
                case "notes": {
                    current.setComment(value);
                    continue block32;
                }
                case "account": {
                    current.setNickname(value);
                    continue block32;
                }
                case "privatekey": {
                    current.getCredentials().setIdentity(LocalFactory.get((String)value));
                    continue block32;
                }
                case "pasvmode": {
                    if (Boolean.TRUE.toString().equals(value)) {
                        current.setFTPConnectMode(FTPConnectMode.passive);
                    }
                    if (!Boolean.FALSE.toString().equals(value)) continue block32;
                    current.setFTPConnectMode(FTPConnectMode.active);
                    continue block32;
                }
                case "login": {
                    current.getCredentials().setUsername(value);
                    continue block32;
                }
                case "password": {
                    current.getCredentials().setPassword(value);
                    continue block32;
                }
                case "anonymous": {
                    if (!Boolean.TRUE.toString().equals(value)) continue block32;
                    current.getCredentials().setUsername(PreferencesFactory.get().getProperty("connection.login.anon.name"));
                    continue block32;
                }
                case "security": {
                    if ("authtls".equals(value)) {
                        current.setProtocol(protocols.forScheme(Scheme.ftps));
                        current.setPort(-1);
                    }
                    if (!"sftp".equals(value)) continue block32;
                    current.setProtocol(protocols.forScheme(Scheme.sftp));
                    current.setPort(-1);
                }
            }
        }
        this.add(current);
    }
}

