/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.importer.XmlBookmarkCollection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.Attributes;

public abstract class CloudberryBookmarkCollection
extends XmlBookmarkCollection {
    private static final Logger log = LogManager.getLogger(CloudberryBookmarkCollection.class);
    private static final long serialVersionUID = 2245328157886337606L;

    @Override
    protected XmlBookmarkCollection.AbstractHandler getHandler(ProtocolFactory protocols) {
        return new ServerHandler(protocols);
    }

    private class ServerHandler
    extends XmlBookmarkCollection.AbstractHandler {
        private final ProtocolFactory protocols;
        private Host current = null;

        public ServerHandler(ProtocolFactory protocols) {
            this.protocols = protocols;
        }

        @Override
        public void startElement(String name, Attributes attrs) {
            block3 : switch (name) {
                case "Settings": {
                    String type;
                    switch (type = attrs.getValue("xsi:type")) {
                        case "GoogleSettings": {
                            this.current = new Host(this.protocols.forType(Protocol.Type.googlestorage));
                            break block3;
                        }
                        case "S3Settings": 
                        case "DunkelSettings": {
                            this.current = new Host(this.protocols.forType(Protocol.Type.s3));
                            break block3;
                        }
                    }
                    log.warn("Unsupported connection type:" + type);
                }
            }
        }

        @Override
        public void endElement(String name, String elementText) {
            if (null == this.current) {
                return;
            }
            switch (name) {
                case "ServicePoint": {
                    this.current.setHostname(elementText);
                    break;
                }
                case "AWSKey": {
                    this.current.getCredentials().setUsername(elementText);
                    break;
                }
                case "Account": {
                    this.current.getCredentials().setUsername(elementText);
                    break;
                }
                case "SharedKey": {
                    this.current.getCredentials().setPassword(elementText);
                    break;
                }
                case "Name": {
                    this.current.setNickname(elementText);
                    break;
                }
                case "Settings": {
                    CloudberryBookmarkCollection.this.add(this.current);
                    this.current = null;
                }
            }
        }
    }
}

