/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.toolbar;

import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSPasteboard;
import ch.cyberduck.binding.application.NSPopUpButton;
import ch.cyberduck.binding.application.NSToolbarItem;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Archive;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.TerminalServiceFactory;
import ch.cyberduck.core.editor.EditorFactory;
import ch.cyberduck.core.features.Command;
import ch.cyberduck.core.features.Compress;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.features.Restore;
import ch.cyberduck.core.features.Symlink;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.core.vault.VaultRegistry;
import ch.cyberduck.ui.browser.UploadTargetFinder;
import ch.cyberduck.ui.cocoa.controller.BrowserController;
import ch.cyberduck.ui.cocoa.toolbar.BrowserToolbarFactory;
import ch.cyberduck.ui.cocoa.toolbar.ToolbarValidator;
import java.util.function.Predicate;
import org.rococoa.Foundation;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;
import org.rococoa.Selector;

public class BrowserToolbarValidator
implements ToolbarValidator {
    private final BrowserController controller;

    public BrowserToolbarValidator(BrowserController controller) {
        this.controller = controller;
    }

    @Override
    public boolean validate(NSToolbarItem item) {
        String identifier = item.itemIdentifier();
        switch (BrowserToolbarFactory.BrowserToolbarItem.valueOf(identifier)) {
            case disconnect: {
                if (!this.controller.isIdle()) {
                    item.setLabel(BrowserToolbarFactory.BrowserToolbarItem.stop.label());
                    item.setPaletteLabel(BrowserToolbarFactory.BrowserToolbarItem.stop.label());
                    item.setToolTip(BrowserToolbarFactory.BrowserToolbarItem.stop.tooltip());
                    item.setImage(BrowserToolbarFactory.BrowserToolbarItem.stop.image());
                    break;
                }
                item.setLabel(BrowserToolbarFactory.BrowserToolbarItem.disconnect.label());
                item.setPaletteLabel(BrowserToolbarFactory.BrowserToolbarItem.disconnect.label());
                item.setToolTip(BrowserToolbarFactory.BrowserToolbarItem.disconnect.tooltip());
                item.setImage(BrowserToolbarFactory.BrowserToolbarItem.disconnect.image());
                break;
            }
            case archive: {
                Path selected = this.controller.getSelectedPath();
                if (null == selected) break;
                if (Archive.isArchive((String)selected.getName())) {
                    item.setLabel(BrowserToolbarFactory.BrowserToolbarItem.unarchive.label());
                    item.setPaletteLabel(BrowserToolbarFactory.BrowserToolbarItem.unarchive.label());
                    item.setAction(BrowserToolbarFactory.BrowserToolbarItem.unarchive.action());
                    break;
                }
                item.setLabel(BrowserToolbarFactory.BrowserToolbarItem.archive.label());
                item.setPaletteLabel(BrowserToolbarFactory.BrowserToolbarItem.archive.label());
                item.setAction(BrowserToolbarFactory.BrowserToolbarItem.archive.action());
                break;
            }
            case encoding: {
                NSPopUpButton popup = (NSPopUpButton)Rococoa.cast((ObjCObject)item.view(), NSPopUpButton.class);
                popup.selectItemAtIndex(popup.indexOfItemWithRepresentedObject(this.controller.isMounted() ? this.controller.getSession().getHost().getEncoding() : PreferencesFactory.get().getProperty("browser.charset.encoding")));
            }
            case cryptomator: {
                Path selected = new UploadTargetFinder(this.controller.workdir()).find(this.controller.getSelectedPath());
                VaultRegistry registry = this.controller.getSession().getVault();
                if (registry.contains(selected)) {
                    item.setImage((NSImage)IconCacheFactory.get().iconNamed("NSLockUnlockedTemplate"));
                    break;
                }
                item.setImage((NSImage)IconCacheFactory.get().iconNamed("NSLockLockedTemplate"));
            }
        }
        return this.validate(item.action());
    }

    @Override
    public boolean validate(Selector action) {
        if (action.equals((Object)Foundation.selector((String)"cut:"))) {
            return this.isBrowser() && this.controller.isMounted() && this.controller.getSelectionCount() > 0;
        }
        if (action.equals((Object)Foundation.selector((String)"copy:"))) {
            return this.isBrowser() && this.controller.isMounted() && this.controller.getSelectionCount() > 0;
        }
        if (action.equals((Object)Foundation.selector((String)"paste:"))) {
            if (this.isBrowser() && this.controller.isMounted()) {
                if (this.controller.getPasteboard().isEmpty()) {
                    NSObject o;
                    NSPasteboard pboard = NSPasteboard.generalPasteboard();
                    return pboard.availableTypeFromArray(NSArray.arrayWithObject((String)"NSFilenamesPboardType")) != null && (o = pboard.propertyListForType("NSFilenamesPboardType")) != null;
                }
                return true;
            }
            return false;
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.encoding.action())) {
            return this.isBrowser();
        }
        if (action.equals((Object)Foundation.selector((String)"connectBookmarkButtonClicked:"))) {
            if (this.isBookmarks()) {
                return this.controller.getBookmarkTable().numberOfSelectedRows().intValue() == 1;
            }
            return false;
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.addbookmark.action())) {
            if (this.isBookmarks()) {
                return this.controller.getBookmarkModel().getSource().allowsAdd();
            }
            return true;
        }
        if (action.equals((Object)Foundation.selector((String)"deleteBookmarkButtonClicked:"))) {
            if (this.isBookmarks()) {
                return this.controller.getBookmarkModel().getSource().allowsDelete() && this.controller.getBookmarkTable().selectedRow().intValue() != -1;
            }
            return false;
        }
        if (action.equals((Object)Foundation.selector((String)"duplicateBookmarkButtonClicked:"))) {
            if (this.isBookmarks()) {
                return this.controller.getBookmarkModel().getSource().allowsEdit() && this.controller.getBookmarkTable().numberOfSelectedRows().intValue() == 1;
            }
            return false;
        }
        if (action.equals((Object)Foundation.selector((String)"editBookmarkButtonClicked:"))) {
            if (this.isBookmarks()) {
                return this.controller.getBookmarkModel().getSource().allowsEdit() && this.controller.getBookmarkTable().numberOfSelectedRows().intValue() == 1;
            }
            return false;
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.edit.action())) {
            if (this.isBrowser() && this.controller.isMounted() && this.controller.getSelectionCount() > 0) {
                for (Path s : this.controller.getSelectedPaths()) {
                    if (!this.controller.isEditable(s)) {
                        return false;
                    }
                    if (null != EditorFactory.getEditor((String)s.getName())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (action.equals((Object)Foundation.selector((String)"editMenuClicked:"))) {
            if (this.isBrowser() && this.controller.isMounted() && this.controller.getSelectionCount() > 0) {
                for (Path s : this.controller.getSelectedPaths()) {
                    if (this.controller.isEditable(s)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (action.equals((Object)Foundation.selector((String)"searchButtonClicked:"))) {
            return this.controller.isMounted() || this.isBookmarks();
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.quicklook.action())) {
            if (this.isBrowser() && this.controller.isMounted() && this.controller.getSelectionCount() > 0) {
                Path selected = this.controller.getSelectedPath();
                if (null == selected) {
                    return false;
                }
                return selected.isFile();
            }
            return false;
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.webbrowser.action())) {
            return this.controller.isMounted();
        }
        if (action.equals((Object)Foundation.selector((String)"sendCustomCommandClicked:"))) {
            return this.isBrowser() && this.controller.isMounted() && this.controller.getSession().getFeature(Command.class) != null;
        }
        if (action.equals((Object)Foundation.selector((String)"gotoButtonClicked:"))) {
            return this.isBrowser() && this.controller.isMounted();
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.info.action())) {
            return this.isBrowser() && this.controller.isMounted() && this.controller.getSelectionCount() > 0;
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.newfolder.action())) {
            return this.isBrowser() && this.controller.isMounted() && ((Directory)this.controller.getSession().getFeature(Directory.class)).isSupported(new UploadTargetFinder(this.controller.workdir()).find(this.controller.getSelectedPath()), "");
        }
        if (action.equals((Object)Foundation.selector((String)"createEncryptedVaultButtonClicked:"))) {
            return this.isBrowser() && this.controller.isMounted() && this.controller.getSession().getVault() != VaultRegistry.DISABLED && null == this.controller.workdir().attributes().getVault() && ((Directory)this.controller.getSession().getFeature(Directory.class)).isSupported(new UploadTargetFinder(this.controller.workdir()).find(this.controller.getSelectedPath()), "");
        }
        if (action.equals((Object)Foundation.selector((String)"createFileButtonClicked:"))) {
            return this.isBrowser() && this.controller.isMounted() && ((Touch)this.controller.getSession().getFeature(Touch.class)).isSupported(new UploadTargetFinder(this.controller.workdir()).find(this.controller.getSelectedPath()), "");
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.upload.action())) {
            return this.isBrowser() && this.controller.isMounted() && ((Touch)this.controller.getSession().getFeature(Touch.class)).isSupported(new UploadTargetFinder(this.controller.workdir()).find(this.controller.getSelectedPath()), "");
        }
        if (action.equals((Object)Foundation.selector((String)"createSymlinkButtonClicked:"))) {
            return this.isBrowser() && this.controller.isMounted() && this.controller.getSession().getFeature(Symlink.class) != null && this.controller.getSelectionCount() == 1;
        }
        if (action.equals((Object)Foundation.selector((String)"duplicateFileButtonClicked:"))) {
            return this.isBrowser() && this.controller.isMounted() && this.controller.getSession().getFeature(Copy.class) != null && this.controller.getSelectionCount() == 1;
        }
        if (action.equals((Object)Foundation.selector((String)"renameFileButtonClicked:"))) {
            if (this.isBrowser() && this.controller.isMounted() && this.controller.getSelectionCount() == 1) {
                Path selected = this.controller.getSelectedPath();
                if (null == selected) {
                    return false;
                }
                return ((Move)this.controller.getSession().getFeature(Move.class)).isSupported(selected, selected);
            }
            return false;
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.delete.action())) {
            if (this.isBrowser() && this.controller.isMounted() && this.controller.getSelectionCount() > 0) {
                for (Path selected : this.controller.getSelectedPaths()) {
                    if (((Delete)this.controller.getSession().getFeature(Delete.class)).isSupported(selected)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.share.action())) {
            if (this.isBrowser() && this.controller.isMounted()) {
                Path selected = null != this.controller.getSelectedPath() ? this.controller.getSelectedPath() : this.controller.workdir();
                return this.controller.getSession().getFeature(PromptUrlProvider.class) != null && ((PromptUrlProvider)this.controller.getSession().getFeature(PromptUrlProvider.class)).isSupported(selected, PromptUrlProvider.Type.download);
            }
            return false;
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.requestfiles.action())) {
            if (this.isBrowser() && this.controller.isMounted()) {
                Path selected = null != this.controller.getSelectedPath() ? this.controller.getSelectedPath() : this.controller.workdir();
                return this.controller.getSession().getFeature(PromptUrlProvider.class) != null && ((PromptUrlProvider)this.controller.getSession().getFeature(PromptUrlProvider.class)).isSupported(selected, PromptUrlProvider.Type.upload);
            }
            return false;
        }
        if (action.equals((Object)Foundation.selector((String)"revertFileButtonClicked:"))) {
            if (this.isBrowser() && this.controller.isMounted() && this.controller.getSelectionCount() > 0) {
                for (Path selected : this.controller.getSelectedPaths()) {
                    if (null == this.controller.getSession().getFeature(Versioning.class)) {
                        return false;
                    }
                    if (((Versioning)this.controller.getSession().getFeature(Versioning.class)).isRevertable(selected)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (action.equals((Object)Foundation.selector((String)"restoreFileButtonClicked:"))) {
            if (this.isBrowser() && this.controller.isMounted() && this.controller.getSelectionCount() > 0) {
                for (Path selected : this.controller.getSelectedPaths()) {
                    if (null == this.controller.getSession().getFeature(Restore.class)) {
                        return false;
                    }
                    if (((Restore)this.controller.getSession().getFeature(Restore.class)).isRestorable(selected)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.reload.action())) {
            return this.isBrowser() && this.controller.isMounted();
        }
        if (action.equals((Object)Foundation.selector((String)"newBrowserButtonClicked:"))) {
            return this.controller.isMounted();
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.synchronize.action())) {
            return this.isBrowser() && this.controller.isMounted();
        }
        if (action.equals((Object)Foundation.selector((String)"downloadAsButtonClicked:"))) {
            return this.isBrowser() && this.controller.isMounted() && this.controller.getSelectionCount() == 1;
        }
        if (action.equals((Object)Foundation.selector((String)"downloadToButtonClicked:")) || action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.download.action())) {
            return this.isBrowser() && this.controller.isMounted() && this.controller.getSelectionCount() > 0;
        }
        if (action.equals((Object)Foundation.selector((String)"insideButtonClicked:"))) {
            return this.isBrowser() && this.controller.isMounted() && this.controller.getSelectionCount() > 0;
        }
        if (action.equals((Object)Foundation.selector((String)"upButtonClicked:"))) {
            return this.isBrowser() && this.controller.isMounted() && !this.controller.workdir().isRoot();
        }
        if (action.equals((Object)Foundation.selector((String)"backButtonClicked:"))) {
            return this.isBrowser() && this.controller.isMounted() && this.controller.getNavigation().getBack().size() > 1;
        }
        if (action.equals((Object)Foundation.selector((String)"forwardButtonClicked:"))) {
            return this.isBrowser() && this.controller.isMounted() && this.controller.getNavigation().getForward().size() > 0;
        }
        if (action.equals((Object)Foundation.selector((String)"printDocument:"))) {
            return this.isBrowser() && this.controller.isMounted();
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.disconnect.action())) {
            return !this.controller.isIdle() || this.controller.isConnected();
        }
        if (action.equals((Object)Foundation.selector((String)"gotofolderButtonClicked:"))) {
            return this.isBrowser() && this.controller.isMounted();
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.terminal.action())) {
            return this.isBrowser() && this.controller.isMounted() && this.controller.getSession().getHost().getProtocol().getType() == Protocol.Type.sftp && TerminalServiceFactory.get() != null;
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.archive.action()) || action.equals((Object)Foundation.selector((String)"archiveMenuClicked:"))) {
            if (this.isBrowser() && this.controller.isMounted()) {
                if (this.controller.getSession().getFeature(Compress.class) == null) {
                    return false;
                }
                if (this.controller.getSelectionCount() > 0) {
                    for (Path s : this.controller.getSelectedPaths()) {
                        if (!s.isFile() || !Archive.isArchive((String)s.getName())) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.unarchive.action())) {
            if (this.isBrowser() && this.controller.isMounted()) {
                if (this.controller.getSession().getFeature(Compress.class) == null) {
                    return false;
                }
                if (this.controller.getSelectionCount() > 0) {
                    for (Path s : this.controller.getSelectedPaths()) {
                        if (s.isDirectory()) {
                            return false;
                        }
                        if (Archive.isArchive((String)s.getName())) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.cryptomator.action())) {
            if (this.isBrowser() && this.controller.isMounted() && !PreferencesFactory.get().getBoolean("cryptomator.vault.autodetect")) {
                Path selected = new UploadTargetFinder(this.controller.workdir()).find(this.controller.getSelectedPath());
                VaultRegistry registry = this.controller.getSession().getVault();
                if (registry.contains(selected)) {
                    return true;
                }
                AttributedList cache = this.controller.getCache().get((Referenceable)this.controller.workdir());
                return null != cache.find((Predicate)new SimplePathPredicate(AbstractPath.Type.file, String.format("%s%s%s", this.controller.workdir().getAbsolute(), Character.valueOf('/'), new HostPreferences(this.controller.getSession().getHost()).getProperty("cryptomator.vault.masterkey.filename"))));
            }
            return false;
        }
        return true;
    }

    protected boolean isBrowser() {
        switch (this.controller.getSelectedTabView()) {
            case list: 
            case outline: {
                return true;
            }
        }
        return false;
    }

    protected boolean isBookmarks() {
        switch (this.controller.getSelectedTabView()) {
            case bookmarks: {
                return true;
            }
        }
        return false;
    }
}

