/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSMenu;
import ch.cyberduck.binding.application.NSMenuItem;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.local.RevealServiceFactory;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.ui.cocoa.delegate.AbstractMenuDelegate;
import java.util.ArrayList;
import java.util.List;
import org.rococoa.Foundation;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSInteger;

public class TransferMenuDelegate
extends AbstractMenuDelegate {
    private final Transfer transfer;

    public TransferMenuDelegate(Transfer transfer) {
        this.transfer = transfer;
    }

    public NSInteger numberOfItemsInMenu(NSMenu menu) {
        if (this.isPopulated()) {
            return new NSInteger(-1L);
        }
        return new NSInteger((long)this.transfer.getRoots().size());
    }

    @Override
    public boolean menuUpdateItemAtIndex(NSMenu menu, NSMenuItem item, NSInteger index, boolean cancel) {
        List items = this.transfer.getRoots();
        TransferItem entry = (TransferItem)new ArrayList(items).get(index.intValue());
        if (entry.local != null) {
            item.setRepresentedObject(entry.local.getAbsolute());
            if (entry.local.exists()) {
                item.setEnabled(true);
                item.setTarget(this.id());
                item.setAction(this.getDefaultAction());
            } else {
                item.setEnabled(false);
                item.setTarget(null);
            }
        } else {
            item.setRepresentedObject(entry.remote.getAbsolute());
        }
        item.setImage((NSImage)IconCacheFactory.get().fileIcon(entry.remote, Integer.valueOf(16)));
        return super.menuUpdateItemAtIndex(menu, item, index, cancel);
    }

    public void menuItemClicked(NSMenuItem sender) {
        RevealServiceFactory.get().reveal(LocalFactory.get((String)sender.representedObject()));
    }

    @Override
    public Selector getDefaultAction() {
        return Foundation.selector((String)"menuItemClicked:");
    }
}

