/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.local.BrowserLauncher;
import ch.cyberduck.core.local.BrowserLauncherFactory;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.ui.cocoa.delegate.URLMenuDelegate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class OpenURLMenuDelegate
extends URLMenuDelegate {
    @Override
    protected String getKeyEquivalent() {
        return "b";
    }

    @Override
    protected int getModifierMask() {
        return 0x120000;
    }

    @Override
    protected List<DescriptiveUrl> getURLs(Path selected) {
        ArrayList<DescriptiveUrl> list = new ArrayList<DescriptiveUrl>();
        SessionPool pool = this.getSession();
        UrlProvider provider = (UrlProvider)pool.getFeature(UrlProvider.class);
        if (provider != null) {
            list.addAll((Collection<DescriptiveUrl>)provider.toUrl(selected).filter(new DescriptiveUrl.Type[]{DescriptiveUrl.Type.http, DescriptiveUrl.Type.cname, DescriptiveUrl.Type.cdn, DescriptiveUrl.Type.signed, DescriptiveUrl.Type.authenticated}));
        }
        return list;
    }

    @Override
    public void handle(List<DescriptiveUrl> selected) {
        BrowserLauncher browser = BrowserLauncherFactory.get();
        for (DescriptiveUrl url : selected) {
            browser.open(url.getUrl());
        }
    }
}

