/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.binding.application.NSPasteboard;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.binding.foundation.NSString;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.ui.cocoa.delegate.URLMenuDelegate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CopyURLMenuDelegate
extends URLMenuDelegate {
    private static final Logger log = LogManager.getLogger(CopyURLMenuDelegate.class);

    @Override
    protected String getKeyEquivalent() {
        return "c";
    }

    @Override
    protected int getModifierMask() {
        return 0x120000;
    }

    @Override
    protected List<DescriptiveUrl> getURLs(Path selected) {
        ArrayList<DescriptiveUrl> list = new ArrayList<DescriptiveUrl>();
        SessionPool pool = this.getSession();
        UrlProvider provider = (UrlProvider)pool.getFeature(UrlProvider.class);
        if (provider != null) {
            list.addAll((Collection<DescriptiveUrl>)provider.toUrl(selected));
        }
        return list;
    }

    @Override
    public void handle(List<DescriptiveUrl> selected) {
        StringBuilder url = new StringBuilder();
        Iterator<DescriptiveUrl> iter = selected.iterator();
        while (iter.hasNext()) {
            url.append(iter.next().getUrl());
            if (!iter.hasNext()) continue;
            url.append("\n");
        }
        NSPasteboard pboard = NSPasteboard.generalPasteboard();
        pboard.declareTypes(NSArray.arrayWithObject((NSObject)NSString.stringWithString((String)"NSStringPboardType")), null);
        if (!pboard.setStringForType(url.toString(), "NSStringPboardType")) {
            log.error(String.format("Error writing URL to %s", "NSStringPboardType"));
        }
    }
}

