/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.datasource;

import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.core.synchronization.Comparison;
import ch.cyberduck.core.transfer.SyncTransfer;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.ui.cocoa.controller.TransferPromptController;
import ch.cyberduck.ui.cocoa.datasource.TransferPromptDataSource;

public class SyncPromptDataSource
extends TransferPromptDataSource {
    private final SyncTransfer transfer;

    public SyncPromptDataSource(TransferPromptController c, SessionPool source, SessionPool destination, SyncTransfer transfer, Cache<TransferItem> cache) {
        super(c, source, destination, (Transfer)transfer, cache);
        this.transfer = transfer;
    }

    @Override
    protected NSObject objectValueForItem(TransferItem item, String identifier) {
        if (identifier.equals(Column.sync.name())) {
            Comparison compare = this.transfer.compare(item);
            if (compare.equals((Object)Comparison.remote)) {
                return (NSObject)IconCacheFactory.get().iconNamed("transfer-download.tiff", Integer.valueOf(16));
            }
            if (compare.equals((Object)Comparison.local)) {
                return (NSObject)IconCacheFactory.get().iconNamed("transfer-upload.tiff", Integer.valueOf(16));
            }
            return null;
        }
        if (identifier.equals(Column.create.name())) {
            TransferStatus status = this.getStatus(item);
            if (!status.isExists()) {
                return (NSObject)IconCacheFactory.get().iconNamed("NSAddTemplate", Integer.valueOf(16));
            }
            return null;
        }
        return super.objectValueForItem(item, identifier);
    }

    public static enum Column {
        sync,
        create;

    }
}

