/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.datasource;

import ch.cyberduck.binding.application.NSDraggingInfo;
import ch.cyberduck.binding.application.NSPasteboard;
import ch.cyberduck.binding.application.NSTableColumn;
import ch.cyberduck.binding.application.NSTableView;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSIndexSet;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.binding.foundation.NSURL;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Path;
import ch.cyberduck.ui.cocoa.controller.BrowserController;
import ch.cyberduck.ui.cocoa.datasource.BrowserTableDataSource;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSUInteger;

public class BrowserListViewDataSource
extends BrowserTableDataSource
implements NSTableView.DataSource {
    private static final Logger log = LogManager.getLogger(BrowserListViewDataSource.class);

    public BrowserListViewDataSource(BrowserController controller, Cache<Path> cache) {
        super(controller, cache);
    }

    @Override
    public void render(NSTableView view, List<Path> folders) {
        super.render(view, folders);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Reload table view %s for changes files %s", view, folders));
        }
        view.reloadData();
    }

    public NSInteger numberOfRowsInTableView(NSTableView view) {
        if (this.controller.isMounted()) {
            return new NSInteger((long)this.get(this.controller.workdir()).size());
        }
        return new NSInteger(0L);
    }

    public void tableView_setObjectValue_forTableColumn_row(NSTableView view, NSObject value, NSTableColumn column, NSInteger row) {
        super.setObjectValueForItem((Path)this.get(this.controller.workdir()).get(row.intValue()), value, column.identifier());
    }

    public NSObject tableView_objectValueForTableColumn_row(NSTableView view, NSTableColumn column, NSInteger row) {
        if (this.controller.isMounted()) {
            AttributedList<Path> children = this.get(this.controller.workdir());
            return super.objectValueForItem((Path)children.get(row.intValue()), column.identifier());
        }
        return null;
    }

    public NSUInteger tableView_validateDrop_proposedRow_proposedDropOperation(NSTableView view, NSDraggingInfo draggingInfo, NSInteger row, NSUInteger operation) {
        if (this.controller.isMounted()) {
            Path destination = this.controller.workdir();
            if (row.intValue() < this.numberOfRowsInTableView(view).intValue()) {
                Path p;
                int draggingColumn = view.columnAtPoint(draggingInfo.draggingLocation()).intValue();
                if ((-1 == draggingColumn || 0 == draggingColumn || 1 == draggingColumn) && row.intValue() != -1 && (p = (Path)this.get(this.controller.workdir()).get(row.intValue())).isDirectory()) {
                    destination = p;
                }
                return super.validateDrop(view, destination, row, draggingInfo);
            }
            return super.validateDrop(view, destination, row, draggingInfo);
        }
        return super.validateDrop(view, null, row, draggingInfo);
    }

    public boolean tableView_acceptDrop_row_dropOperation(NSTableView view, NSDraggingInfo draggingInfo, NSInteger row, NSUInteger operation) {
        if (this.controller.isMounted()) {
            Path destination = this.controller.workdir();
            if (row.intValue() != -1) {
                destination = (Path)this.get(this.controller.workdir()).get(row.intValue());
            }
            return super.acceptDrop(view, destination, draggingInfo);
        }
        return super.acceptDrop(view, null, draggingInfo);
    }

    public boolean tableView_writeRowsWithIndexes_toPasteboard(NSTableView view, NSIndexSet rowIndexes, NSPasteboard pboard) {
        if (this.controller.isMounted()) {
            AttributedList<Path> children = this.get(this.controller.workdir());
            ArrayList<Path> selected = new ArrayList<Path>();
            NSUInteger index = rowIndexes.firstIndex();
            while (!index.equals((Object)NSIndexSet.NSNotFound)) {
                selected.add((Path)children.get(index.intValue()));
                index = rowIndexes.indexGreaterThanIndex(index);
            }
            return super.writeItemsToPasteBoard(view, selected, pboard);
        }
        return false;
    }

    public NSArray tableView_namesOfPromisedFilesDroppedAtDestination_forDraggedRowsWithIndexes(NSTableView view, NSURL dropDestination, NSIndexSet rowIndexes) {
        return this.namesOfPromisedFilesDroppedAtDestination(dropDestination);
    }
}

