/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.datasource;

import ch.cyberduck.binding.ListDataSource;
import ch.cyberduck.binding.application.NSApplication;
import ch.cyberduck.binding.application.NSDraggingInfo;
import ch.cyberduck.binding.application.NSEvent;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSPasteboard;
import ch.cyberduck.binding.application.NSTableColumn;
import ch.cyberduck.binding.application.NSTableView;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSIndexSet;
import ch.cyberduck.binding.foundation.NSMutableArray;
import ch.cyberduck.binding.foundation.NSMutableDictionary;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.binding.foundation.NSURL;
import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.CollectionListener;
import ch.cyberduck.core.FilterHostCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostFilter;
import ch.cyberduck.core.HostParser;
import ch.cyberduck.core.HostReaderFactory;
import ch.cyberduck.core.HostWriterFactory;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.SerializerFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.HostParserException;
import ch.cyberduck.core.pasteboard.HostPasteboard;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.core.serializer.HostDictionary;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.core.threading.ScheduledThreadPool;
import ch.cyberduck.core.threading.WindowMainAction;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferOptions;
import ch.cyberduck.core.transfer.UploadTransfer;
import ch.cyberduck.ui.browser.BookmarkColumn;
import ch.cyberduck.ui.cocoa.controller.BrowserController;
import ch.cyberduck.ui.cocoa.controller.TransferControllerFactory;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rococoa.ObjCClass;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSPoint;
import org.rococoa.cocoa.foundation.NSRect;
import org.rococoa.cocoa.foundation.NSSize;
import org.rococoa.cocoa.foundation.NSUInteger;

public class BookmarkTableDataSource
extends ListDataSource {
    private static final Logger log = LogManager.getLogger(BookmarkTableDataSource.class);
    protected final BrowserController controller;
    private HostFilter filter;
    private AbstractHostCollection source = AbstractHostCollection.empty();
    private AbstractHostCollection filtered;
    private CollectionListener<Host> listener;
    private final ScheduledThreadPool timerPool = new ScheduledThreadPool();
    private final HostPasteboard pasteboard = HostPasteboard.getPasteboard();

    public BookmarkTableDataSource(BrowserController controller) {
        this.controller = controller;
    }

    public void setSource(AbstractHostCollection source) {
        this.source.removeListener(this.listener);
        this.source = source;
        this.listener = new CollectionListener<Host>(){
            private ScheduledFuture<?> delayed = null;

            public void collectionLoaded() {
                BookmarkTableDataSource.this.controller.invoke((MainAction)new WindowMainAction(BookmarkTableDataSource.this.controller){

                    public void run() {
                        BookmarkTableDataSource.this.controller.reloadBookmarks();
                    }
                });
            }

            public void collectionItemAdded(Host item) {
                BookmarkTableDataSource.this.controller.invoke((MainAction)new WindowMainAction(BookmarkTableDataSource.this.controller){

                    public void run() {
                        BookmarkTableDataSource.this.controller.reloadBookmarks();
                    }
                });
            }

            public void collectionItemRemoved(Host item) {
                BookmarkTableDataSource.this.controller.invoke((MainAction)new WindowMainAction(BookmarkTableDataSource.this.controller){

                    public void run() {
                        BookmarkTableDataSource.this.controller.reloadBookmarks();
                    }
                });
            }

            public void collectionItemChanged(Host item) {
                if (null != this.delayed) {
                    this.delayed.cancel(false);
                }
                this.delayed = BookmarkTableDataSource.this.timerPool.schedule(new Runnable(){

                    @Override
                    public void run() {
                        BookmarkTableDataSource.this.controller.invoke((MainAction)new WindowMainAction(BookmarkTableDataSource.this.controller){

                            public void run() {
                                BookmarkTableDataSource.this.controller.reloadBookmarks();
                            }
                        });
                    }
                }, Long.valueOf(1L), TimeUnit.SECONDS);
            }
        };
        this.source.addListener((CollectionListener)this.listener);
        this.setFilter(null);
    }

    public void invalidate() {
        this.timerPool.shutdown();
        this.source.removeListener(this.listener);
        super.invalidate();
    }

    public void setFilter(HostFilter filter) {
        this.filter = filter;
        this.filtered = null;
    }

    public AbstractHostCollection getSource() {
        if (null == this.filter) {
            return this.source;
        }
        if (null == this.filtered) {
            this.filtered = new FilterHostCollection(this.source, this.filter);
        }
        return this.filtered;
    }

    public NSInteger numberOfRowsInTableView(NSTableView view) {
        return new NSInteger((long)this.getSource().size());
    }

    public NSObject tableView_objectValueForTableColumn_row(NSTableView view, NSTableColumn tableColumn, NSInteger row) {
        if (row.intValue() >= this.numberOfRowsInTableView(view).intValue()) {
            return null;
        }
        String identifier = tableColumn.identifier();
        Host host = (Host)this.getSource().get(row.intValue());
        if (identifier.equals(BookmarkColumn.icon.name())) {
            return (NSObject)IconCacheFactory.get().iconNamed(host.getProtocol().disk(), Integer.valueOf(PreferencesFactory.get().getInteger("bookmark.icon.size")));
        }
        if (identifier.equals(BookmarkColumn.bookmark.name())) {
            String comment;
            NSMutableDictionary dict = NSMutableDictionary.dictionary();
            dict.setObjectForKey(BookmarkNameProvider.toString((Host)host), "Nickname");
            dict.setObjectForKey(host.getHostname(), "Hostname");
            if (StringUtils.isNotBlank((CharSequence)host.getCredentials().getUsername())) {
                dict.setObjectForKey(host.getCredentials().getUsername(), "Username");
            }
            if (StringUtils.isNotBlank((CharSequence)(comment = this.getSource().getComment(host)))) {
                dict.setObjectForKey(comment, "Comment");
            }
            return dict;
        }
        if (identifier.equals(BookmarkColumn.status.name())) {
            SessionPool session = this.controller.getSession();
            if (host.equals((Object)session.getHost())) {
                switch (session.getState()) {
                    case open: {
                        return (NSObject)IconCacheFactory.get().iconNamed("NSStatusAvailable", Integer.valueOf(16));
                    }
                    case opening: 
                    case closing: {
                        return (NSObject)IconCacheFactory.get().iconNamed("NSStatusPartiallyAvailable", Integer.valueOf(16));
                    }
                }
            }
            return null;
        }
        throw new IllegalArgumentException(String.format("Unknown identifier %s", identifier));
    }

    public boolean ignoreModifierKeysWhileDragging() {
        return false;
    }

    public NSUInteger tableView_validateDrop_proposedRow_proposedDropOperation(NSTableView view, NSDraggingInfo info, NSInteger row, NSUInteger operation) {
        NSPasteboard draggingPasteboard = info.draggingPasteboard();
        if (!this.getSource().allowsEdit()) {
            return NSDraggingInfo.NSDragOperationNone;
        }
        if (draggingPasteboard.availableTypeFromArray(NSArray.arrayWithObject((String)"NSStringPboardType")) != null) {
            String o = draggingPasteboard.stringForType("NSStringPboardType");
            if (o != null && Scheme.isURL((String)o)) {
                view.setDropRow(row, NSTableView.NSTableViewDropAbove);
                return NSDraggingInfo.NSDragOperationCopy;
            }
            return NSDraggingInfo.NSDragOperationNone;
        }
        if (draggingPasteboard.availableTypeFromArray(NSArray.arrayWithObject((String)"NSFilenamesPboardType")) != null) {
            NSObject o = draggingPasteboard.propertyListForType("NSFilenamesPboardType");
            if (o != null && o.isKindOfClass((ObjCClass)NSArray.CLASS)) {
                NSArray elements = (NSArray)Rococoa.cast((ObjCObject)o, NSArray.class);
                for (int i = 0; i < elements.count().intValue(); ++i) {
                    String file = elements.objectAtIndex(new NSUInteger((long)i)).toString();
                    if (!file.endsWith(".duck")) continue;
                    view.setDropRow(row, NSTableView.NSTableViewDropAbove);
                    return NSDraggingInfo.NSDragOperationCopy;
                }
                view.setDropRow(row, NSTableView.NSTableViewDropOn);
                return NSDraggingInfo.NSDragOperationCopy;
            }
            return NSDraggingInfo.NSDragOperationNone;
        }
        if (draggingPasteboard.availableTypeFromArray(NSArray.arrayWithObject((String)"Apple URL pasteboard type")) != null) {
            NSObject o = draggingPasteboard.propertyListForType("Apple URL pasteboard type");
            if (o != null && o.isKindOfClass((ObjCClass)NSArray.CLASS)) {
                NSArray elements = (NSArray)Rococoa.cast((ObjCObject)o, NSArray.class);
                for (int i = 0; i < elements.count().intValue(); ++i) {
                    if (!Scheme.isURL((String)elements.objectAtIndex(new NSUInteger((long)i)).toString())) continue;
                    view.setDropRow(row, NSTableView.NSTableViewDropAbove);
                    return NSDraggingInfo.NSDragOperationCopy;
                }
            }
            return NSDraggingInfo.NSDragOperationNone;
        }
        if (!this.pasteboard.isEmpty()) {
            view.setDropRow(row, NSTableView.NSTableViewDropAbove);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Drag operation mask is %d", info.draggingSourceOperationMask().intValue()));
            }
            if (info.draggingSourceOperationMask().intValue() == NSDraggingInfo.NSDragOperationCopy.intValue()) {
                return NSDraggingInfo.NSDragOperationCopy;
            }
            return NSDraggingInfo.NSDragOperationMove;
        }
        return NSDraggingInfo.NSDragOperationNone;
    }

    public boolean tableView_acceptDrop_row_dropOperation(NSTableView view, NSDraggingInfo info, NSInteger row, NSUInteger operation) {
        NSPasteboard draggingPasteboard = info.draggingPasteboard();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Accept drop at row %s", row));
        }
        view.deselectAll(null);
        AbstractHostCollection source = this.getSource();
        if (draggingPasteboard.availableTypeFromArray(NSArray.arrayWithObject((String)"NSStringPboardType")) != null) {
            Host h;
            String o = draggingPasteboard.stringForType("NSStringPboardType");
            if (null == o) {
                return false;
            }
            try {
                h = HostParser.parse((String)o);
            }
            catch (HostParserException e) {
                return false;
            }
            source.add(row.intValue(), (Object)h);
            view.selectRowIndexes(NSIndexSet.indexSetWithIndex((NSInteger)row), false);
            view.scrollRowToVisible(row);
            return true;
        }
        if (draggingPasteboard.availableTypeFromArray(NSArray.arrayWithObject((String)"NSFilenamesPboardType")) != null) {
            NSObject object = draggingPasteboard.propertyListForType("NSFilenamesPboardType");
            if (object != null && object.isKindOfClass((ObjCClass)NSArray.CLASS)) {
                NSArray elements = (NSArray)Rococoa.cast((ObjCObject)object, NSArray.class);
                ArrayList<TransferItem> uploads = new ArrayList<TransferItem>();
                Host host = null;
                for (int i = 0; i < elements.count().intValue(); ++i) {
                    String filename = elements.objectAtIndex(new NSUInteger((long)i)).toString();
                    Local f = LocalFactory.get((String)filename);
                    if (filename.endsWith(".duck")) {
                        try {
                            source.add(row.intValue(), (Object)((Host)HostReaderFactory.get().read(f)));
                            view.selectRowIndexes(NSIndexSet.indexSetWithIndex((NSInteger)row), true);
                            view.scrollRowToVisible(row);
                        }
                        catch (AccessDeniedException e) {
                            log.error(String.format("Failure reading bookmark from %s. %s", f, e.getMessage()));
                        }
                        continue;
                    }
                    Host h = (Host)source.get(row.intValue());
                    if (null == host) {
                        host = h;
                    }
                    uploads.add(new TransferItem(new Path(new Path(PathNormalizer.normalize((String)h.getDefaultPath()), EnumSet.of(AbstractPath.Type.directory)), f.getName(), EnumSet.of(AbstractPath.Type.file)), f));
                }
                if (!uploads.isEmpty()) {
                    UploadTransfer t = new UploadTransfer(host, uploads);
                    TransferControllerFactory.get().start((Transfer)t, new TransferOptions());
                }
                return true;
            }
        } else {
            if (draggingPasteboard.availableTypeFromArray(NSArray.arrayWithObject((String)"Apple URL pasteboard type")) != null) {
                NSObject object = draggingPasteboard.propertyListForType("Apple URL pasteboard type");
                if (object != null && object.isKindOfClass((ObjCClass)NSArray.CLASS)) {
                    NSArray elements = (NSArray)Rococoa.cast((ObjCObject)object, NSArray.class);
                    for (int i = 0; i < elements.count().intValue(); ++i) {
                        Host h;
                        String url = elements.objectAtIndex(new NSUInteger((long)i)).toString();
                        if (!StringUtils.isNotBlank((CharSequence)url)) continue;
                        try {
                            h = HostParser.parse((String)url);
                        }
                        catch (HostParserException e) {
                            log.warn((Object)e);
                            continue;
                        }
                        source.add(row.intValue(), (Object)h);
                        view.selectRowIndexes(NSIndexSet.indexSetWithIndex((NSInteger)row), true);
                        view.scrollRowToVisible(row);
                    }
                    return true;
                }
                return false;
            }
            if (!this.pasteboard.isEmpty()) {
                if (info.draggingSourceOperationMask().intValue() == NSDraggingInfo.NSDragOperationCopy.intValue()) {
                    ArrayList<Host> duplicates = new ArrayList<Host>();
                    for (Host bookmark : this.pasteboard) {
                        Host duplicate = new HostDictionary().deserialize(bookmark.serialize(SerializerFactory.get()));
                        duplicate.setUuid(null);
                        source.add(row.intValue(), (Object)duplicate);
                        duplicates.add(duplicate);
                    }
                    for (Host bookmark : duplicates) {
                        int index = source.indexOf((Object)bookmark);
                        view.selectRowIndexes(NSIndexSet.indexSetWithIndex((NSInteger)new NSInteger((long)index)), true);
                        view.scrollRowToVisible(new NSInteger((long)index));
                    }
                } else {
                    int insert = row.intValue();
                    for (Host bookmark : this.pasteboard) {
                        int previous = source.indexOf((Object)bookmark);
                        if (previous == insert) continue;
                        source.remove(previous);
                        int moved = previous < insert ? insert - 1 : insert;
                        source.add(moved, (Object)bookmark);
                    }
                    for (Host bookmark : this.pasteboard) {
                        int index = source.indexOf((Object)bookmark);
                        view.selectRowIndexes(NSIndexSet.indexSetWithIndex((NSInteger)new NSInteger((long)index)), true);
                        view.scrollRowToVisible(new NSInteger((long)index));
                    }
                }
                return true;
            }
        }
        return false;
    }

    public void draggedImage_endedAt_operation(NSImage image, NSPoint point, NSUInteger operation) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Drop finished with operation %s", operation));
        }
        if (NSDraggingInfo.NSDragOperationDelete.intValue() == operation.intValue()) {
            this.controller.deleteBookmarkButtonClicked(null);
        }
        this.pasteboard.clear();
    }

    public NSUInteger draggingSourceOperationMaskForLocal(boolean local) {
        if (local) {
            return new NSUInteger((long)(NSDraggingInfo.NSDragOperationMove.intValue() | NSDraggingInfo.NSDragOperationCopy.intValue()));
        }
        return new NSUInteger((long)(NSDraggingInfo.NSDragOperationCopy.intValue() | NSDraggingInfo.NSDragOperationDelete.intValue()));
    }

    public boolean tableView_writeRowsWithIndexes_toPasteboard(NSTableView view, NSIndexSet rowIndexes, NSPasteboard pboard) {
        NSUInteger index = rowIndexes.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            this.pasteboard.add((Object)((Host)this.getSource().get(index.intValue())));
            index = rowIndexes.indexGreaterThanIndex(index);
        }
        NSEvent event = NSApplication.sharedApplication().currentEvent();
        if (event != null) {
            NSPoint dragPosition = view.convertPoint_fromView(event.locationInWindow(), null);
            NSRect imageRect = new NSRect(new NSPoint(dragPosition.x.doubleValue() - 16.0, dragPosition.y.doubleValue() - 16.0), new NSSize(32.0, 32.0));
            if (!view.dragPromisedFilesOfTypes(NSArray.arrayWithObject((String)"duck"), imageRect, this.id(), true, event)) {
                log.warn(String.format("Failure for drag promise operation of %s", event));
                return false;
            }
            return true;
        }
        return false;
    }

    public NSArray namesOfPromisedFilesDroppedAtDestination(NSURL dropDestination) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Query promised files dropped dat destination %s", dropDestination.path()));
        }
        NSMutableArray promisedDragNames = NSMutableArray.array();
        if (null != dropDestination) {
            for (Host bookmark : this.pasteboard) {
                Local file = LocalFactory.get((String)dropDestination.path(), (String)String.format("%s.duck", StringUtils.replace((String)BookmarkNameProvider.toString((Host)bookmark), (String)"/", (String)":")));
                try {
                    HostWriterFactory.get().write((Serializable)bookmark, file);
                }
                catch (AccessDeniedException e) {
                    log.warn(e.getMessage());
                }
                promisedDragNames.addObject(file.getName());
            }
            this.pasteboard.clear();
        }
        return promisedDragNames;
    }
}

