/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSLevelIndicator;
import ch.cyberduck.binding.application.NSSecureTextField;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.binding.foundation.NSNotificationCenter;
import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.PasswordStrengthValidator;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProviderHelpServiceFactory;
import ch.cyberduck.core.StringAppender;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.core.vault.VaultCredentials;
import ch.cyberduck.ui.cocoa.controller.FolderController;
import java.util.EnumSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.rococoa.Foundation;
import org.rococoa.cocoa.foundation.NSPoint;
import org.rococoa.cocoa.foundation.NSRect;

public class VaultController
extends FolderController {
    private final Callback callback;
    private NSView view;
    private NSSecureTextField passwordField;
    private NSSecureTextField confirmField;
    private NSLevelIndicator strengthIndicator;
    private final NSNotificationCenter notificationCenter = NSNotificationCenter.defaultCenter();
    private final PasswordStrengthValidator passwordStrengthValidator = new PasswordStrengthValidator();

    public VaultController(Path workdir, Path selected, Cache<Path> cache, Set<Location.Name> regions, Location.Name defaultRegion, Callback callback) {
        super(workdir, selected, cache, regions, defaultRegion, new FolderController.Callback(){

            @Override
            public void callback(Path folder, String region) {
            }
        });
        this.callback = callback;
    }

    @Override
    public void loadBundle() {
        NSAlert alert = NSAlert.alert();
        alert.setAlertStyle(1);
        alert.setMessageText(LocaleFactory.localizedString((String)"Create Vault", (String)"Cryptomator"));
        String message = LocaleFactory.localizedString((String)"Enter the name for the new folder", (String)"Folder");
        alert.setInformativeText(new StringAppender().append(message).toString());
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Create Vault", (String)"Cryptomator"));
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Cancel", (String)"Folder"));
        alert.setIcon((NSImage)IconCacheFactory.get().iconNamed("cryptomator.tiff", Integer.valueOf(64)));
        super.loadBundle(alert);
    }

    public void passwordFieldTextDidChange(NSNotification notification) {
        this.strengthIndicator.setIntValue(this.passwordStrengthValidator.getScore(this.passwordField.stringValue()).getScore());
    }

    @Override
    public NSView getAccessoryView(NSAlert alert) {
        this.view = NSView.create((NSRect)new NSRect(alert.window().frame().size.width.doubleValue(), 0.0));
        this.confirmField = NSSecureTextField.textfieldWithFrame((NSRect)new NSRect(alert.window().frame().size.width.doubleValue(), 22.0));
        this.confirmField.cell().setPlaceholderString(LocaleFactory.localizedString((String)"Confirm Passphrase", (String)"Cryptomator"));
        this.confirmField.setFrameOrigin(new NSPoint(0.0, 0.0));
        this.view.addSubview((NSView)this.confirmField);
        this.strengthIndicator = NSLevelIndicator.levelIndicatorWithFrame((NSRect)new NSRect(alert.window().frame().size.width.doubleValue(), 18.0));
        if (this.strengthIndicator.respondsToSelector(Foundation.selector((String)"setLevelIndicatorStyle:"))) {
            this.strengthIndicator.setLevelIndicatorStyle(2);
        }
        this.strengthIndicator.setFrameOrigin(new NSPoint(0.0, this.getFrame((NSAlert)alert, (NSView)this.view).size.height.doubleValue() + this.view.subviews().count().doubleValue() * 4.0));
        this.view.addSubview((NSView)this.strengthIndicator);
        this.passwordField = NSSecureTextField.textfieldWithFrame((NSRect)new NSRect(alert.window().frame().size.width.doubleValue(), 22.0));
        this.passwordField.cell().setPlaceholderString(LocaleFactory.localizedString((String)"Passphrase", (String)"Cryptomator"));
        this.notificationCenter.addObserver(this.id(), Foundation.selector((String)"passwordFieldTextDidChange:"), "NSControlTextDidChangeNotification", this.passwordField.id());
        this.passwordField.setFrameOrigin(new NSPoint(0.0, this.getFrame((NSAlert)alert, (NSView)this.view).size.height.doubleValue() + this.view.subviews().count().doubleValue() * 4.0));
        this.view.addSubview((NSView)this.passwordField);
        NSView accessory = super.getAccessoryView(alert);
        accessory.setFrameSize(this.getFrame((NSAlert)alert, (NSView)accessory).size);
        accessory.setFrameOrigin(new NSPoint(0.0, this.getFrame((NSAlert)alert, (NSView)this.view).size.height.doubleValue() + this.view.subviews().count().doubleValue() * 4.0));
        this.view.addSubview(accessory);
        return this.view;
    }

    @Override
    public boolean validate() {
        if (super.validate()) {
            if (StringUtils.isBlank((CharSequence)this.passwordField.stringValue())) {
                return false;
            }
            if (StringUtils.isBlank((CharSequence)this.confirmField.stringValue())) {
                return false;
            }
            return StringUtils.equals((CharSequence)this.passwordField.stringValue(), (CharSequence)this.confirmField.stringValue());
        }
        return false;
    }

    @Override
    protected String help() {
        return ProviderHelpServiceFactory.get().help();
    }

    @Override
    public void callback(int returncode, Path file) {
        file.setType(EnumSet.of(AbstractPath.Type.directory));
        VaultCredentials credentials = new VaultCredentials(this.passwordField.stringValue()).withSaved(this.isSuppressed());
        this.callback.callback(file, this.getLocation(), credentials);
    }

    public static interface Callback {
        public void callback(Path var1, String var2, VaultCredentials var3);
    }
}

