/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.AbstractTableDelegate;
import ch.cyberduck.binding.HyperlinkAttributedStringFactory;
import ch.cyberduck.binding.WindowController;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSImageView;
import ch.cyberduck.binding.application.NSMenu;
import ch.cyberduck.binding.application.NSMenuItem;
import ch.cyberduck.binding.application.NSProgressIndicator;
import ch.cyberduck.binding.application.NSResponder;
import ch.cyberduck.binding.application.NSTableColumn;
import ch.cyberduck.binding.application.NSTableView;
import ch.cyberduck.binding.application.NSTextField;
import ch.cyberduck.binding.application.NSToolbar;
import ch.cyberduck.binding.application.NSToolbarItem;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.binding.application.NSWindow;
import ch.cyberduck.binding.application.SheetCallback;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSIndexSet;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.binding.foundation.NSNotificationCenter;
import ch.cyberduck.binding.foundation.NSRange;
import ch.cyberduck.core.AbstractCollectionListener;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.CollectionListener;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.SessionPoolFactory;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.TransferCollection;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.local.ApplicationLauncherFactory;
import ch.cyberduck.core.local.LocalTrashFactory;
import ch.cyberduck.core.local.RevealService;
import ch.cyberduck.core.local.RevealServiceFactory;
import ch.cyberduck.core.logging.UnifiedSystemLogTranscriptListener;
import ch.cyberduck.core.pasteboard.PathPasteboard;
import ch.cyberduck.core.pasteboard.PathPasteboardFactory;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.ControllerMainAction;
import ch.cyberduck.core.threading.DefaultMainAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.core.threading.TransferBackgroundAction;
import ch.cyberduck.core.threading.TransferCollectionBackgroundAction;
import ch.cyberduck.core.threading.WindowMainAction;
import ch.cyberduck.core.transfer.DownloadTransfer;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferCallback;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferListener;
import ch.cyberduck.core.transfer.TransferOptions;
import ch.cyberduck.core.transfer.TransferProgress;
import ch.cyberduck.core.transfer.TransferQueue;
import ch.cyberduck.core.transfer.TransferQueueFactory;
import ch.cyberduck.core.transfer.TransferSpeedometer;
import ch.cyberduck.ui.browser.DownloadDirectoryFinder;
import ch.cyberduck.ui.cocoa.controller.ProgressController;
import ch.cyberduck.ui.cocoa.controller.TableColumnFactory;
import ch.cyberduck.ui.cocoa.datasource.TransferTableDataSource;
import ch.cyberduck.ui.cocoa.delegate.AbstractMenuDelegate;
import ch.cyberduck.ui.cocoa.toolbar.TransferToolbarFactory;
import ch.cyberduck.ui.cocoa.toolbar.TransferToolbarValidator;
import com.sun.jna.NativeLong;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;
import org.rococoa.Selector;
import org.rococoa.cocoa.CGFloat;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSSize;
import org.rococoa.cocoa.foundation.NSUInteger;

public final class TransferController
extends WindowController
implements TransferListener,
NSToolbar.Delegate,
NSMenu.Validation {
    private static final Logger log = LogManager.getLogger(TransferController.class);
    private final TransferToolbarValidator toolbarValidator = new TransferToolbarValidator(this);
    private final TransferToolbarFactory toolbarFactory = new TransferToolbarFactory(this);
    private final NSNotificationCenter notificationCenter = NSNotificationCenter.defaultCenter();
    private final Preferences preferences = PreferencesFactory.get();
    private final TransferCollection collection = TransferCollection.defaultCollection();
    private final TableColumnFactory tableColumnsFactory = new TableColumnFactory();
    private final BandwidthMenuDelegate bandwidthMenuDelegate = new BandwidthMenuDelegate();
    private final TranscriptListener transcript = new UnifiedSystemLogTranscriptListener();
    private NSProgressIndicator transferSpinner;
    private NSToolbar toolbar;
    private NSTextField urlField;
    private NSTextField localField;
    private NSTextField localLabel;
    private NSImageView iconView;
    private NSTextField filterField;
    private NSTableView transferTable;
    private TransferTableDataSource transferTableModel;
    private AbstractTableDelegate<Transfer, TransferColumn> transferTableDelegate;

    public TransferController() {
        this.collection.addListener((CollectionListener)new AbstractCollectionListener<Transfer>(){

            public void collectionLoaded() {
                TransferController.this.invoke((MainAction)new ControllerMainAction((Controller)TransferController.this){

                    public void run() {
                        TransferController.this.reload();
                    }
                });
            }

            public void collectionItemAdded(Transfer item) {
                TransferController.this.invoke((MainAction)new ControllerMainAction((Controller)TransferController.this){

                    public void run() {
                        TransferController.this.reload();
                    }
                });
            }

            public void collectionItemRemoved(Transfer item) {
                TransferController.this.invoke((MainAction)new ControllerMainAction((Controller)TransferController.this){

                    public void run() {
                        TransferController.this.reload();
                    }
                });
            }
        });
    }

    public void awakeFromNib() {
        this.toolbar = NSToolbar.toolbarWithIdentifier((String)"Transfer Toolbar");
        this.toolbar.setDelegate(this.id());
        this.toolbar.setAllowsUserCustomization(true);
        this.toolbar.setAutosavesConfiguration(true);
        this.toolbar.setDisplayMode(NSToolbar.NSToolbarDisplayModeLabelOnly);
        this.window.setToolbar(this.toolbar);
        if (!this.collection.isLoaded()) {
            this.transferSpinner.startAnimation(null);
        }
        this.collection.addListener((CollectionListener)new AbstractCollectionListener<Transfer>(){

            public void collectionLoaded() {
                TransferController.this.invoke((MainAction)new WindowMainAction(TransferController.this){

                    public void run() {
                        TransferController.this.transferSpinner.stopAnimation(null);
                        TransferController.this.transferTable.setGridStyleMask(NSTableView.NSTableViewSolidHorizontalGridLineMask);
                    }
                });
            }
        });
        if (this.collection.isLoaded()) {
            this.transferSpinner.stopAnimation(null);
            this.transferTable.setGridStyleMask(NSTableView.NSTableViewSolidHorizontalGridLineMask);
        }
        super.awakeFromNib();
    }

    public void setWindow(NSWindow window) {
        window.setFrameAutosaveName("Transfers");
        window.setContentMinSize(new NSSize(400.0, 150.0));
        window.setMovableByWindowBackground(true);
        window.setTitle(LocaleFactory.localizedString((String)"Transfers"));
        if (window.respondsToSelector(Foundation.selector((String)"setTabbingIdentifier:"))) {
            window.setTabbingIdentifier(this.preferences.getProperty("queue.window.tabbing.identifier"));
        }
        super.setWindow(window);
    }

    public boolean isSingleton() {
        return true;
    }

    public void windowDidBecomeKey(NSNotification notification) {
        this.updateHighlight();
    }

    public void windowDidResignKey(NSNotification notification) {
        this.updateHighlight();
    }

    public void windowDidBecomeMain(NSNotification notification) {
        this.updateHighlight();
    }

    public void windowDidResignMain(NSNotification notification) {
        this.updateHighlight();
    }

    public void setUrlField(NSTextField urlField) {
        this.urlField = urlField;
        this.urlField.setAllowsEditingTextAttributes(true);
        this.urlField.setSelectable(true);
    }

    public void setLocalField(NSTextField localField) {
        this.localField = localField;
        this.localField.setAllowsEditingTextAttributes(true);
        this.localField.setSelectable(true);
    }

    public void setLocalLabel(NSTextField localLabel) {
        this.localLabel = localLabel;
        this.localLabel.setStringValue(LocaleFactory.localizedString((String)"Local File:", (String)"Transfer"));
    }

    public void setIconView(NSImageView iconView) {
        this.iconView = iconView;
    }

    public void connectionsPopupChanged(NSMenuItem sender) {
        if (null == sender.representedObject()) {
            return;
        }
        int connections = Integer.parseInt(sender.representedObject());
        this.preferences.setProperty("queue.connections.limit", connections);
        TransferQueue queue = TransferQueueFactory.get();
        queue.resize(connections);
    }

    public NSTextField getFilterField() {
        return this.filterField;
    }

    public void setFilterField(NSTextField t) {
        this.filterField = t;
        this.notificationCenter.addObserver(this.id(), Foundation.selector((String)"filterFieldTextDidChange:"), "NSControlTextDidChangeNotification", t.id());
    }

    public void filterFieldTextDidChange(NSNotification notification) {
        this.transferTableModel.setFilter(this.filterField.stringValue());
        this.reload();
    }

    public void setTransferSpinner(NSProgressIndicator transferSpinner) {
        this.transferSpinner = transferSpinner;
    }

    public void searchButtonClicked(ID sender) {
        this.window.makeFirstResponder((NSResponder)this.filterField);
    }

    public void bandwidthPopupChanged(NSMenuItem sender) {
        if (null == sender.representedObject()) {
            return;
        }
        NSIndexSet selected = this.transferTable.selectedRowIndexes();
        float bandwidth = Float.parseFloat(sender.representedObject());
        NSUInteger index = selected.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            Transfer transfer = (Transfer)this.collection.get(index.intValue());
            transfer.setBandwidth(bandwidth);
            if (transfer.isRunning()) {
                for (BackgroundAction action : (BackgroundAction[])this.registry.toArray((Object[])new BackgroundAction[this.registry.size()])) {
                    TransferBackgroundAction t;
                    if (!(action instanceof TransferBackgroundAction) || !(t = (TransferBackgroundAction)action).getTransfer().equals(transfer)) continue;
                    TransferSpeedometer meter = t.getMeter();
                    meter.reset();
                }
            }
            index = selected.indexGreaterThanIndex(index);
        }
    }

    protected String getBundleName() {
        return "Transfer";
    }

    public void invalidate() {
        this.toolbar.setDelegate(null);
        this.transferTableModel.invalidate();
        super.invalidate();
    }

    public void setQueueTable(NSTableView view) {
        this.transferTable = view;
        this.transferTable.setRowHeight(new CGFloat(82.0));
        NSTableColumn c = this.tableColumnsFactory.create(TransferColumn.progress.name());
        c.setMinWidth(80.0);
        c.setWidth(300.0);
        c.setResizingMask(1);
        this.transferTable.addTableColumn(c);
        this.transferTableModel = new TransferTableDataSource();
        this.transferTable.setDataSource(this.transferTableModel.id());
        this.transferTableDelegate = new AbstractTableDelegate<Transfer, TransferColumn>(this.transferTable.tableColumnWithIdentifier(TransferColumn.progress.name())){

            public String tooltip(Transfer t, TransferColumn column) {
                return t.getName();
            }

            public void enterKeyPressed(ID sender) {
                this.tableRowDoubleClicked(sender);
            }

            public void deleteKeyPressed(ID sender) {
                TransferController.this.deleteButtonClicked(sender);
            }

            public void tableColumnClicked(NSTableView view, NSTableColumn tableColumn) {
            }

            public void tableRowDoubleClicked(ID sender) {
                TransferController.this.reloadButtonClicked(sender);
            }

            public void selectionIsChanging(NSNotification notification) {
                TransferController.this.updateHighlight();
            }

            public void selectionDidChange(NSNotification notification) {
                TransferController.this.updateHighlight();
                TransferController.this.updateSelection();
                TransferController.this.transferTable.noteHeightOfRowsWithIndexesChanged(NSIndexSet.indexSetWithIndexesInRange((NSRange)NSRange.NSMakeRange((NSUInteger)new NSUInteger(0L), (NSUInteger)new NSUInteger((NativeLong)TransferController.this.transferTable.numberOfRows()))));
            }

            public NSView tableView_viewForTableColumn_row(NSTableView view, NSTableColumn column, NSInteger row) {
                ProgressController controller = TransferController.this.transferTableModel.getController(row.intValue());
                return controller.view();
            }

            public boolean isTypeSelectSupported() {
                return true;
            }

            public String tableView_typeSelectStringForTableColumn_row(NSTableView view, NSTableColumn column, NSInteger row) {
                return ((Transfer)TransferController.this.transferTableModel.getSource().get(row.intValue())).getName();
            }
        };
        this.transferTable.setDelegate(this.transferTableDelegate.id());
        this.transferTable.registerForDraggedTypes(NSArray.arrayWithObjects((String[])new String[]{"NSStringPboardType", "Apple files promise pasteboard type"}));
        this.transferTable.setGridStyleMask(NSTableView.NSTableViewGridNone);
        this.transferTable.setAllowsMultipleSelection(true);
        this.transferTable.setAllowsEmptySelection(true);
        this.transferTable.setAllowsColumnReordering(false);
        this.transferTable.sizeToFit();
    }

    public NSTableView getTransferTable() {
        return this.transferTable;
    }

    public TransferTableDataSource getTransferTableModel() {
        return this.transferTableModel;
    }

    private void updateHighlight() {
        boolean main = this.window().isMainWindow();
        NSIndexSet set = this.transferTable.selectedRowIndexes();
        for (int i = 0; i < this.transferTableModel.numberOfRowsInTableView(this.transferTable).intValue(); ++i) {
            boolean highlighted;
            boolean bl = highlighted = set.containsIndex(new NSUInteger((long)i)) && main;
            if (this.transferTableModel.isHighlighted(i) == highlighted) continue;
            this.transferTableModel.setHighlighted(i, highlighted);
        }
    }

    private void updateSelection() {
        this.updateLabels();
        this.updateIcon();
        this.toolbar.validateVisibleItems();
    }

    private void updateLabels() {
        int selected = this.transferTable.numberOfSelectedRows().intValue();
        if (1 == selected) {
            Transfer transfer = (Transfer)this.transferTableModel.getSource().get(this.transferTable.selectedRow().intValue());
            String remote = transfer.getRemote().getUrl();
            this.urlField.setAttributedStringValue(HyperlinkAttributedStringFactory.create((String)remote));
            String local = transfer.getLocal();
            if (local != null) {
                this.localField.setAttributedStringValue(HyperlinkAttributedStringFactory.create((String)local, (Local)LocalFactory.get((String)local)));
            } else {
                this.localField.setStringValue("");
            }
        } else {
            this.urlField.setStringValue("");
            this.localField.setStringValue("");
        }
    }

    private void updateIcon() {
        int selected = this.transferTable.numberOfSelectedRows().intValue();
        if (1 == selected) {
            Transfer transfer = (Transfer)this.transferTableModel.getSource().get(this.transferTable.selectedRow().intValue());
            if (transfer.getRoots().size() == 1) {
                if (transfer.getLocal() != null) {
                    this.iconView.setImage((NSImage)IconCacheFactory.get().fileIcon(transfer.getRoot().local, Integer.valueOf(32)));
                } else {
                    this.iconView.setImage((NSImage)IconCacheFactory.get().fileIcon(transfer.getRoot().remote, Integer.valueOf(32)));
                }
            } else {
                this.iconView.setImage((NSImage)IconCacheFactory.get().iconNamed("NSMultipleDocuments", Integer.valueOf(32)));
            }
        } else {
            this.iconView.setImage(null);
        }
    }

    private void reload() {
        while (this.transferTable.subviews().count().intValue() > 0) {
            ((NSView)Rococoa.cast((ObjCObject)this.transferTable.subviews().lastObject(), NSView.class)).removeFromSuperviewWithoutNeedingDisplay();
        }
        this.transferTable.reloadData();
        this.updateHighlight();
        this.updateSelection();
    }

    public void add(final Transfer transfer, final TransferBackgroundAction action) {
        if (this.collection.size() > this.preferences.getInteger("queue.size.warn")) {
            final NSAlert alert = NSAlert.alert((String)TransferToolbarFactory.TransferToolbarItem.cleanup.label(), (String)LocaleFactory.localizedString((String)"Remove completed transfers from list."), (String)TransferToolbarFactory.TransferToolbarItem.cleanup.label(), (String)LocaleFactory.localizedString((String)"Cancel"), null);
            alert.setShowsSuppressionButton(true);
            alert.suppressionButton().setTitle(LocaleFactory.localizedString((String)"Don't ask again", (String)"Configuration"));
            this.alert(alert, new SheetCallback(){

                public void callback(int returncode) {
                    if (alert.suppressionButton().state() == 1) {
                        TransferController.this.preferences.setProperty("queue.size.warn", Integer.MAX_VALUE);
                    }
                    if (returncode == 1) {
                        TransferController.this.clearButtonClicked(null);
                    }
                    TransferController.this.add(transfer);
                    TransferController.this.background((BackgroundAction)action);
                }
            });
        } else {
            this.add(transfer);
            this.background((BackgroundAction)action);
        }
    }

    private void add(Transfer transfer) {
        this.collection.add((Object)transfer);
        int row = this.collection.size() - 1;
        NSInteger index = new NSInteger((long)row);
        this.transferTable.selectRowIndexes(NSIndexSet.indexSetWithIndex((NSInteger)index), false);
        this.transferTable.scrollRowToVisible(index);
    }

    public void transferDidStart(Transfer transfer) {
        ProgressController progress = this.transferTableModel.getController(transfer);
        progress.transferDidStart(transfer);
        this.invoke((MainAction)new DefaultMainAction(){

            public void run() {
                TransferController.this.toolbar.validateVisibleItems();
            }
        });
    }

    public void transferDidStop(Transfer transfer) {
        ProgressController progress = this.transferTableModel.getController(transfer);
        progress.transferDidStop(transfer);
        this.invoke((MainAction)new DefaultMainAction(){

            public void run() {
                TransferController.this.toolbar.validateVisibleItems();
            }
        });
    }

    public void transferDidProgress(Transfer transfer, TransferProgress status) {
        ProgressController progress = this.transferTableModel.getController(transfer);
        progress.transferDidProgress(transfer, status);
    }

    public void start(Transfer transfer, TransferOptions options) {
        this.start(transfer, options, new TransferCallback(){

            public void complete(Transfer transfer) {
            }
        });
    }

    public void start(final Transfer transfer, TransferOptions options, final TransferCallback callback) {
        ProgressController progress = this.transferTableModel.getController(transfer);
        PathCache cache = new PathCache(this.preferences.getInteger("transfer.cache.size"));
        Host source = transfer.getSource();
        Host destination = transfer.getDestination();
        TransferCollectionBackgroundAction action = new TransferCollectionBackgroundAction((Controller)this, null == source ? SessionPool.DISCONNECTED : SessionPoolFactory.create((Controller)this, (Host)source, (ProgressListener)progress), null == destination ? SessionPool.DISCONNECTED : SessionPoolFactory.create((Controller)this, (Host)destination, (ProgressListener)progress), this, progress, transfer, options){

            public void init() {
                super.init();
                if (TransferController.this.preferences.getBoolean("queue.window.open.transfer.start")) {
                    TransferController.this.window.makeKeyAndOrderFront(null);
                }
            }

            public void finish() {
                super.finish();
                if (transfer.isComplete()) {
                    callback.complete(transfer);
                }
            }

            public void cleanup() {
                super.cleanup();
                if (transfer.isReset() && transfer.isComplete() && TransferController.this.preferences.getBoolean("queue.window.open.transfer.stop") && TransferController.this.collection.numberOfRunningTransfers() <= 0) {
                    TransferController.this.window.orderOut(null);
                }
            }
        };
        if (!this.collection.contains((Object)transfer)) {
            this.add(transfer, (TransferBackgroundAction)action);
        } else {
            this.background((BackgroundAction)action);
        }
    }

    public void log(TranscriptListener.Type type, String message) {
        this.transcript.log(type, message);
    }

    public NSToolbarItem toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar(NSToolbar toolbar, String identifier, boolean flag) {
        return this.toolbarFactory.create(identifier);
    }

    public void paste(ID sender) {
        for (PathPasteboard pasteboard : PathPasteboardFactory.allPasteboards()) {
            if (pasteboard.isEmpty()) continue;
            if (log.isDebugEnabled()) {
                log.debug("Paste download transfer from pasteboard");
            }
            ArrayList<TransferItem> downloads = new ArrayList<TransferItem>();
            for (Path download : pasteboard) {
                downloads.add(new TransferItem(download, LocalFactory.get((Local)new DownloadDirectoryFinder().find(pasteboard.getBookmark()), (String)download.getName())));
            }
            this.add((Transfer)new DownloadTransfer(pasteboard.getBookmark(), downloads));
            pasteboard.clear();
        }
    }

    public void stopButtonClicked(ID sender) {
        NSIndexSet selected = this.transferTable.selectedRowIndexes();
        NSUInteger index = selected.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            Transfer transfer = (Transfer)this.transferTableModel.getSource().get(index.intValue());
            if (transfer.isRunning()) {
                for (BackgroundAction action : (BackgroundAction[])this.registry.toArray((Object[])new BackgroundAction[this.registry.size()])) {
                    TransferBackgroundAction t;
                    if (!(action instanceof TransferBackgroundAction) || !(t = (TransferBackgroundAction)action).getTransfer().equals(transfer)) continue;
                    t.cancel();
                }
            }
            index = selected.indexGreaterThanIndex(index);
        }
    }

    public void stopAllButtonClicked(ID sender) {
        Collection<Transfer> transfers = this.transferTableModel.getSource();
        for (Transfer transfer : transfers) {
            if (!transfer.isRunning()) continue;
            for (BackgroundAction action : (BackgroundAction[])this.registry.toArray((Object[])new BackgroundAction[this.registry.size()])) {
                TransferBackgroundAction t;
                if (!(action instanceof TransferBackgroundAction) || !(t = (TransferBackgroundAction)action).getTransfer().equals(transfer)) continue;
                t.cancel();
            }
        }
    }

    public void resumeButtonClicked(ID sender) {
        NSIndexSet selected = this.transferTable.selectedRowIndexes();
        NSUInteger index = selected.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            Collection<Transfer> transfers = this.transferTableModel.getSource();
            Transfer transfer = (Transfer)transfers.get(index.intValue());
            if (!transfer.isRunning()) {
                TransferOptions options = new TransferOptions();
                options.resumeRequested = true;
                options.reloadRequested = false;
                this.start(transfer, options);
            }
            index = selected.indexGreaterThanIndex(index);
        }
    }

    public void reloadButtonClicked(ID sender) {
        NSIndexSet selected = this.transferTable.selectedRowIndexes();
        NSUInteger index = selected.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            Collection<Transfer> transfers = this.transferTableModel.getSource();
            Transfer transfer = (Transfer)transfers.get(index.intValue());
            if (!transfer.isRunning()) {
                TransferOptions options = new TransferOptions();
                options.resumeRequested = false;
                options.reloadRequested = true;
                this.start(transfer, options);
            }
            index = selected.indexGreaterThanIndex(index);
        }
    }

    public void openButtonClicked(ID sender) {
        if (this.transferTable.numberOfSelectedRows().intValue() == 1) {
            Transfer transfer = (Transfer)this.transferTableModel.getSource().get(this.transferTable.selectedRow().intValue());
            for (TransferItem l : transfer.getRoots()) {
                ApplicationLauncherFactory.get().open(l.local);
            }
        }
    }

    public void revealButtonClicked(ID sender) {
        NSIndexSet selected = this.transferTable.selectedRowIndexes();
        Collection<Transfer> transfers = this.transferTableModel.getSource();
        RevealService reveal = RevealServiceFactory.get();
        NSUInteger index = selected.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            Transfer transfer = (Transfer)transfers.get(index.intValue());
            for (TransferItem l : transfer.getRoots()) {
                reveal.reveal(l.local);
            }
            index = selected.indexGreaterThanIndex(index);
        }
    }

    public void deleteButtonClicked(ID sender) {
        NSIndexSet selected = this.transferTable.selectedRowIndexes();
        Collection<Transfer> transfers = this.transferTableModel.getSource();
        int i = 0;
        ArrayList<Transfer> remove = new ArrayList<Transfer>();
        NSUInteger index = selected.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            Transfer t = (Transfer)transfers.get(index.intValue() - i);
            if (!t.isRunning()) {
                remove.add(t);
            }
            index = selected.indexGreaterThanIndex(index);
        }
        this.collection.removeAll(remove);
        this.collection.save();
    }

    public void clearButtonClicked(ID sender) {
        this.collection.removeIf(Transfer::isComplete);
        this.collection.save();
    }

    public void trashButtonClicked(ID sender) {
        NSIndexSet selected = this.transferTable.selectedRowIndexes();
        Collection<Transfer> transfers = this.transferTableModel.getSource();
        NSUInteger index = selected.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            Transfer transfer = (Transfer)transfers.get(index.intValue());
            if (!transfer.isRunning()) {
                for (TransferItem l : transfer.getRoots()) {
                    try {
                        LocalTrashFactory.get().trash(l.local);
                    }
                    catch (AccessDeniedException e) {
                        log.warn(String.format("Failure trashing file %s %s", l.local, e.getMessage()));
                    }
                }
            }
            index = selected.indexGreaterThanIndex(index);
        }
        this.updateIcon();
    }

    public void printDocument(ID sender) {
        this.print((NSView)this.transferTable);
    }

    public NSArray toolbarDefaultItemIdentifiers(NSToolbar toolbar) {
        return this.toolbarFactory.getDefault();
    }

    public NSArray toolbarAllowedItemIdentifiers(NSToolbar toolbar) {
        return this.toolbarFactory.getAllowed();
    }

    public NSArray toolbarSelectableItemIdentifiers(NSToolbar toolbar) {
        return NSArray.array();
    }

    public boolean validateMenuItem(NSMenuItem item) {
        Selector action = item.action();
        if (action.equals((Object)Foundation.selector((String)"paste:"))) {
            List pasteboards = PathPasteboardFactory.allPasteboards();
            if (pasteboards.size() == 1) {
                for (PathPasteboard pasteboard : pasteboards) {
                    if (pasteboard.size() == 1) {
                        item.setTitle(MessageFormat.format(LocaleFactory.localizedString((String)"Paste {0}"), ((Path)pasteboard.get(0)).getName()));
                        continue;
                    }
                    item.setTitle(MessageFormat.format(LocaleFactory.localizedString((String)"Paste {0}"), MessageFormat.format(LocaleFactory.localizedString((String)"{0} Items"), String.valueOf(pasteboard.size())) + ")"));
                }
            } else {
                item.setTitle(LocaleFactory.localizedString((String)"Paste"));
            }
        }
        return this.toolbarValidator.validate(action);
    }

    public boolean validateToolbarItem(NSToolbarItem item) {
        return this.toolbarValidator.validate(item);
    }

    public AbstractMenuDelegate getBandwidthMenuDelegate() {
        return this.bandwidthMenuDelegate;
    }

    private class BandwidthMenuDelegate
    extends AbstractMenuDelegate {
        private BandwidthMenuDelegate() {
        }

        public NSInteger numberOfItemsInMenu(NSMenu menu) {
            return new NSInteger((long)(new StringTokenizer(TransferController.this.preferences.getProperty("queue.bandwidth.options"), ",").countTokens() + 2));
        }

        @Override
        public boolean menuUpdateItemAtIndex(NSMenu menu, NSMenuItem item, NSInteger i, boolean cancel) {
            if (item.representedObject() != null) {
                int selected = TransferController.this.transferTable.numberOfSelectedRows().intValue();
                int bytes = Integer.parseInt(item.representedObject());
                NSIndexSet iterator = TransferController.this.transferTable.selectedRowIndexes();
                NSUInteger index = iterator.firstIndex();
                while (!index.equals((Object)NSIndexSet.NSNotFound)) {
                    Transfer transfer = (Transfer)TransferController.this.collection.get(index.intValue());
                    if (-1.0f == transfer.getBandwidth().getRate()) {
                        if (-1 == bytes) {
                            item.setState(selected > 1 ? -1 : 1);
                            break;
                        }
                        item.setState(0);
                    } else {
                        int bandwidth = (int)transfer.getBandwidth().getRate();
                        if (bytes == bandwidth) {
                            item.setState(selected > 1 ? -1 : 1);
                            break;
                        }
                        item.setState(0);
                    }
                    index = iterator.indexGreaterThanIndex(index);
                }
            }
            return super.menuUpdateItemAtIndex(menu, item, i, cancel);
        }

        @Override
        public Selector getDefaultAction() {
            return Foundation.selector((String)"bandwidthPopupChanged:");
        }
    }

    private static enum TransferColumn {
        progress;

    }
}

