/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.AlertController;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.NSMenuItem;
import ch.cyberduck.binding.application.NSPopUpButton;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.binding.foundation.NSAttributedString;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSMutableAttributedString;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.StringAppender;
import ch.cyberduck.core.features.Location;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.rococoa.cocoa.foundation.NSPoint;
import org.rococoa.cocoa.foundation.NSRect;

public class RegionController
extends AlertController {
    private NSView view;
    private NSPopUpButton regionPopup;
    private final Set<Location.Name> regions;
    private final Location.Name defaultRegion;
    private final Callback callback;

    public RegionController(Set<Location.Name> regions, Location.Name defaultRegion, Callback callback) {
        this.regions = regions;
        this.defaultRegion = defaultRegion;
        this.callback = callback;
    }

    public void loadBundle() {
        NSAlert alert = NSAlert.alert();
        alert.setAlertStyle(1);
        alert.setMessageText(LocaleFactory.localizedString((String)"Choose Region", (String)"Folder"));
        String message = LocaleFactory.localizedString((String)"Select the region for the new folder", (String)"Folder");
        alert.setInformativeText(new StringAppender().append(message).toString());
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Choose"));
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Cancel", (String)"Folder"));
        super.loadBundle(alert);
    }

    public NSView getAccessoryView(NSAlert alert) {
        this.view = NSView.create((NSRect)new NSRect(alert.window().frame().size.width.doubleValue(), 0.0));
        this.regionPopup = NSPopUpButton.buttonWithFrame((NSRect)new NSRect(alert.window().frame().size.width.doubleValue(), 26.0));
        this.regionPopup.setFrameOrigin(new NSPoint(0.0, 0.0));
        for (Location.Name region : this.regions) {
            NSMenuItem item = this.regionPopup.itemWithTitle(region.toString());
            item.setRepresentedObject(region.getIdentifier());
            if (!StringUtils.equals((CharSequence)region.getIdentifier(), (CharSequence)region.toString())) {
                NSMutableAttributedString description = NSMutableAttributedString.create((String)item.title());
                description.appendAttributedString((NSAttributedString)NSMutableAttributedString.create((String)String.format("\n%s", region.getIdentifier()), (NSDictionary)MENU_HELP_FONT_ATTRIBUTES));
                item.setAttributedTitle((NSAttributedString)description);
            }
            if (!region.equals((Object)this.defaultRegion)) continue;
            this.regionPopup.selectItem(this.regionPopup.lastItem());
        }
        this.view.addSubview((NSView)this.regionPopup);
        return this.view;
    }

    public void callback(int returncode) {
        switch (returncode) {
            case 1: {
                this.callback.callback(new Location.Name(this.regionPopup.selectedItem().representedObject()));
            }
        }
    }

    public static interface Callback {
        public void callback(Location.Name var1);
    }
}

