/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.AlertController;
import ch.cyberduck.binding.SheetInvoker;
import ch.cyberduck.binding.WindowController;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.NSProgressIndicator;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.binding.application.SheetCallback;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProviderHelpServiceFactory;
import ch.cyberduck.core.StringAppender;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rococoa.cocoa.foundation.NSPoint;
import org.rococoa.cocoa.foundation.NSRect;

public class ProgressAlertController
extends AlertController {
    private static final Logger log = LogManager.getLogger(ProgressAlertController.class);
    private final CountDownLatch signal;
    private final String title;
    private final String message;
    private final Protocol protocol;
    private NSView view;
    private NSProgressIndicator progress;

    public ProgressAlertController(CountDownLatch signal, String title, String message, Protocol protocol) {
        this.signal = signal;
        this.title = title;
        this.message = message;
        this.protocol = protocol;
    }

    public void loadBundle() {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Load alert for message %s", this.message));
        }
        NSAlert alert = NSAlert.alert();
        alert.setAlertStyle(1);
        alert.setMessageText(this.title);
        alert.setInformativeText(new StringAppender().append(this.message).toString());
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Cancel"));
        alert.setShowsHelp(true);
        alert.setShowsSuppressionButton(false);
        super.loadBundle(alert);
    }

    public int beginSheet(WindowController parent) {
        return new SheetInvoker((SheetCallback)this, parent, (WindowController)this, this.signal).beginSheet();
    }

    public NSView getAccessoryView(NSAlert alert) {
        this.view = NSView.create((NSRect)new NSRect(alert.window().frame().size.width.doubleValue(), 0.0));
        this.progress = NSProgressIndicator.progressIndicatorWithFrame((NSRect)new NSRect(alert.window().frame().size.width.doubleValue(), 18.0));
        this.progress.setIndeterminate(true);
        this.progress.setDisplayedWhenStopped(false);
        this.progress.setStyle(1);
        this.progress.setControlSize(0);
        this.progress.setFrameOrigin(new NSPoint(0.0, 0.0));
        this.view.addSubview((NSView)this.progress);
        this.progress.startAnimation(this.id());
        return this.view;
    }

    protected String help() {
        return ProviderHelpServiceFactory.get().help(this.protocol);
    }
}

