/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.AbstractTableDelegate;
import ch.cyberduck.binding.BundleController;
import ch.cyberduck.binding.OutlineDataSource;
import ch.cyberduck.binding.application.NSButton;
import ch.cyberduck.binding.application.NSColor;
import ch.cyberduck.binding.application.NSFont;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSImageView;
import ch.cyberduck.binding.application.NSOutlineView;
import ch.cyberduck.binding.application.NSProgressIndicator;
import ch.cyberduck.binding.application.NSSearchField;
import ch.cyberduck.binding.application.NSTableCellView;
import ch.cyberduck.binding.application.NSTableColumn;
import ch.cyberduck.binding.application.NSTableView;
import ch.cyberduck.binding.application.NSTextField;
import ch.cyberduck.binding.application.NSTextFieldCell;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSAttributedString;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSMutableAttributedString;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.binding.foundation.NSNotificationCenter;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.binding.foundation.NSString;
import ch.cyberduck.core.BookmarkCollection;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Profile;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.ProviderHelpServiceFactory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.local.BrowserLauncherFactory;
import ch.cyberduck.core.profiles.LocalProfileDescription;
import ch.cyberduck.core.profiles.ProfileDescription;
import ch.cyberduck.core.profiles.ProfilesFinder;
import ch.cyberduck.core.profiles.ProfilesSynchronizeWorker;
import ch.cyberduck.core.profiles.ProfilesWorkerBackgroundAction;
import ch.cyberduck.core.profiles.SearchProfilePredicate;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.core.threading.BackgroundAction;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.cocoa.CGFloat;
import org.rococoa.cocoa.foundation.NSInteger;

public class ProfilesPreferencesController
extends BundleController {
    private static final Logger log = LogManager.getLogger(ProfilesPreferencesController.class);
    private final ProtocolFactory protocols = ProtocolFactory.get();
    private final NSNotificationCenter notificationCenter = NSNotificationCenter.defaultCenter();
    private final Map<ProfileDescription, Profile> repository = Collections.synchronizedMap(new LinkedHashMap());
    private ProfilesTableDataSource profilesTableDataSource;
    private ProfilesTableDelegate profilesTableDelegate;
    private NSView panelProfiles;
    private NSSearchField searchField;
    private NSOutlineView profilesTableView;
    private NSProgressIndicator progressIndicator;
    private static final NSDictionary PRIMARY_FONT_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys((NSArray)NSArray.arrayWithObjects((NSObject[])new NSObject[]{NSFont.boldSystemFontOfSize((double)NSFont.systemFontSize()), NSColor.controlTextColor(), BundleController.PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_TAIL}), (NSArray)NSArray.arrayWithObjects((String[])new String[]{"NSFont", "NSColor", "NSParagraphStyle"}));
    private static final NSDictionary SECONDARY_FONT_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys((NSArray)NSArray.arrayWithObjects((NSObject[])new NSObject[]{NSFont.systemFontOfSize((double)NSFont.systemFontSize()), NSColor.secondaryLabelColor(), BundleController.PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_TAIL}), (NSArray)NSArray.arrayWithObjects((String[])new String[]{"NSFont", "NSColor", "NSParagraphStyle"}));

    protected String getBundleName() {
        return "Profiles";
    }

    public void setPanelProfiles(NSView panelProfiles) {
        this.panelProfiles = panelProfiles;
    }

    public void setSearchField(NSSearchField searchField) {
        this.searchField = searchField;
        if (this.searchField.respondsToSelector(Foundation.selector((String)"setSendsWholeSearchString:"))) {
            this.searchField.setSendsWholeSearchString(false);
        }
        if (this.searchField.respondsToSelector(Foundation.selector((String)"setSendsSearchStringImmediately:"))) {
            this.searchField.setSendsSearchStringImmediately(false);
        }
        this.searchField.cell().setSendsActionOnEndEditing(false);
        this.searchField.setTarget(this.id());
        this.searchField.setAction(Foundation.selector((String)"searchFieldTextDidChange:"));
        this.notificationCenter.addObserver(this.id(), Foundation.selector((String)"searchFieldTextDidEndEditing:"), "NSControlTextDidEndEditingNotification", this.searchField.id());
    }

    public void searchFieldTextDidChange(NSNotification notification) {
        this.searchFieldTextDidEndEditing(notification);
    }

    public void searchFieldTextDidEndEditing(NSNotification notification) {
        this.reload();
    }

    private void reload() {
        String input = this.searchField.stringValue();
        if (StringUtils.isBlank((String)input)) {
            this.profilesTableDataSource.withSource(ProfilesPreferencesController.toSorted(this.repository.keySet()));
        } else {
            this.profilesTableDataSource.withSource(ProfilesPreferencesController.toSorted(this.repository.keySet().stream().filter(new SearchProfilePredicate(input)).collect(Collectors.toSet())));
        }
        this.profilesTableView.reloadData();
    }

    public void setProfilesTableView(NSOutlineView profilesTableView) {
        this.profilesTableView = profilesTableView;
        this.profilesTableDataSource = new ProfilesTableDataSource().withSource(ProfilesPreferencesController.toSorted(this.repository.keySet()));
        this.profilesTableView.setDataSource(this.profilesTableDataSource.id());
        this.profilesTableDelegate = new ProfilesTableDelegate(profilesTableView.tableColumnWithIdentifier("Default"));
        this.profilesTableView.setDelegate(this.profilesTableDelegate.id());
    }

    public void setProgressIndicator(NSProgressIndicator progressIndicator) {
        this.progressIndicator = progressIndicator;
        this.progressIndicator.setDisplayedWhenStopped(false);
    }

    public NSView getPanel() {
        return this.panelProfiles;
    }

    protected void load() {
        if (this.repository.isEmpty()) {
            try {
                this.progressIndicator.startAnimation(null);
                this.background((BackgroundAction)new ProfilesWorkerBackgroundAction((Controller)this, new ProfilesSynchronizeWorker(this.protocols, ProfilesFinder.Visitor.Prefetch){

                    public void cleanup(Set<ProfileDescription> set) {
                        for (ProfileDescription description : set) {
                            if (!description.getProfile().isPresent()) continue;
                            ProfilesPreferencesController.this.repository.put(description, (Profile)description.getProfile().get());
                        }
                        ProfilesPreferencesController.this.reload();
                        ProfilesPreferencesController.this.progressIndicator.stopAnimation(null);
                    }
                }));
            }
            catch (BackgroundException e) {
                log.error(String.format("Failure %s retrieving profiles", new Object[]{e}));
            }
        }
    }

    private static List<ProfileDescription> toSorted(Set<ProfileDescription> profiles) {
        return profiles.stream().filter(description -> description.getProfile().isPresent()).sorted(Comparator.comparing(o -> (Profile)o.getProfile().get())).collect(Collectors.toList());
    }

    public static final class ProfilesTableDataSource
    extends OutlineDataSource {
        private List<ProfileDescription> profiles;

        public ProfilesTableDataSource withSource(List<ProfileDescription> source) {
            this.profiles = source;
            return this;
        }

        public NSInteger outlineView_numberOfChildrenOfItem(NSOutlineView view, NSObject item) {
            if (null == item) {
                return new NSInteger((long)this.profiles.size());
            }
            return new NSInteger(0L);
        }

        public NSObject outlineView_child_ofItem(NSOutlineView outlineView, NSInteger index, NSObject item) {
            if (null == item) {
                return NSString.stringWithString((String)this.profiles.get((int)index.intValue()).getChecksum().hash);
            }
            return null;
        }

        public NSObject outlineView_objectValueForTableColumn_byItem(NSOutlineView outlineView, NSTableColumn tableColumn, NSObject item) {
            if (null == item) {
                return null;
            }
            return item;
        }

        public boolean outlineView_isItemExpandable(NSOutlineView view, NSObject item) {
            return null == item;
        }
    }

    public final class ProfilesTableDelegate
    extends AbstractTableDelegate<Protocol, Void>
    implements NSOutlineView.Delegate {
        private final Map<ProfileDescription, ProfileTableViewController> controllers;

        public ProfilesTableDelegate(NSTableColumn selectedColumn) {
            super(selectedColumn);
            this.controllers = new HashMap<ProfileDescription, ProfileTableViewController>();
        }

        private ProfileDescription fromChecksum(NSObject hash) {
            Optional<ProfileDescription> found = ProfilesPreferencesController.this.repository.keySet().stream().filter(description -> description.getChecksum().hash.equals(hash.toString())).findFirst();
            return found.orElse(null);
        }

        public void tableColumnClicked(NSTableView view, NSTableColumn tableColumn) {
        }

        public void tableRowDoubleClicked(ID sender) {
        }

        public void selectionDidChange(NSNotification notification) {
        }

        protected boolean isTypeSelectSupported() {
            return true;
        }

        public String outlineView_typeSelectStringForTableColumn_item(NSOutlineView view, NSTableColumn tableColumn, NSObject item) {
            ProfileDescription description = this.fromChecksum(item);
            if (null == description) {
                return null;
            }
            return ((Profile)ProfilesPreferencesController.this.repository.get(description)).getDescription();
        }

        public void enterKeyPressed(ID sender) {
        }

        public void deleteKeyPressed(ID sender) {
        }

        public String tooltip(Protocol item, Void unused) {
            return item.getDescription();
        }

        public void outlineView_willDisplayCell_forTableColumn_item(NSOutlineView view, NSTextFieldCell cell, NSTableColumn tableColumn, NSObject item) {
        }

        public boolean outlineView_shouldExpandItem(NSOutlineView view, NSObject item) {
            return false;
        }

        public void outlineViewItemWillExpand(NSNotification notification) {
        }

        public void outlineViewItemDidExpand(NSNotification notification) {
        }

        public void outlineViewItemWillCollapse(NSNotification notification) {
        }

        public void outlineViewItemDidCollapse(NSNotification notification) {
        }

        public boolean outlineView_isGroupItem(NSOutlineView view, NSObject item) {
            return false;
        }

        public boolean outlineView_shouldSelectItem(NSOutlineView view, NSObject item) {
            ProfileDescription description = this.fromChecksum(item);
            if (null == description) {
                return false;
            }
            return !((Profile)ProfilesPreferencesController.this.repository.get(description)).isBundled();
        }

        public NSView outlineView_viewForTableColumn_item(NSOutlineView outlineView, NSTableColumn tableColumn, NSObject item) {
            ProfileDescription description = this.fromChecksum(item);
            if (null == description) {
                return null;
            }
            Profile profile = (Profile)ProfilesPreferencesController.this.repository.get(description);
            if (this.controllers.containsKey(description)) {
                return this.controllers.get(description).getCellView();
            }
            ProfileTableViewController controller = new ProfileTableViewController(description, profile);
            this.controllers.put(description, controller);
            return controller.getCellView();
        }

        public CGFloat outlineView_heightOfRowByItem(NSOutlineView outlineView, NSObject item) {
            if (null == item) {
                return outlineView.rowHeight();
            }
            return new CGFloat(45.0);
        }
    }

    public final class ProfileTableViewController
    extends BundleController {
        private final ProfileDescription description;
        private final Profile profile;
        private NSTableCellView cellView;
        private NSImageView imageView;
        private NSTextField textField;
        private NSButton checkbox;
        private NSButton helpButton;

        public ProfileTableViewController(ProfileDescription description, Profile profile) {
            this.description = description;
            this.profile = profile;
            this.loadBundle();
        }

        public void setCellView(NSTableCellView cellView) {
            this.cellView = cellView;
        }

        public NSTableCellView getCellView() {
            return this.cellView;
        }

        public void setImageView(NSImageView imageView) {
            this.imageView = imageView;
            this.imageView.setImage((NSImage)IconCacheFactory.get().iconNamed(this.profile.icon(), Integer.valueOf(32)));
        }

        public void setTextField(NSTextField textField) {
            this.textField = textField;
            NSMutableAttributedString description = NSMutableAttributedString.create((String)this.profile.getDescription(), (NSDictionary)PRIMARY_FONT_ATTRIBUTES);
            description.appendAttributedString((NSAttributedString)NSMutableAttributedString.create((String)String.format("\n%s", this.profile.getName()), (NSDictionary)SECONDARY_FONT_ATTRIBUTES));
            this.textField.setAttributedStringValue((NSAttributedString)description);
        }

        public void setCheckbox(NSButton checkbox) {
            this.checkbox = checkbox;
            this.checkbox.setState(1);
            this.checkbox.setTarget(this.id());
            this.checkbox.setAction(Foundation.selector((String)"profileCheckboxClicked:"));
            this.checkbox.setEnabled(!this.profile.isBundled());
            if (BookmarkCollection.defaultCollection().stream().filter(host -> host.getProtocol().equals(this.profile)).findAny().isPresent()) {
                this.checkbox.setEnabled(false);
            }
            this.checkbox.setState(this.description.isInstalled() && this.profile.isEnabled() ? 1 : 0);
        }

        public void setHelpButton(NSButton helpButton) {
            this.helpButton = helpButton;
            this.helpButton.setTarget(this.id());
            this.helpButton.setAction(Foundation.selector((String)"helpButtonClicked:"));
        }

        public void profileCheckboxClicked(NSButton sender) {
            boolean enabled;
            boolean bl = enabled = sender.state() == 1;
            if (enabled) {
                Optional file = this.description.getFile();
                file.ifPresent(local -> ProfilesPreferencesController.this.repository.put(new LocalProfileDescription(ProfilesPreferencesController.this.protocols, ProtocolFactory.BUNDLED_PROFILE_PREDICATE, ProfilesPreferencesController.this.protocols.register(local)), this.profile));
            } else {
                Optional profile = this.description.getProfile();
                profile.ifPresent(arg_0 -> ((ProtocolFactory)ProfilesPreferencesController.this.protocols).unregister(arg_0));
            }
        }

        public void helpButtonClicked(NSButton sender) {
            BrowserLauncherFactory.get().open(ProviderHelpServiceFactory.get().help((Protocol)this.profile));
        }

        protected String getBundleName() {
            return "Profile";
        }
    }
}

