/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.ProxyController;
import ch.cyberduck.binding.ToolbarWindowController;
import ch.cyberduck.binding.WindowController;
import ch.cyberduck.binding.application.NSApplication;
import ch.cyberduck.binding.application.NSButton;
import ch.cyberduck.binding.application.NSColor;
import ch.cyberduck.binding.application.NSFont;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSMenuItem;
import ch.cyberduck.binding.application.NSOpenPanel;
import ch.cyberduck.binding.application.NSPopUpButton;
import ch.cyberduck.binding.application.NSSlider;
import ch.cyberduck.binding.application.NSStepper;
import ch.cyberduck.binding.application.NSTextField;
import ch.cyberduck.binding.application.NSTextView;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.binding.application.NSWindow;
import ch.cyberduck.binding.foundation.NSAppleScript;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSAttributedString;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSMutableAttributedString;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.binding.foundation.NSNotificationCenter;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.binding.foundation.NSRange;
import ch.cyberduck.binding.foundation.NSURL;
import ch.cyberduck.core.AbstractCollectionListener;
import ch.cyberduck.core.Acl;
import ch.cyberduck.core.BookmarkCollection;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.CollectionListener;
import ch.cyberduck.core.ConnectionTimeout;
import ch.cyberduck.core.ConnectionTimeoutFactory;
import ch.cyberduck.core.DefaultCharsetProvider;
import ch.cyberduck.core.DefaultProtocolPredicate;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.ProfileProtocolPredicate;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.editor.EditorFactory;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.formatter.SizeFormatterFactory;
import ch.cyberduck.core.googlestorage.GoogleStorageAccessControlListFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageProtocol;
import ch.cyberduck.core.kms.KMSEncryptionFeature;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.ApplicationFinder;
import ch.cyberduck.core.local.ApplicationFinderFactory;
import ch.cyberduck.core.local.RevealServiceFactory;
import ch.cyberduck.core.preferences.LogDirectoryFinderFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3EncryptionFeature;
import ch.cyberduck.core.s3.S3Protocol;
import ch.cyberduck.core.threading.DefaultMainAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.core.threading.WindowMainAction;
import ch.cyberduck.core.transfer.TransferAction;
import ch.cyberduck.core.urlhandler.SchemeHandlerFactory;
import ch.cyberduck.ui.cocoa.controller.BrowserController;
import ch.cyberduck.ui.cocoa.controller.MainController;
import ch.cyberduck.ui.cocoa.controller.ProfilesPreferencesController;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSSize;
import org.rococoa.cocoa.foundation.NSUInteger;

public class PreferencesController
extends ToolbarWindowController {
    private static final Logger log = LogManager.getLogger(PreferencesController.class);
    private final NSNotificationCenter notificationCenter = NSNotificationCenter.defaultCenter();
    private final Preferences preferences = PreferencesFactory.get();
    private final ConnectionTimeout connectionTimeoutPreferences = ConnectionTimeoutFactory.get();
    private final ProfilesPreferencesController profilesPanelController;
    protected NSView panelGeneral;
    protected NSView panelEditor;
    protected NSView panelBrowser;
    protected NSView panelTransfer;
    protected NSView panelFTP;
    protected NSView panelSFTP;
    protected NSView panelS3;
    protected NSView panelGoogleStorage;
    protected NSView panelBandwidth;
    protected NSView panelAdvanced;
    protected NSView panelUpdate;
    protected NSView panelLanguage;
    protected NSView panelCryptomator;
    private NSPopUpButton editorCombobox;
    private NSOpenPanel editorPathPanel;
    private final ProxyController editorPathPanelDelegate = new EditorOpenPanelDelegate();
    private NSButton defaultEditorCheckbox;
    private NSPopUpButton bookmarkSizePopup;
    private NSButton openUntitledBrowserCheckbox;
    private NSButton browserSerializeCheckbox;
    private NSPopUpButton defaultBookmarkCombobox;
    private final CollectionListener<Host> bookmarkCollectionListener = new AbstractCollectionListener<Host>(){

        public void collectionItemAdded(final Host bookmark) {
            PreferencesController.this.invoke((MainAction)new WindowMainAction((WindowController)PreferencesController.this){

                public void run() {
                    PreferencesController.this.defaultBookmarkCombobox.addItemWithTitle(BookmarkNameProvider.toString((Host)bookmark));
                    PreferencesController.this.defaultBookmarkCombobox.lastItem().setImage((NSImage)IconCacheFactory.get().iconNamed("cyberduck-document.icns", Integer.valueOf(16)));
                    PreferencesController.this.defaultBookmarkCombobox.lastItem().setRepresentedObject(bookmark.getUuid());
                }
            });
        }

        public void collectionItemRemoved(final Host bookmark) {
            PreferencesController.this.invoke((MainAction)new WindowMainAction((WindowController)PreferencesController.this){

                public void run() {
                    NSInteger i;
                    String selected = PreferencesController.this.defaultBookmarkCombobox.selectedItem().representedObject();
                    if (StringUtils.isNotEmpty((CharSequence)selected) && selected.equals(bookmark.getUuid())) {
                        PreferencesController.this.preferences.deleteProperty("browser.open.bookmark.default");
                    }
                    if ((i = PreferencesController.this.defaultBookmarkCombobox.menu().indexOfItemWithRepresentedObject(bookmark.getUuid())).intValue() == -1) {
                        return;
                    }
                    PreferencesController.this.defaultBookmarkCombobox.removeItemAtIndex(i);
                }
            });
        }
    };
    private NSPopUpButton encodingCombobox;
    private NSButton connectionRetryCheckbox;
    private NSTextField connectionTimeoutField;
    private NSStepper connectionTimeoutStepper;
    private NSTextField connectionRetryNumberField;
    private NSStepper connectionRetryNumberStepper;
    private NSTextField connectionRetryDelayField;
    private NSStepper connectionRetryDelayStepper;
    private NSPopUpButton chmodUploadTypePopup;
    private NSPopUpButton chmodDownloadTypePopup;
    private NSButton chmodUploadCheckbox;
    private NSButton chmodUploadDefaultCheckbox;
    private NSButton chmodUploadCustomCheckbox;
    private NSButton chmodDownloadCheckbox;
    private NSButton chmodDownloadDefaultCheckbox;
    private NSButton chmodDownloadCustomCheckbox;
    private NSButton downerr;
    private NSButton downerw;
    private NSButton downerx;
    private NSButton dgroupr;
    private NSButton dgroupw;
    private NSButton dgroupx;
    private NSButton dotherr;
    private NSButton dotherw;
    private NSButton dotherx;
    private NSButton uownerr;
    private NSButton uownerw;
    private NSButton uownerx;
    private NSButton ugroupr;
    private NSButton ugroupw;
    private NSButton ugroupx;
    private NSButton uotherr;
    private NSButton uotherw;
    private NSButton uotherx;
    private NSButton preserveModificationDownloadCheckbox;
    private NSButton preserveModificationUploadCheckbox;
    private NSButton checksumDownloadCheckbox;
    private NSButton checksumUploadCheckbox;
    private NSButton horizontalLinesCheckbox;
    private NSButton verticalLinesCheckbox;
    private NSButton alternatingRowBackgroundCheckbox;
    private NSButton infoWindowAsInspectorCheckbox;
    private NSPopUpButton downloadPathPopup;
    private final Local DEFAULT_DOWNLOAD_FOLDER = LocalFactory.get((String)this.preferences.getProperty("queue.download.folder"));
    private NSOpenPanel downloadPathPanel;
    private NSPopUpButton transferPopup;
    private NSButton downloadSkipButton;
    private NSButton downloadSkipRegexDefaultButton;
    private NSTextView downloadSkipRegexField;
    private NSButton uploadSkipButton;
    private NSButton uploadSkipRegexDefaultButton;
    private NSTextView uploadSkipRegexField;
    protected static final NSDictionary RED_FONT = NSDictionary.dictionaryWithObjectsForKeys((NSArray)NSArray.arrayWithObjects((NSObject[])new NSObject[]{NSColor.redColor()}), (NSArray)NSArray.arrayWithObjects((String[])new String[]{"NSColor"}));
    private NSButton keychainCheckbox;
    private NSButton doubleClickCheckbox;
    private NSButton returnKeyCheckbox;
    private NSButton autoExpandCheckbox;
    private NSButton autoExpandDelayCheckbox;
    private NSSlider autoExpandDelaySlider;
    private NSButton showHiddenCheckbox;
    private NSButton bringQueueToFrontCheckbox;
    private NSButton bringQueueToBackCheckbox;
    private NSButton removeFromQueueCheckbox;
    NSButton segmentedDownloadCheckbox;
    private NSButton openAfterDownloadCheckbox;
    private NSPopUpButton duplicateDownloadCombobox;
    private NSButton duplicateDownloadOverwriteButton;
    private NSPopUpButton duplicateUploadCombobox;
    private NSButton duplicateUploadOverwriteButton;
    private NSButton uploadTemporaryFilenameButton;
    private NSPopUpButton protocolCombobox;
    private NSButton confirmDisconnectCheckbox;
    private NSPopUpButton defaultFTPHandlerCombobox;
    private NSPopUpButton defaultSFTPHandlerCombobox;
    private NSPopUpButton defaultDownloadThrottleCombobox;
    private NSPopUpButton defaultUploadThrottleCombobox;
    private NSButton updateCheckbox;
    private NSButton updateCheckButton;
    private NSPopUpButton updateFeedPopup;
    private NSPopUpButton defaultBucketLocation;
    private NSPopUpButton defaultStorageClassPopup;
    private NSPopUpButton defaultEncryptionPopup;
    private NSPopUpButton cannedAclPopup;
    private NSPopUpButton defaultBucketLocationGoogleStorage;
    private NSPopUpButton defaultStorageClassPopupGoogleStorage;
    private NSPopUpButton cannedAclPopupGoogleStorage;
    private NSPopUpButton languagePopup;
    private NSButton useProxiesButton;
    private NSButton configureProxiesButton;
    private NSButton logCheckbox;
    private NSButton logShowButton;
    private NSButton cryptomatorCheckbox;

    public PreferencesController() {
        this.profilesPanelController = new ProfilesPreferencesController();
    }

    protected String getBundleName() {
        return "Preferences";
    }

    public void setPanelUpdate(NSView v) {
        this.panelUpdate = v;
    }

    public void setPanelAdvanced(NSView v) {
        this.panelAdvanced = v;
    }

    public void setPanelBandwidth(NSView v) {
        this.panelBandwidth = v;
    }

    public void setPanelSFTP(NSView v) {
        this.panelSFTP = v;
    }

    public void setPanelFTP(NSView v) {
        this.panelFTP = v;
    }

    public void setPanelS3(NSView v) {
        this.panelS3 = v;
    }

    public void setPanelGoogleStorage(NSView v) {
        this.panelGoogleStorage = v;
    }

    public void setPanelTransfer(NSView v) {
        this.panelTransfer = v;
    }

    public void setPanelBrowser(NSView v) {
        this.panelBrowser = v;
    }

    public void setPanelGeneral(NSView v) {
        this.panelGeneral = v;
    }

    public void setPanelEditor(NSView v) {
        this.panelEditor = v;
    }

    public void setPanelLanguage(NSView v) {
        this.panelLanguage = v;
    }

    public void setPanelCryptomator(NSView v) {
        this.panelCryptomator = v;
    }

    protected Map<ToolbarWindowController.Label, NSView> getPanels() {
        LinkedHashMap<ToolbarWindowController.Label, NSView> views = new LinkedHashMap<ToolbarWindowController.Label, NSView>();
        this.addPanel(views, new PreferencesLabel(PreferencesToolbarItem.general), this.panelGeneral);
        this.addPanel(views, new PreferencesLabel(PreferencesToolbarItem.browser), this.panelBrowser);
        this.addPanel(views, new PreferencesLabel(PreferencesToolbarItem.queue), this.panelTransfer);
        this.addPanel(views, new PreferencesLabel(PreferencesToolbarItem.editor), this.panelEditor);
        if (this.preferences.getBoolean(String.format("preferences.%s.enable", PreferencesToolbarItem.profiles.name()))) {
            this.profilesPanelController.loadBundle();
            this.addPanel(views, new PreferencesLabel(PreferencesToolbarItem.profiles), this.profilesPanelController.getPanel());
        }
        if (null != ProtocolFactory.get().forName(Protocol.Type.ftp.name())) {
            this.addPanel(views, new PreferencesLabel(PreferencesToolbarItem.ftp), this.panelFTP);
        }
        if (null != ProtocolFactory.get().forName(Protocol.Type.sftp.name())) {
            this.addPanel(views, new PreferencesLabel(PreferencesToolbarItem.sftp), this.panelSFTP);
        }
        if (null != ProtocolFactory.get().forName(Protocol.Type.s3.name())) {
            this.addPanel(views, new PreferencesLabel(PreferencesToolbarItem.s3), this.panelS3);
        }
        if (null != ProtocolFactory.get().forName(Protocol.Type.googlestorage.name())) {
            this.addPanel(views, new PreferencesLabel(PreferencesToolbarItem.googlestorage), this.panelGoogleStorage);
        }
        this.addPanel(views, new PreferencesLabel(PreferencesToolbarItem.bandwidth), this.panelBandwidth);
        this.addPanel(views, new PreferencesLabel(PreferencesToolbarItem.connection), this.panelAdvanced);
        if (this.preferences.getBoolean("cryptomator.enable")) {
            this.addPanel(views, new PreferencesLabel(PreferencesToolbarItem.cryptomator), this.panelCryptomator);
        }
        if (null != this.preferences.getProperty("SUExpectsDSASignature")) {
            this.addPanel(views, new PreferencesLabel(PreferencesToolbarItem.update), this.panelUpdate);
        }
        this.addPanel(views, new PreferencesLabel(PreferencesToolbarItem.language), this.panelLanguage);
        return views;
    }

    protected void addPanel(Map<ToolbarWindowController.Label, NSView> views, ToolbarWindowController.Label label, NSView panel) {
        if (this.preferences.getBoolean(String.format("preferences.%s.enable", label.identifier))) {
            views.put(label, panel);
        }
    }

    protected void initializePanel(String identifier) {
        PreferencesToolbarItem item;
        try {
            item = PreferencesToolbarItem.valueOf(identifier);
        }
        catch (IllegalArgumentException e) {
            item = PreferencesToolbarItem.general;
        }
        switch (item) {
            case general: {
                break;
            }
            case queue: {
                this.chmodDownloadTypePopupChanged(this.chmodDownloadTypePopup);
                this.chmodUploadTypePopupChanged(this.chmodUploadTypePopup);
                break;
            }
            case editor: {
                this.updateEditorCombobox();
                break;
            }
            case ftp: {
                this.configureDefaultProtocolHandlerCombobox(this.defaultFTPHandlerCombobox, Scheme.ftp);
                break;
            }
            case sftp: {
                this.configureDefaultProtocolHandlerCombobox(this.defaultSFTPHandlerCombobox, Scheme.sftp);
                break;
            }
            case profiles: {
                this.profilesPanelController.load();
            }
        }
    }

    public void invalidate() {
        BookmarkCollection.defaultCollection().removeListener(this.bookmarkCollectionListener);
        super.invalidate();
    }

    public void setWindow(NSWindow window) {
        window.setExcludedFromWindowsMenu(true);
        window.setFrameAutosaveName("Preferences");
        if (window.respondsToSelector(Foundation.selector((String)"setToolbarStyle:"))) {
            window.setToolbarStyle(2);
        }
        window.setContentMinSize(new NSSize(600.0, 200.0));
        super.setWindow(window);
    }

    public void awakeFromNib() {
        this.window.center();
        super.awakeFromNib();
    }

    public void setEditorCombobox(NSPopUpButton b) {
        this.editorCombobox = b;
        this.editorCombobox.setAutoenablesItems(false);
    }

    private void updateEditorCombobox() {
        this.editorCombobox.removeAllItems();
        for (Application editor : EditorFactory.instance().getEditors()) {
            this.editorCombobox.addItemWithTitle(editor.getName());
            this.editorCombobox.lastItem().setRepresentedObject(editor.getIdentifier());
            boolean enabled = ApplicationFinderFactory.get().isInstalled(editor);
            this.editorCombobox.lastItem().setEnabled(enabled);
            if (enabled) {
                this.editorCombobox.lastItem().setImage((NSImage)IconCacheFactory.get().applicationIcon(editor, Integer.valueOf(16)));
            }
            if (!editor.equals((Object)EditorFactory.getDefaultEditor())) continue;
            this.editorCombobox.selectItem(this.editorCombobox.lastItem());
        }
        this.editorCombobox.setTarget(this.id());
        this.editorCombobox.setAction(Foundation.selector((String)"editorComboboxClicked:"));
        this.editorCombobox.menu().addItem(NSMenuItem.separatorItem());
        this.editorCombobox.addItemWithTitle(String.format("%s\u2026", LocaleFactory.localizedString((String)"Choose")));
    }

    public void editorComboboxClicked(NSPopUpButton sender) {
        if (null == sender.selectedItem().representedObject()) {
            this.editorPathPanel = NSOpenPanel.openPanel();
            this.editorPathPanel.setDelegate(this.editorPathPanelDelegate.id());
            this.editorPathPanel.setAllowsMultipleSelection(false);
            this.editorPathPanel.setCanCreateDirectories(false);
            this.editorPathPanel.beginSheetForDirectory("/Applications", null, this.window, this.id(), Foundation.selector((String)"editorPathPanelDidEnd:returnCode:contextInfo:"), null);
        } else {
            this.preferences.setProperty("editor.bundleIdentifier", sender.selectedItem().representedObject());
            for (BrowserController controller : MainController.getBrowsers()) {
                controller.validateToolbar();
            }
        }
    }

    public void editorPathPanelDidEnd_returnCode_contextInfo(NSOpenPanel sheet, int returncode, ID contextInfo) {
        NSObject selected;
        if (returncode == 1 && (selected = sheet.URLs().lastObject()) != null) {
            Application application;
            String path = LocalFactory.get((String)((NSURL)Rococoa.cast((ObjCObject)selected, NSURL.class)).path()).getAbsolute();
            ApplicationFinder finder = ApplicationFinderFactory.get();
            if (finder.isInstalled(application = finder.getDescription(path))) {
                this.preferences.setProperty("editor.bundleIdentifier", application.getIdentifier());
                for (BrowserController controller : MainController.getBrowsers()) {
                    controller.validateToolbar();
                }
            } else {
                log.error(String.format("Loading bundle %s failed", path));
            }
        }
        this.updateEditorCombobox();
    }

    public void setDefaultEditorCheckbox(NSButton b) {
        this.defaultEditorCheckbox = b;
        this.defaultEditorCheckbox.setTarget(this.id());
        this.defaultEditorCheckbox.setAction(Foundation.selector((String)"defaultEditorCheckboxClicked:"));
        this.defaultEditorCheckbox.setState(this.preferences.getBoolean("editor.alwaysUseDefault") ? 1 : 0);
    }

    public void defaultEditorCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("editor.alwaysUseDefault", enabled);
    }

    public void setBookmarkSizePopup(NSPopUpButton b) {
        this.bookmarkSizePopup = b;
        this.bookmarkSizePopup.setTarget(this.id());
        this.bookmarkSizePopup.setAction(Foundation.selector((String)"bookmarkSizePopupClicked:"));
        int size = this.preferences.getInteger("bookmark.icon.size");
        for (int i = 0; i < this.bookmarkSizePopup.numberOfItems().intValue(); ++i) {
            this.bookmarkSizePopup.itemAtIndex(new NSInteger((long)i)).setState(0);
        }
        if (16 == size) {
            this.bookmarkSizePopup.selectItemAtIndex(new NSInteger(0L));
        }
        if (32 == size) {
            this.bookmarkSizePopup.selectItemAtIndex(new NSInteger(1L));
        }
        if (64 == size) {
            this.bookmarkSizePopup.selectItemAtIndex(new NSInteger(2L));
        }
    }

    public void bookmarkSizePopupClicked(NSPopUpButton sender) {
        if (sender.indexOfSelectedItem().intValue() == 0) {
            this.preferences.setProperty("bookmark.icon.size", 16);
            this.preferences.setProperty("bookmark.menu.icon.size", 16);
        }
        if (sender.indexOfSelectedItem().intValue() == 1) {
            this.preferences.setProperty("bookmark.icon.size", 32);
            this.preferences.setProperty("bookmark.menu.icon.size", 32);
        }
        if (sender.indexOfSelectedItem().intValue() == 2) {
            this.preferences.setProperty("bookmark.icon.size", 64);
            this.preferences.setProperty("bookmark.menu.icon.size", 64);
        }
        BrowserController.updateBookmarkTableRowHeight();
    }

    public void setOpenUntitledBrowserCheckbox(NSButton b) {
        this.openUntitledBrowserCheckbox = b;
        this.openUntitledBrowserCheckbox.setTarget(this.id());
        this.openUntitledBrowserCheckbox.setAction(Foundation.selector((String)"openUntitledBrowserCheckboxClicked:"));
        this.openUntitledBrowserCheckbox.setState(this.preferences.getBoolean("browser.open.untitled") ? 1 : 0);
    }

    public void openUntitledBrowserCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("browser.open.untitled", enabled);
    }

    public void setBrowserSerializeCheckbox(NSButton b) {
        this.browserSerializeCheckbox = b;
        this.browserSerializeCheckbox.setTarget(this.id());
        this.browserSerializeCheckbox.setAction(Foundation.selector((String)"browserSerializeCheckboxClicked:"));
        this.browserSerializeCheckbox.setState(this.preferences.getBoolean("browser.serialize") ? 1 : 0);
    }

    public void browserSerializeCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("browser.serialize", enabled);
    }

    public void setDefaultBookmarkCombobox(NSPopUpButton b) {
        this.defaultBookmarkCombobox = b;
        this.defaultBookmarkCombobox.setToolTip(LocaleFactory.localizedString((String)"Bookmarks", (String)"Preferences"));
        this.defaultBookmarkCombobox.removeAllItems();
        this.defaultBookmarkCombobox.addItemWithTitle(LocaleFactory.localizedString((String)"None"));
        this.defaultBookmarkCombobox.selectItem(this.defaultBookmarkCombobox.lastItem());
        this.defaultBookmarkCombobox.menu().addItem(NSMenuItem.separatorItem());
        for (Host bookmark : BookmarkCollection.defaultCollection()) {
            this.defaultBookmarkCombobox.addItemWithTitle(BookmarkNameProvider.toString((Host)bookmark));
            this.defaultBookmarkCombobox.lastItem().setImage((NSImage)IconCacheFactory.get().iconNamed(bookmark.getProtocol().icon(), Integer.valueOf(16)));
            this.defaultBookmarkCombobox.lastItem().setRepresentedObject(bookmark.getUuid());
            if (!bookmark.getUuid().equals(this.preferences.getProperty("browser.open.bookmark.default"))) continue;
            this.defaultBookmarkCombobox.selectItem(this.defaultBookmarkCombobox.lastItem());
        }
        BookmarkCollection.defaultCollection().addListener(this.bookmarkCollectionListener);
        this.defaultBookmarkCombobox.setTarget(this.id());
        Selector action = Foundation.selector((String)"defaultBookmarkComboboxClicked:");
        this.defaultBookmarkCombobox.setAction(action);
    }

    public void defaultBookmarkComboboxClicked(NSPopUpButton sender) {
        String selected = sender.selectedItem().representedObject();
        if (null == selected) {
            this.preferences.deleteProperty("browser.open.bookmark.default");
        }
        this.preferences.setProperty("browser.open.bookmark.default", selected);
    }

    public void setEncodingCombobox(NSPopUpButton b) {
        this.encodingCombobox = b;
        this.encodingCombobox.setTarget(this.id());
        this.encodingCombobox.setAction(Foundation.selector((String)"encodingComboboxClicked:"));
        this.encodingCombobox.removeAllItems();
        this.encodingCombobox.addItemsWithTitles(NSArray.arrayWithObjects((String[])new DefaultCharsetProvider().availableCharsets()));
        this.encodingCombobox.selectItemWithTitle(this.preferences.getProperty("browser.charset.encoding"));
    }

    public void encodingComboboxClicked(NSPopUpButton sender) {
        this.preferences.setProperty("browser.charset.encoding", sender.titleOfSelectedItem());
    }

    public void setConnectionRetryCheckbox(NSButton b) {
        this.connectionRetryCheckbox = b;
        this.connectionRetryCheckbox.setTarget(this.id());
        this.connectionRetryCheckbox.setAction(Foundation.selector((String)"connectionRetryCheckboxClicked:"));
        this.connectionRetryCheckbox.setState(this.preferences.getInteger("connection.retry") > 0 ? 1 : 0);
    }

    public void connectionRetryCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("connection.retry", enabled ? 1 : 0);
        this.connectionRetryNumberStepper.setEnabled(enabled);
        this.connectionRetryNumberField.setIntValue(enabled ? 1 : 0);
        this.connectionRetryDelayStepper.setEnabled(enabled);
    }

    public void setConnectionTimeoutField(NSTextField b) {
        this.connectionTimeoutField = b;
        this.connectionTimeoutField.setIntValue(this.connectionTimeoutPreferences.getTimeout());
    }

    public void setConnectionTimeoutStepper(NSStepper b) {
        this.connectionTimeoutStepper = b;
        this.connectionTimeoutStepper.setTarget(this.id());
        this.connectionTimeoutStepper.setAction(Foundation.selector((String)"connectionTimeoutStepperClicked:"));
        this.connectionTimeoutStepper.setIntValue(this.connectionTimeoutPreferences.getTimeout());
    }

    public void connectionTimeoutStepperClicked(NSStepper sender) {
        this.connectionTimeoutPreferences.setTimeout(sender.intValue());
        this.connectionTimeoutField.setIntValue(this.connectionTimeoutPreferences.getTimeout());
    }

    public void setConnectionRetryNumberField(NSTextField b) {
        this.connectionRetryNumberField = b;
        this.connectionRetryNumberField.setIntValue(this.preferences.getInteger("connection.retry"));
    }

    public void setConnectionRetryNumberStepper(NSStepper b) {
        this.connectionRetryNumberStepper = b;
        this.connectionRetryNumberStepper.setTarget(this.id());
        this.connectionRetryNumberStepper.setAction(Foundation.selector((String)"connectionRetryNumberStepperClicked:"));
        this.connectionRetryNumberStepper.setIntValue(this.preferences.getInteger("connection.retry"));
        this.connectionRetryNumberStepper.setMinValue(1.0);
        this.connectionRetryNumberStepper.setMaxValue((double)this.preferences.getInteger("connection.retry.max"));
    }

    public void connectionRetryNumberStepperClicked(NSStepper sender) {
        this.preferences.setProperty("connection.retry", sender.intValue());
        this.connectionRetryNumberField.setIntValue(sender.intValue());
    }

    public void setConnectionRetryDelayField(NSTextField b) {
        this.connectionRetryDelayField = b;
        this.connectionRetryDelayField.setIntValue(this.preferences.getInteger("connection.retry.delay"));
    }

    public void setConnectionRetryDelayStepper(NSStepper b) {
        this.connectionRetryDelayStepper = b;
        this.connectionRetryDelayStepper.setTarget(this.id());
        this.connectionRetryDelayStepper.setAction(Foundation.selector((String)"connectionRetryDelayStepperClicked:"));
        this.connectionRetryDelayStepper.setIntValue(this.preferences.getInteger("connection.retry.delay"));
    }

    public void connectionRetryDelayStepperClicked(NSStepper sender) {
        this.preferences.setProperty("connection.retry.delay", sender.intValue());
        this.connectionRetryDelayField.setIntValue(sender.intValue());
    }

    public void setChmodUploadTypePopup(NSPopUpButton b) {
        this.chmodUploadTypePopup = b;
        this.chmodUploadTypePopup.selectItemAtIndex(new NSInteger(0L));
        this.chmodUploadTypePopup.setTarget(this.id());
        this.chmodUploadTypePopup.setAction(Foundation.selector((String)"chmodUploadTypePopupChanged:"));
    }

    public void chmodUploadTypePopupChanged(NSPopUpButton sender) {
        Permission p = null;
        if (sender.selectedItem().tag() == 0) {
            p = new Permission(this.preferences.getInteger("queue.upload.permissions.file.default"));
        }
        if (sender.selectedItem().tag() == 1) {
            p = new Permission(this.preferences.getInteger("queue.upload.permissions.folder.default"));
        }
        if (null == p) {
            log.error("No selected item for:" + sender);
            return;
        }
        Permission.Action ownerPerm = p.getUser();
        Permission.Action groupPerm = p.getGroup();
        Permission.Action otherPerm = p.getOther();
        this.uownerr.setState(ownerPerm.implies(Permission.Action.read) ? 1 : 0);
        this.uownerw.setState(ownerPerm.implies(Permission.Action.write) ? 1 : 0);
        this.uownerx.setState(ownerPerm.implies(Permission.Action.execute) ? 1 : 0);
        this.ugroupr.setState(groupPerm.implies(Permission.Action.read) ? 1 : 0);
        this.ugroupw.setState(groupPerm.implies(Permission.Action.write) ? 1 : 0);
        this.ugroupx.setState(groupPerm.implies(Permission.Action.execute) ? 1 : 0);
        this.uotherr.setState(otherPerm.implies(Permission.Action.read) ? 1 : 0);
        this.uotherw.setState(otherPerm.implies(Permission.Action.write) ? 1 : 0);
        this.uotherx.setState(otherPerm.implies(Permission.Action.execute) ? 1 : 0);
    }

    public void setChmodDownloadTypePopup(NSPopUpButton b) {
        this.chmodDownloadTypePopup = b;
        this.chmodDownloadTypePopup.selectItemAtIndex(new NSInteger(0L));
        this.chmodDownloadTypePopup.setTarget(this.id());
        this.chmodDownloadTypePopup.setAction(Foundation.selector((String)"chmodDownloadTypePopupChanged:"));
    }

    public void chmodDownloadTypePopupChanged(NSPopUpButton sender) {
        Permission p = null;
        if (sender.selectedItem().tag() == 0) {
            p = new Permission(this.preferences.getInteger("queue.download.permissions.file.default"));
        }
        if (sender.selectedItem().tag() == 1) {
            p = new Permission(this.preferences.getInteger("queue.download.permissions.folder.default"));
        }
        if (null == p) {
            log.error("No selected item for:" + sender);
            return;
        }
        Permission.Action ownerPerm = p.getUser();
        Permission.Action groupPerm = p.getGroup();
        Permission.Action otherPerm = p.getOther();
        this.downerr.setState(ownerPerm.implies(Permission.Action.read) ? 1 : 0);
        this.downerw.setState(ownerPerm.implies(Permission.Action.write) ? 1 : 0);
        this.downerx.setState(ownerPerm.implies(Permission.Action.execute) ? 1 : 0);
        this.dgroupr.setState(groupPerm.implies(Permission.Action.read) ? 1 : 0);
        this.dgroupw.setState(groupPerm.implies(Permission.Action.write) ? 1 : 0);
        this.dgroupx.setState(groupPerm.implies(Permission.Action.execute) ? 1 : 0);
        this.dotherr.setState(otherPerm.implies(Permission.Action.read) ? 1 : 0);
        this.dotherw.setState(otherPerm.implies(Permission.Action.write) ? 1 : 0);
        this.dotherx.setState(otherPerm.implies(Permission.Action.execute) ? 1 : 0);
    }

    public void setChmodUploadCheckbox(NSButton b) {
        this.chmodUploadCheckbox = b;
        this.chmodUploadCheckbox.setTarget(this.id());
        this.chmodUploadCheckbox.setAction(Foundation.selector((String)"chmodUploadCheckboxClicked:"));
        this.chmodUploadCheckbox.setState(this.preferences.getBoolean("queue.upload.permissions.change") ? 1 : 0);
    }

    public void chmodUploadCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("queue.upload.permissions.change", enabled);
        this.preferences.setProperty("touch.permissions.change", enabled);
        this.chmodUploadDefaultCheckbox.setEnabled(enabled);
        this.chmodUploadCustomCheckbox.setEnabled(enabled);
        boolean chmodUploadDefaultChecked = this.chmodUploadDefaultCheckbox.state() == 1;
        this.uownerr.setEnabled(enabled && chmodUploadDefaultChecked);
        this.uownerw.setEnabled(enabled && chmodUploadDefaultChecked);
        this.uownerx.setEnabled(enabled && chmodUploadDefaultChecked);
        this.ugroupr.setEnabled(enabled && chmodUploadDefaultChecked);
        this.ugroupw.setEnabled(enabled && chmodUploadDefaultChecked);
        this.ugroupx.setEnabled(enabled && chmodUploadDefaultChecked);
        this.uotherr.setEnabled(enabled && chmodUploadDefaultChecked);
        this.uotherw.setEnabled(enabled && chmodUploadDefaultChecked);
        this.uotherx.setEnabled(enabled && chmodUploadDefaultChecked);
    }

    public void setChmodUploadDefaultCheckbox(NSButton b) {
        this.chmodUploadDefaultCheckbox = b;
        this.chmodUploadDefaultCheckbox.setTarget(this.id());
        this.chmodUploadDefaultCheckbox.setAction(Foundation.selector((String)"chmodUploadDefaultCheckboxClicked:"));
        this.chmodUploadDefaultCheckbox.setState(this.preferences.getBoolean("queue.upload.permissions.default") ? 1 : 0);
        this.chmodUploadDefaultCheckbox.setEnabled(this.preferences.getBoolean("queue.upload.permissions.change"));
    }

    public void chmodUploadDefaultCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("queue.upload.permissions.default", enabled);
        this.uownerr.setEnabled(enabled);
        this.uownerw.setEnabled(enabled);
        this.uownerx.setEnabled(enabled);
        this.ugroupr.setEnabled(enabled);
        this.ugroupw.setEnabled(enabled);
        this.ugroupx.setEnabled(enabled);
        this.uotherr.setEnabled(enabled);
        this.uotherw.setEnabled(enabled);
        this.uotherx.setEnabled(enabled);
        this.chmodUploadCustomCheckbox.setState(!enabled ? 1 : 0);
    }

    public void setChmodUploadCustomCheckbox(NSButton b) {
        this.chmodUploadCustomCheckbox = b;
        this.chmodUploadCustomCheckbox.setTarget(this.id());
        this.chmodUploadCustomCheckbox.setAction(Foundation.selector((String)"chmodUploadCustomCheckboxClicked:"));
        this.chmodUploadCustomCheckbox.setState(!this.preferences.getBoolean("queue.upload.permissions.default") ? 1 : 0);
        this.chmodUploadCustomCheckbox.setEnabled(this.preferences.getBoolean("queue.upload.permissions.change"));
    }

    public void chmodUploadCustomCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("queue.upload.permissions.default", !enabled);
        this.uownerr.setEnabled(!enabled);
        this.uownerw.setEnabled(!enabled);
        this.uownerx.setEnabled(!enabled);
        this.ugroupr.setEnabled(!enabled);
        this.ugroupw.setEnabled(!enabled);
        this.ugroupx.setEnabled(!enabled);
        this.uotherr.setEnabled(!enabled);
        this.uotherw.setEnabled(!enabled);
        this.uotherx.setEnabled(!enabled);
        this.chmodUploadDefaultCheckbox.setState(!enabled ? 1 : 0);
    }

    public void setChmodDownloadCheckbox(NSButton b) {
        this.chmodDownloadCheckbox = b;
        this.chmodDownloadCheckbox.setTarget(this.id());
        this.chmodDownloadCheckbox.setAction(Foundation.selector((String)"chmodDownloadCheckboxClicked:"));
        this.chmodDownloadCheckbox.setState(this.preferences.getBoolean("queue.download.permissions.change") ? 1 : 0);
    }

    public void chmodDownloadCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("queue.download.permissions.change", enabled);
        this.chmodDownloadDefaultCheckbox.setEnabled(enabled);
        this.chmodDownloadCustomCheckbox.setEnabled(enabled);
        boolean chmodDownloadDefaultChecked = this.chmodDownloadDefaultCheckbox.state() == 1;
        this.downerr.setEnabled(enabled && chmodDownloadDefaultChecked);
        this.downerw.setEnabled(enabled && chmodDownloadDefaultChecked);
        this.downerx.setEnabled(enabled && chmodDownloadDefaultChecked);
        this.dgroupr.setEnabled(enabled && chmodDownloadDefaultChecked);
        this.dgroupw.setEnabled(enabled && chmodDownloadDefaultChecked);
        this.dgroupx.setEnabled(enabled && chmodDownloadDefaultChecked);
        this.dotherr.setEnabled(enabled && chmodDownloadDefaultChecked);
        this.dotherw.setEnabled(enabled && chmodDownloadDefaultChecked);
        this.dotherx.setEnabled(enabled && chmodDownloadDefaultChecked);
    }

    public void setChmodDownloadDefaultCheckbox(NSButton b) {
        this.chmodDownloadDefaultCheckbox = b;
        this.chmodDownloadDefaultCheckbox.setTarget(this.id());
        this.chmodDownloadDefaultCheckbox.setAction(Foundation.selector((String)"chmodDownloadDefaultCheckboxClicked:"));
        this.chmodDownloadDefaultCheckbox.setState(this.preferences.getBoolean("queue.download.permissions.default") ? 1 : 0);
        this.chmodDownloadDefaultCheckbox.setEnabled(this.preferences.getBoolean("queue.download.permissions.change"));
    }

    public void chmodDownloadDefaultCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("queue.download.permissions.default", enabled);
        this.downerr.setEnabled(enabled);
        this.downerw.setEnabled(enabled);
        this.downerx.setEnabled(enabled);
        this.dgroupr.setEnabled(enabled);
        this.dgroupw.setEnabled(enabled);
        this.dgroupx.setEnabled(enabled);
        this.dotherr.setEnabled(enabled);
        this.dotherw.setEnabled(enabled);
        this.dotherx.setEnabled(enabled);
        this.chmodDownloadCustomCheckbox.setState(!enabled ? 1 : 0);
    }

    public void setChmodDownloadCustomCheckbox(NSButton b) {
        this.chmodDownloadCustomCheckbox = b;
        this.chmodDownloadCustomCheckbox.setTarget(this.id());
        this.chmodDownloadCustomCheckbox.setAction(Foundation.selector((String)"chmodDownloadCustomCheckboxClicked:"));
        this.chmodDownloadCustomCheckbox.setState(!this.preferences.getBoolean("queue.download.permissions.default") ? 1 : 0);
        this.chmodDownloadCustomCheckbox.setEnabled(this.preferences.getBoolean("queue.download.permissions.change"));
    }

    public void chmodDownloadCustomCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("queue.download.permissions.default", !enabled);
        this.downerr.setEnabled(!enabled);
        this.downerw.setEnabled(!enabled);
        this.downerx.setEnabled(!enabled);
        this.dgroupr.setEnabled(!enabled);
        this.dgroupw.setEnabled(!enabled);
        this.dgroupx.setEnabled(!enabled);
        this.dotherr.setEnabled(!enabled);
        this.dotherw.setEnabled(!enabled);
        this.dotherx.setEnabled(!enabled);
        this.chmodDownloadDefaultCheckbox.setState(!enabled ? 1 : 0);
    }

    public void setDownerr(NSButton downerr) {
        this.downerr = downerr;
        this.downerr.setEnabled(this.preferences.getBoolean("queue.download.permissions.change") && this.preferences.getBoolean("queue.download.permissions.default"));
        this.downerr.setTarget(this.id());
        this.downerr.setAction(Foundation.selector((String)"defaultPermissionsDownloadChanged:"));
    }

    public void setDownerw(NSButton downerw) {
        this.downerw = downerw;
        this.downerw.setEnabled(this.preferences.getBoolean("queue.download.permissions.change") && this.preferences.getBoolean("queue.download.permissions.default"));
        this.downerw.setTarget(this.id());
        this.downerw.setAction(Foundation.selector((String)"defaultPermissionsDownloadChanged:"));
    }

    public void setDownerx(NSButton downerx) {
        this.downerx = downerx;
        this.downerx.setEnabled(this.preferences.getBoolean("queue.download.permissions.change") && this.preferences.getBoolean("queue.download.permissions.default"));
        this.downerx.setTarget(this.id());
        this.downerx.setAction(Foundation.selector((String)"defaultPermissionsDownloadChanged:"));
    }

    public void setDgroupr(NSButton dgroupr) {
        this.dgroupr = dgroupr;
        this.dgroupr.setEnabled(this.preferences.getBoolean("queue.download.permissions.change") && this.preferences.getBoolean("queue.download.permissions.default"));
        this.dgroupr.setTarget(this.id());
        this.dgroupr.setAction(Foundation.selector((String)"defaultPermissionsDownloadChanged:"));
    }

    public void setDgroupw(NSButton dgroupw) {
        this.dgroupw = dgroupw;
        this.dgroupw.setEnabled(this.preferences.getBoolean("queue.download.permissions.change") && this.preferences.getBoolean("queue.download.permissions.default"));
        this.dgroupw.setTarget(this.id());
        this.dgroupw.setAction(Foundation.selector((String)"defaultPermissionsDownloadChanged:"));
    }

    public void setDgroupx(NSButton dgroupx) {
        this.dgroupx = dgroupx;
        this.dgroupx.setEnabled(this.preferences.getBoolean("queue.download.permissions.change") && this.preferences.getBoolean("queue.download.permissions.default"));
        this.dgroupx.setTarget(this.id());
        this.dgroupx.setAction(Foundation.selector((String)"defaultPermissionsDownloadChanged:"));
    }

    public void setDotherr(NSButton dotherr) {
        this.dotherr = dotherr;
        this.dotherr.setEnabled(this.preferences.getBoolean("queue.download.permissions.change") && this.preferences.getBoolean("queue.download.permissions.default"));
        this.dotherr.setTarget(this.id());
        this.dotherr.setAction(Foundation.selector((String)"defaultPermissionsDownloadChanged:"));
    }

    public void setDotherw(NSButton dotherw) {
        this.dotherw = dotherw;
        this.dotherw.setEnabled(this.preferences.getBoolean("queue.download.permissions.change") && this.preferences.getBoolean("queue.download.permissions.default"));
        this.dotherw.setTarget(this.id());
        this.dotherw.setAction(Foundation.selector((String)"defaultPermissionsDownloadChanged:"));
    }

    public void setDotherx(NSButton dotherx) {
        this.dotherx = dotherx;
        this.dotherx.setEnabled(this.preferences.getBoolean("queue.download.permissions.change") && this.preferences.getBoolean("queue.download.permissions.default"));
        this.dotherx.setTarget(this.id());
        this.dotherx.setAction(Foundation.selector((String)"defaultPermissionsDownloadChanged:"));
    }

    public void defaultPermissionsDownloadChanged(ID sender) {
        Permission.Action u = Permission.Action.none;
        if (this.downerr.state() == 1) {
            u = u.or(Permission.Action.read);
        }
        if (this.downerw.state() == 1) {
            u = u.or(Permission.Action.write);
        }
        if (this.downerx.state() == 1) {
            u = u.or(Permission.Action.execute);
        }
        Permission.Action g = Permission.Action.none;
        if (this.dgroupr.state() == 1) {
            g = g.or(Permission.Action.read);
        }
        if (this.dgroupw.state() == 1) {
            g = g.or(Permission.Action.write);
        }
        if (this.dgroupx.state() == 1) {
            g = g.or(Permission.Action.execute);
        }
        Permission.Action o = Permission.Action.none;
        if (this.dotherr.state() == 1) {
            o = o.or(Permission.Action.read);
        }
        if (this.dotherw.state() == 1) {
            o = o.or(Permission.Action.write);
        }
        if (this.dotherx.state() == 1) {
            o = o.or(Permission.Action.execute);
        }
        Permission permission = new Permission(u, g, o);
        if (this.chmodDownloadTypePopup.selectedItem().tag() == 0) {
            this.preferences.setProperty("queue.download.permissions.file.default", permission.getMode());
        }
        if (this.chmodDownloadTypePopup.selectedItem().tag() == 1) {
            this.preferences.setProperty("queue.download.permissions.folder.default", permission.getMode());
        }
    }

    public void setUownerr(NSButton uownerr) {
        this.uownerr = uownerr;
        this.uownerr.setEnabled(this.preferences.getBoolean("queue.upload.permissions.change") && this.preferences.getBoolean("queue.upload.permissions.default"));
        this.uownerr.setTarget(this.id());
        this.uownerr.setAction(Foundation.selector((String)"defaultPermissionsUploadChanged:"));
    }

    public void setUownerw(NSButton uownerw) {
        this.uownerw = uownerw;
        this.uownerw.setEnabled(this.preferences.getBoolean("queue.upload.permissions.change") && this.preferences.getBoolean("queue.upload.permissions.default"));
        this.uownerw.setTarget(this.id());
        this.uownerw.setAction(Foundation.selector((String)"defaultPermissionsUploadChanged:"));
    }

    public void setUownerx(NSButton uownerx) {
        this.uownerx = uownerx;
        this.uownerx.setEnabled(this.preferences.getBoolean("queue.upload.permissions.change") && this.preferences.getBoolean("queue.upload.permissions.default"));
        this.uownerx.setTarget(this.id());
        this.uownerx.setAction(Foundation.selector((String)"defaultPermissionsUploadChanged:"));
    }

    public void setUgroupr(NSButton ugroupr) {
        this.ugroupr = ugroupr;
        this.ugroupr.setEnabled(this.preferences.getBoolean("queue.upload.permissions.change") && this.preferences.getBoolean("queue.upload.permissions.default"));
        this.ugroupr.setTarget(this.id());
        this.ugroupr.setAction(Foundation.selector((String)"defaultPermissionsUploadChanged:"));
    }

    public void setUgroupw(NSButton ugroupw) {
        this.ugroupw = ugroupw;
        this.ugroupw.setEnabled(this.preferences.getBoolean("queue.upload.permissions.change") && this.preferences.getBoolean("queue.upload.permissions.default"));
        this.ugroupw.setTarget(this.id());
        this.ugroupw.setAction(Foundation.selector((String)"defaultPermissionsUploadChanged:"));
    }

    public void setUgroupx(NSButton ugroupx) {
        this.ugroupx = ugroupx;
        this.ugroupx.setEnabled(this.preferences.getBoolean("queue.upload.permissions.change") && this.preferences.getBoolean("queue.upload.permissions.default"));
        this.ugroupx.setTarget(this.id());
        this.ugroupx.setAction(Foundation.selector((String)"defaultPermissionsUploadChanged:"));
    }

    public void setUotherr(NSButton uotherr) {
        this.uotherr = uotherr;
        this.uotherr.setEnabled(this.preferences.getBoolean("queue.upload.permissions.change") && this.preferences.getBoolean("queue.upload.permissions.default"));
        this.uotherr.setTarget(this.id());
        this.uotherr.setAction(Foundation.selector((String)"defaultPermissionsUploadChanged:"));
    }

    public void setUotherw(NSButton uotherw) {
        this.uotherw = uotherw;
        this.uotherw.setEnabled(this.preferences.getBoolean("queue.upload.permissions.change") && this.preferences.getBoolean("queue.upload.permissions.default"));
        this.uotherw.setTarget(this.id());
        this.uotherw.setAction(Foundation.selector((String)"defaultPermissionsUploadChanged:"));
    }

    public void setUotherx(NSButton uotherx) {
        this.uotherx = uotherx;
        this.uotherx.setEnabled(this.preferences.getBoolean("queue.upload.permissions.change") && this.preferences.getBoolean("queue.upload.permissions.default"));
        this.uotherx.setTarget(this.id());
        this.uotherx.setAction(Foundation.selector((String)"defaultPermissionsUploadChanged:"));
    }

    public void defaultPermissionsUploadChanged(NSButton sender) {
        Permission.Action u = Permission.Action.none;
        if (this.uownerr.state() == 1) {
            u = u.or(Permission.Action.read);
        }
        if (this.uownerw.state() == 1) {
            u = u.or(Permission.Action.write);
        }
        if (this.uownerx.state() == 1) {
            u = u.or(Permission.Action.execute);
        }
        Permission.Action g = Permission.Action.none;
        if (this.ugroupr.state() == 1) {
            g = g.or(Permission.Action.read);
        }
        if (this.ugroupw.state() == 1) {
            g = g.or(Permission.Action.write);
        }
        if (this.ugroupx.state() == 1) {
            g = g.or(Permission.Action.execute);
        }
        Permission.Action o = Permission.Action.none;
        if (this.uotherr.state() == 1) {
            o = o.or(Permission.Action.read);
        }
        if (this.uotherw.state() == 1) {
            o = o.or(Permission.Action.write);
        }
        if (this.uotherx.state() == 1) {
            o = o.or(Permission.Action.execute);
        }
        Permission permission = new Permission(u, g, o);
        if (this.chmodUploadTypePopup.selectedItem().tag() == 0) {
            this.preferences.setProperty("queue.upload.permissions.file.default", permission.getMode());
        }
        if (this.chmodUploadTypePopup.selectedItem().tag() == 1) {
            this.preferences.setProperty("queue.upload.permissions.folder.default", permission.getMode());
        }
    }

    public void setPreserveModificationDownloadCheckbox(NSButton b) {
        this.preserveModificationDownloadCheckbox = b;
        this.preserveModificationDownloadCheckbox.setTarget(this.id());
        this.preserveModificationDownloadCheckbox.setAction(Foundation.selector((String)"preserveModificationDownloadCheckboxClicked:"));
        this.preserveModificationDownloadCheckbox.setState(this.preferences.getBoolean("queue.download.timestamp.change") ? 1 : 0);
    }

    public void preserveModificationDownloadCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("queue.download.timestamp.change", enabled);
    }

    public void setPreserveModificationUploadCheckbox(NSButton b) {
        this.preserveModificationUploadCheckbox = b;
        this.preserveModificationUploadCheckbox.setTarget(this.id());
        this.preserveModificationUploadCheckbox.setAction(Foundation.selector((String)"preserveModificationUploadCheckboxClicked:"));
        this.preserveModificationUploadCheckbox.setState(this.preferences.getBoolean("queue.upload.timestamp.change") ? 1 : 0);
    }

    public void preserveModificationUploadCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("queue.upload.timestamp.change", enabled);
    }

    public void setChecksumDownloadCheckbox(NSButton b) {
        this.checksumDownloadCheckbox = b;
        this.checksumDownloadCheckbox.setTarget(this.id());
        this.checksumDownloadCheckbox.setAction(Foundation.selector((String)"checksumDownloadCheckboxClicked:"));
        this.checksumDownloadCheckbox.setState(this.preferences.getBoolean("queue.download.checksum.calculate") ? 1 : 0);
    }

    public void checksumDownloadCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("queue.download.checksum.calculate", enabled);
    }

    public void setChecksumUploadCheckbox(NSButton b) {
        this.checksumUploadCheckbox = b;
        this.checksumUploadCheckbox.setTarget(this.id());
        this.checksumUploadCheckbox.setAction(Foundation.selector((String)"checksumUploadCheckboxClicked:"));
        this.checksumUploadCheckbox.setState(this.preferences.getBoolean("queue.upload.checksum.calculate") ? 1 : 0);
    }

    public void checksumUploadCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("queue.upload.checksum.calculate", enabled);
    }

    public void setHorizontalLinesCheckbox(NSButton b) {
        this.horizontalLinesCheckbox = b;
        this.horizontalLinesCheckbox.setTarget(this.id());
        this.horizontalLinesCheckbox.setAction(Foundation.selector((String)"horizontalLinesCheckboxClicked:"));
        this.horizontalLinesCheckbox.setState(this.preferences.getBoolean("browser.horizontalLines") ? 1 : 0);
    }

    public void horizontalLinesCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("browser.horizontalLines", enabled);
        BrowserController.updateBrowserTableAttributes();
    }

    public void setVerticalLinesCheckbox(NSButton b) {
        this.verticalLinesCheckbox = b;
        this.verticalLinesCheckbox.setTarget(this.id());
        this.verticalLinesCheckbox.setAction(Foundation.selector((String)"verticalLinesCheckboxClicked:"));
        this.verticalLinesCheckbox.setState(this.preferences.getBoolean("browser.verticalLines") ? 1 : 0);
    }

    public void verticalLinesCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("browser.verticalLines", enabled);
        BrowserController.updateBrowserTableAttributes();
    }

    public void setAlternatingRowBackgroundCheckbox(NSButton b) {
        this.alternatingRowBackgroundCheckbox = b;
        this.alternatingRowBackgroundCheckbox.setTarget(this.id());
        this.alternatingRowBackgroundCheckbox.setAction(Foundation.selector((String)"alternatingRowBackgroundCheckboxClicked:"));
        this.alternatingRowBackgroundCheckbox.setState(this.preferences.getBoolean("browser.alternatingRows") ? 1 : 0);
    }

    public void alternatingRowBackgroundCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("browser.alternatingRows", enabled);
        BrowserController.updateBrowserTableAttributes();
    }

    public void setInfoWindowAsInspectorCheckbox(NSButton b) {
        this.infoWindowAsInspectorCheckbox = b;
        this.infoWindowAsInspectorCheckbox.setTarget(this.id());
        this.infoWindowAsInspectorCheckbox.setAction(Foundation.selector((String)"infoWindowAsInspectorCheckboxClicked:"));
        this.infoWindowAsInspectorCheckbox.setState(this.preferences.getBoolean("browser.info.inspector") ? 1 : 0);
    }

    public void infoWindowAsInspectorCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("browser.info.inspector", enabled);
    }

    public void setDownloadPathPopup(NSPopUpButton b) {
        this.downloadPathPopup = b;
        this.downloadPathPopup.setTarget(this.id());
        this.downloadPathPopup.setAction(Foundation.selector((String)"downloadPathPopupClicked:"));
        this.downloadPathPopup.removeAllItems();
        this.addDownloadPath(this.DEFAULT_DOWNLOAD_FOLDER);
        this.downloadPathPopup.menu().addItem(NSMenuItem.separatorItem());
        this.addDownloadPath(LocalFactory.get((String)"~/Desktop"));
        this.addDownloadPath(LocalFactory.get((String)"~"));
        this.addDownloadPath(LocalFactory.get((String)"~/Downloads"));
        this.downloadPathPopup.menu().addItem(NSMenuItem.separatorItem());
        this.downloadPathPopup.addItemWithTitle(String.format("%s\u2026", LocaleFactory.localizedString((String)"Choose")));
    }

    private void addDownloadPath(Local f) {
        this.downloadPathPopup.addItemWithTitle(f.getDisplayName());
        this.downloadPathPopup.lastItem().setImage((NSImage)IconCacheFactory.get().fileIcon(f, Integer.valueOf(16)));
        this.downloadPathPopup.lastItem().setRepresentedObject(f.getAbbreviatedPath());
        if (this.DEFAULT_DOWNLOAD_FOLDER.equals((Object)f)) {
            this.downloadPathPopup.selectItem(this.downloadPathPopup.lastItem());
        }
    }

    public void downloadPathPopupClicked(NSPopUpButton sender) {
        if (sender.title().equals(String.format("%s\u2026", LocaleFactory.localizedString((String)"Choose")))) {
            this.downloadPathPanel = NSOpenPanel.openPanel();
            this.downloadPathPanel.setCanChooseFiles(false);
            this.downloadPathPanel.setCanChooseDirectories(true);
            this.downloadPathPanel.setAllowsMultipleSelection(false);
            this.downloadPathPanel.setCanCreateDirectories(true);
            this.downloadPathPanel.beginSheetForDirectory(null, null, this.window, this.id(), Foundation.selector((String)"downloadPathPanelDidEnd:returnCode:contextInfo:"), null);
        } else {
            this.preferences.setProperty("queue.download.folder", sender.selectedItem().representedObject());
        }
    }

    public void downloadPathPanelDidEnd_returnCode_contextInfo(NSOpenPanel sheet, int returncode, ID contextInfo) {
        NSObject selected;
        if (returncode == 1 && (selected = sheet.URLs().lastObject()) != null) {
            Local folder = LocalFactory.get((String)((NSURL)Rococoa.cast((ObjCObject)selected, NSURL.class)).path());
            this.preferences.setProperty("queue.download.folder", folder.getAbbreviatedPath());
            this.preferences.setProperty("queue.download.folder.bookmark", folder.getBookmark());
        }
        Local custom = LocalFactory.get((String)this.preferences.getProperty("queue.download.folder"));
        NSMenuItem item = this.downloadPathPopup.itemAtIndex(new NSInteger(0L));
        item.setTitle(custom.getDisplayName());
        item.setRepresentedObject(custom.getAbsolute());
        item.setImage((NSImage)IconCacheFactory.get().fileIcon(custom, Integer.valueOf(16)));
        this.downloadPathPopup.selectItem(item);
        this.downloadPathPanel = null;
    }

    public void setTransferPopup(NSPopUpButton b) {
        this.transferPopup = b;
        this.transferPopup.setTarget(this.id());
        this.transferPopup.setAction(Foundation.selector((String)"transferPopupClicked:"));
        this.transferPopup.removeAllItems();
        for (String name : this.preferences.getList("queue.transfer.type.enabled")) {
            Host.TransferType t = Host.TransferType.valueOf((String)name);
            this.transferPopup.addItemWithTitle(t.toString());
            this.transferPopup.lastItem().setRepresentedObject(t.name());
        }
        this.transferPopup.selectItemAtIndex(this.transferPopup.indexOfItemWithRepresentedObject(this.preferences.getProperty("queue.transfer.type")));
    }

    public void transferPopupClicked(NSPopUpButton sender) {
        this.preferences.setProperty("queue.transfer.type", sender.selectedItem().representedObject());
    }

    public void setDownloadSkipButton(NSButton b) {
        this.downloadSkipButton = b;
        this.downloadSkipButton.setTarget(this.id());
        this.downloadSkipButton.setAction(Foundation.selector((String)"downloadSkipButtonClicked:"));
        this.downloadSkipButton.setState(this.preferences.getBoolean("queue.download.skip.enable") ? 1 : 0);
    }

    public void downloadSkipButtonClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.downloadSkipRegexField.setSelectable(enabled);
        this.downloadSkipRegexField.setEditable(enabled);
        this.downloadSkipRegexField.setTextColor(enabled ? NSColor.controlTextColor() : NSColor.disabledControlTextColor());
        this.preferences.setProperty("queue.download.skip.enable", enabled);
    }

    public void setDownloadSkipRegexDefaultButton(NSButton b) {
        this.downloadSkipRegexDefaultButton = b;
        this.downloadSkipRegexDefaultButton.setTarget(this.id());
        this.downloadSkipRegexDefaultButton.setAction(Foundation.selector((String)"downloadSkipRegexDefaultButtonClicked:"));
    }

    public void downloadSkipRegexDefaultButtonClicked(NSButton sender) {
        String regex = this.preferences.getProperty("queue.download.skip.regex.default");
        this.downloadSkipRegexField.setString(regex);
        this.preferences.setProperty("queue.download.skip.regex", regex);
    }

    public void setDownloadSkipRegexField(NSTextView t) {
        this.downloadSkipRegexField = t;
        this.downloadSkipRegexField.setFont(NSFont.userFixedPitchFontOfSize((double)9.0));
        this.downloadSkipRegexField.setString(this.preferences.getProperty("queue.download.skip.regex"));
        this.notificationCenter.addObserver(this.id(), Foundation.selector((String)"downloadSkipRegexFieldDidChange:"), "NSTextDidChangeNotification", this.downloadSkipRegexField.id());
    }

    public void downloadSkipRegexFieldDidChange(NSNotification sender) {
        String value = this.downloadSkipRegexField.string().trim();
        if ("".equals(value)) {
            this.preferences.setProperty("queue.download.skip.enable", false);
            this.preferences.setProperty("queue.download.skip.regex", value);
            this.downloadSkipButton.setState(0);
        }
        try {
            Pattern compiled = Pattern.compile(value);
            this.preferences.setProperty("queue.download.skip.regex", compiled.pattern());
            this.mark((NSMutableAttributedString)this.downloadSkipRegexField.textStorage(), null);
        }
        catch (PatternSyntaxException e) {
            this.mark((NSMutableAttributedString)this.downloadSkipRegexField.textStorage(), e);
        }
    }

    public void setUploadSkipButton(NSButton b) {
        this.uploadSkipButton = b;
        this.uploadSkipButton.setTarget(this.id());
        this.uploadSkipButton.setAction(Foundation.selector((String)"uploadSkipButtonClicked:"));
        this.uploadSkipButton.setState(this.preferences.getBoolean("queue.upload.skip.enable") ? 1 : 0);
    }

    public void uploadSkipButtonClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.uploadSkipRegexField.setSelectable(enabled);
        this.uploadSkipRegexField.setEditable(enabled);
        this.uploadSkipRegexField.setTextColor(enabled ? NSColor.controlTextColor() : NSColor.disabledControlTextColor());
        this.preferences.setProperty("queue.upload.skip.enable", enabled);
    }

    public void setUploadSkipRegexDefaultButton(NSButton b) {
        this.uploadSkipRegexDefaultButton = b;
        this.uploadSkipRegexDefaultButton.setTarget(this.id());
        this.uploadSkipRegexDefaultButton.setAction(Foundation.selector((String)"uploadSkipRegexDefaultButtonClicked:"));
    }

    public void uploadSkipRegexDefaultButtonClicked(NSButton sender) {
        String regex = this.preferences.getProperty("queue.upload.skip.regex.default");
        this.uploadSkipRegexField.setString(regex);
        this.preferences.setProperty("queue.upload.skip.regex", regex);
    }

    public void setUploadSkipRegexField(NSTextView b) {
        this.uploadSkipRegexField = b;
        this.uploadSkipRegexField.setFont(NSFont.userFixedPitchFontOfSize((double)9.0));
        this.uploadSkipRegexField.setString(this.preferences.getProperty("queue.upload.skip.regex"));
        this.notificationCenter.addObserver(this.id(), Foundation.selector((String)"uploadSkipRegexFieldDidChange:"), "NSTextDidChangeNotification", this.uploadSkipRegexField.id());
    }

    public void uploadSkipRegexFieldDidChange(NSNotification sender) {
        String value = this.uploadSkipRegexField.string().trim();
        if ("".equals(value)) {
            this.preferences.setProperty("queue.upload.skip.enable", false);
            this.preferences.setProperty("queue.upload.skip.regex", value);
            this.uploadSkipButton.setState(0);
        }
        try {
            Pattern compiled = Pattern.compile(value);
            this.preferences.setProperty("queue.upload.skip.regex", compiled.pattern());
            this.mark((NSMutableAttributedString)this.uploadSkipRegexField.textStorage(), null);
        }
        catch (PatternSyntaxException e) {
            this.mark((NSMutableAttributedString)this.uploadSkipRegexField.textStorage(), e);
        }
    }

    private void mark(NSMutableAttributedString text, PatternSyntaxException e) {
        if (null == e) {
            text.removeAttributeInRange("NSColor", NSRange.NSMakeRange((NSUInteger)new NSUInteger(0L), (NSUInteger)text.length()));
            return;
        }
        int index = e.getIndex();
        NSRange range = null;
        if (-1 == index) {
            range = NSRange.NSMakeRange((NSUInteger)new NSUInteger(0L), (NSUInteger)text.length());
        }
        if (index < text.length().intValue()) {
            range = NSRange.NSMakeRange((NSUInteger)new NSUInteger((long)index), (NSUInteger)new NSUInteger(1L));
        }
        text.addAttributesInRange(RED_FONT, range);
    }

    public void setKeychainCheckbox(NSButton b) {
        this.keychainCheckbox = b;
        this.keychainCheckbox.setTarget(this.id());
        this.keychainCheckbox.setAction(Foundation.selector((String)"keychainCheckboxClicked:"));
        this.keychainCheckbox.setState(this.preferences.getBoolean("connection.login.keychain") ? 1 : 0);
    }

    public void keychainCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("connection.login.keychain", enabled);
    }

    public void setDoubleClickCheckbox(NSButton b) {
        this.doubleClickCheckbox = b;
        this.doubleClickCheckbox.setTarget(this.id());
        this.doubleClickCheckbox.setAction(Foundation.selector((String)"doubleClickCheckboxClicked:"));
        this.doubleClickCheckbox.setState(this.preferences.getBoolean("browser.doubleclick.edit") ? 1 : 0);
    }

    public void doubleClickCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("browser.doubleclick.edit", enabled);
    }

    public void setReturnKeyCheckbox(NSButton b) {
        this.returnKeyCheckbox = b;
        this.returnKeyCheckbox.setTarget(this.id());
        this.returnKeyCheckbox.setAction(Foundation.selector((String)"returnKeyCheckboxClicked:"));
        this.returnKeyCheckbox.setState(this.preferences.getBoolean("browser.enterkey.rename") ? 1 : 0);
    }

    public void returnKeyCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("browser.enterkey.rename", enabled);
    }

    public void setAutoExpandCheckbox(NSButton b) {
        this.autoExpandCheckbox = b;
        this.autoExpandCheckbox.setTarget(this.id());
        this.autoExpandCheckbox.setAction(Foundation.selector((String)"autoExpandCheckboxClicked:"));
        this.autoExpandCheckbox.setState(this.preferences.getBoolean("browser.view.autoexpand") ? 1 : 0);
    }

    public void autoExpandCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("browser.view.autoexpand", enabled);
        this.autoExpandDelayCheckbox.setEnabled(enabled);
        this.autoExpandDelaySlider.setEnabled(enabled);
    }

    public void setAutoExpandDelayCheckbox(NSButton b) {
        this.autoExpandDelayCheckbox = b;
        this.autoExpandDelayCheckbox.setTarget(this.id());
        this.autoExpandDelayCheckbox.setAction(Foundation.selector((String)"autoExpandDelayCheckboxClicked:"));
        this.autoExpandDelayCheckbox.setState(this.preferences.getBoolean("browser.view.autoexpand.delay.enable") ? 1 : 0);
    }

    public void autoExpandDelayCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("browser.view.autoexpand.delay.enable", enabled);
        this.autoExpandDelaySlider.setEnabled(enabled);
    }

    public void setAutoExpandDelaySlider(NSSlider b) {
        this.autoExpandDelaySlider = b;
        this.autoExpandDelaySlider.setTarget(this.id());
        this.autoExpandDelaySlider.setAction(Foundation.selector((String)"autoExpandDelaySliderClicked:"));
        this.autoExpandDelaySlider.setDoubleValue(this.preferences.getDouble("browser.view.autoexpand.delay"));
    }

    public void autoExpandDelaySliderClicked(NSSlider sender) {
        this.preferences.setProperty("browser.view.autoexpand.delay", sender.doubleValue());
    }

    public void setShowHiddenCheckbox(NSButton b) {
        this.showHiddenCheckbox = b;
        this.showHiddenCheckbox.setTarget(this.id());
        this.showHiddenCheckbox.setAction(Foundation.selector((String)"showHiddenCheckboxClicked:"));
        this.showHiddenCheckbox.setState(this.preferences.getBoolean("browser.showHidden") ? 1 : 0);
    }

    public void showHiddenCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("browser.showHidden", enabled);
    }

    public void setBringQueueToFrontCheckbox(NSButton b) {
        this.bringQueueToFrontCheckbox = b;
        this.bringQueueToFrontCheckbox.setTarget(this.id());
        this.bringQueueToFrontCheckbox.setAction(Foundation.selector((String)"bringQueueToFrontCheckboxClicked:"));
        this.bringQueueToFrontCheckbox.setState(this.preferences.getBoolean("queue.window.open.transfer.start") ? 1 : 0);
    }

    public void bringQueueToFrontCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("queue.window.open.transfer.start", enabled);
    }

    public void setBringQueueToBackCheckbox(NSButton b) {
        this.bringQueueToBackCheckbox = b;
        this.bringQueueToBackCheckbox.setTarget(this.id());
        this.bringQueueToBackCheckbox.setAction(Foundation.selector((String)"bringQueueToBackCheckboxClicked:"));
        this.bringQueueToBackCheckbox.setState(this.preferences.getBoolean("queue.window.open.transfer.stop") ? 1 : 0);
    }

    public void bringQueueToBackCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("queue.window.open.transfer.stop", enabled);
    }

    public void setRemoveFromQueueCheckbox(NSButton b) {
        this.removeFromQueueCheckbox = b;
        this.removeFromQueueCheckbox.setTarget(this.id());
        this.removeFromQueueCheckbox.setAction(Foundation.selector((String)"removeFromQueueCheckboxClicked:"));
        this.removeFromQueueCheckbox.setState(this.preferences.getBoolean("queue.removeItemWhenComplete") ? 1 : 0);
    }

    public void removeFromQueueCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("queue.removeItemWhenComplete", enabled);
    }

    public void setSegmentedDownloadCheckbox(NSButton b) {
        this.segmentedDownloadCheckbox = b;
        this.segmentedDownloadCheckbox.setTarget(this.id());
        this.segmentedDownloadCheckbox.setAction(Foundation.selector((String)"segmentedDownloadCheckboxClicked:"));
        this.segmentedDownloadCheckbox.setState(this.preferences.getBoolean("queue.download.segments") ? 1 : 0);
    }

    public void segmentedDownloadCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("queue.download.segments", enabled);
    }

    public void setOpenAfterDownloadCheckbox(NSButton b) {
        this.openAfterDownloadCheckbox = b;
        this.openAfterDownloadCheckbox.setTarget(this.id());
        this.openAfterDownloadCheckbox.setAction(Foundation.selector((String)"openAfterDownloadCheckboxClicked:"));
        this.openAfterDownloadCheckbox.setState(this.preferences.getBoolean("queue.download.complete.open") ? 1 : 0);
    }

    public void openAfterDownloadCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("queue.download.complete.open", enabled);
    }

    public void setDuplicateDownloadCombobox(NSPopUpButton b) {
        this.duplicateDownloadCombobox = b;
        this.duplicateDownloadCombobox.setAutoenablesItems(false);
        this.duplicateDownloadCombobox.setTarget(this.id());
        this.duplicateDownloadCombobox.setAction(Foundation.selector((String)"duplicateDownloadComboboxClicked:"));
        this.duplicateDownloadCombobox.removeAllItems();
        for (TransferAction action : new TransferAction[]{TransferAction.callback, TransferAction.overwrite, TransferAction.resume, TransferAction.rename, TransferAction.renameexisting, TransferAction.comparison, TransferAction.skip}) {
            this.duplicateDownloadCombobox.addItemWithTitle(action.getTitle());
            this.duplicateDownloadCombobox.lastItem().setRepresentedObject(action.name());
            this.duplicateDownloadCombobox.addItemWithTitle(action.getDescription());
            this.duplicateDownloadCombobox.lastItem().setAttributedTitle(NSAttributedString.attributedStringWithAttributes((String)action.getDescription(), (NSDictionary)MENU_HELP_FONT_ATTRIBUTES));
            this.duplicateDownloadCombobox.lastItem().setEnabled(false);
        }
        this.duplicateDownloadCombobox.selectItemWithTitle(TransferAction.forName((String)this.preferences.getProperty("queue.download.action")).getTitle());
    }

    public void duplicateDownloadComboboxClicked(NSPopUpButton sender) {
        this.preferences.setProperty("queue.download.action", TransferAction.forName((String)sender.selectedItem().representedObject()).name());
        this.duplicateDownloadOverwriteButtonClicked(this.duplicateDownloadOverwriteButton);
    }

    public void setDuplicateDownloadOverwriteButton(NSButton b) {
        this.duplicateDownloadOverwriteButton = b;
        this.duplicateDownloadOverwriteButton.setTarget(this.id());
        this.duplicateDownloadOverwriteButton.setAction(Foundation.selector((String)"duplicateDownloadOverwriteButtonClicked:"));
        this.duplicateDownloadOverwriteButton.setState(this.preferences.getProperty("queue.download.reload.action").equals(TransferAction.overwrite.name()) ? 1 : 0);
    }

    public void duplicateDownloadOverwriteButtonClicked(NSButton sender) {
        boolean enabled;
        boolean bl = enabled = sender.state() == 1;
        if (enabled) {
            this.preferences.setProperty("queue.download.reload.action", TransferAction.overwrite.name());
        } else {
            this.preferences.setProperty("queue.download.reload.action", this.preferences.getProperty("queue.download.action"));
        }
    }

    public void setDuplicateUploadCombobox(NSPopUpButton b) {
        this.duplicateUploadCombobox = b;
        this.duplicateUploadCombobox.setAutoenablesItems(false);
        this.duplicateUploadCombobox.setTarget(this.id());
        this.duplicateUploadCombobox.setAction(Foundation.selector((String)"duplicateUploadComboboxClicked:"));
        this.duplicateUploadCombobox.removeAllItems();
        for (TransferAction action : new TransferAction[]{TransferAction.callback, TransferAction.overwrite, TransferAction.resume, TransferAction.rename, TransferAction.renameexisting, TransferAction.comparison, TransferAction.skip}) {
            this.duplicateUploadCombobox.addItemWithTitle(action.getTitle());
            this.duplicateUploadCombobox.lastItem().setRepresentedObject(action.name());
            this.duplicateUploadCombobox.addItemWithTitle(action.getDescription());
            this.duplicateUploadCombobox.lastItem().setAttributedTitle(NSAttributedString.attributedStringWithAttributes((String)action.getDescription(), (NSDictionary)MENU_HELP_FONT_ATTRIBUTES));
            this.duplicateUploadCombobox.lastItem().setEnabled(false);
        }
        this.duplicateUploadCombobox.selectItemWithTitle(TransferAction.forName((String)this.preferences.getProperty("queue.upload.action")).getTitle());
    }

    public void duplicateUploadComboboxClicked(NSPopUpButton sender) {
        this.preferences.setProperty("queue.upload.action", TransferAction.forName((String)sender.selectedItem().representedObject()).name());
        this.duplicateUploadOverwriteButtonClicked(this.duplicateUploadOverwriteButton);
    }

    public void setDuplicateUploadOverwriteButton(NSButton b) {
        this.duplicateUploadOverwriteButton = b;
        this.duplicateUploadOverwriteButton.setTarget(this.id());
        this.duplicateUploadOverwriteButton.setAction(Foundation.selector((String)"duplicateUploadOverwriteButtonClicked:"));
        this.duplicateUploadOverwriteButton.setState(this.preferences.getProperty("queue.upload.reload.action").equals(TransferAction.overwrite.name()) ? 1 : 0);
    }

    public void duplicateUploadOverwriteButtonClicked(NSButton sender) {
        boolean enabled;
        boolean bl = enabled = sender.state() == 1;
        if (enabled) {
            this.preferences.setProperty("queue.upload.reload.action", TransferAction.overwrite.name());
        } else {
            this.preferences.setProperty("queue.upload.reload.action", this.preferences.getProperty("queue.upload.action"));
        }
    }

    public void setUploadTemporaryFilenameButton(NSButton b) {
        this.uploadTemporaryFilenameButton = b;
        this.uploadTemporaryFilenameButton.setTarget(this.id());
        this.uploadTemporaryFilenameButton.setAction(Foundation.selector((String)"uploadTemporaryFilenameButtonClicked:"));
        this.uploadTemporaryFilenameButton.setState(this.preferences.getBoolean("queue.upload.file.temporary") ? 1 : 0);
    }

    public void uploadTemporaryFilenameButtonClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("queue.upload.file.temporary", enabled);
    }

    public void setProtocolCombobox(NSPopUpButton b) {
        this.protocolCombobox = b;
        this.protocolCombobox.setTarget(this.id());
        this.protocolCombobox.setAction(Foundation.selector((String)"protocolComboboxClicked:"));
        this.protocolCombobox.removeAllItems();
        ProtocolFactory protocols = ProtocolFactory.get();
        for (Protocol protocol : protocols.find((Predicate)new DefaultProtocolPredicate(EnumSet.of(Protocol.Type.ftp, Protocol.Type.sftp, Protocol.Type.dav)))) {
            this.addProtocol(protocol);
        }
        this.protocolCombobox.menu().addItem(NSMenuItem.separatorItem());
        for (Protocol protocol : protocols.find((Predicate)new DefaultProtocolPredicate(EnumSet.of(Protocol.Type.s3, Protocol.Type.swift, Protocol.Type.azure, Protocol.Type.b2, Protocol.Type.googlestorage)))) {
            this.addProtocol(protocol);
        }
        this.protocolCombobox.menu().addItem(NSMenuItem.separatorItem());
        for (Protocol protocol : protocols.find((Predicate)new DefaultProtocolPredicate(EnumSet.of(Protocol.Type.dropbox, new Protocol.Type[]{Protocol.Type.box, Protocol.Type.onedrive, Protocol.Type.googledrive, Protocol.Type.nextcloud, Protocol.Type.owncloud, Protocol.Type.dracoon, Protocol.Type.brick})))) {
            this.addProtocol(protocol);
        }
        this.protocolCombobox.menu().addItem(NSMenuItem.separatorItem());
        for (Protocol protocol : protocols.find((Predicate)new DefaultProtocolPredicate(EnumSet.of(Protocol.Type.file)))) {
            this.addProtocol(protocol);
        }
        this.protocolCombobox.menu().addItem(NSMenuItem.separatorItem());
        for (Protocol protocol : protocols.find((Predicate)new ProfileProtocolPredicate())) {
            this.addProtocol(protocol);
        }
        Protocol defaultProtocol = ProtocolFactory.get().forName(this.preferences.getProperty("connection.protocol.default"));
        this.protocolCombobox.selectItemAtIndex(this.protocolCombobox.indexOfItemWithRepresentedObject(String.valueOf(defaultProtocol.hashCode())));
    }

    private void addProtocol(Protocol protocol) {
        String title = protocol.getDescription();
        this.protocolCombobox.addItemWithTitle(title);
        this.protocolCombobox.lastItem().setRepresentedObject(String.valueOf(protocol.hashCode()));
        this.protocolCombobox.lastItem().setImage((NSImage)IconCacheFactory.get().iconNamed(protocol.icon(), Integer.valueOf(16)));
        if (protocol.isDeprecated()) {
            this.protocolCombobox.lastItem().setEnabled(false);
        }
    }

    public void protocolComboboxClicked(NSPopUpButton sender) {
        Protocol selected = ProtocolFactory.get().forName(sender.selectedItem().representedObject());
        this.preferences.setProperty("connection.protocol.default", String.format("%s-%s", selected.getIdentifier(), selected.getProvider()));
        this.preferences.setProperty("connection.port.default", selected.getDefaultPort());
    }

    public void setConfirmDisconnectCheckbox(NSButton b) {
        this.confirmDisconnectCheckbox = b;
        this.confirmDisconnectCheckbox.setTarget(this.id());
        this.confirmDisconnectCheckbox.setAction(Foundation.selector((String)"confirmDisconnectCheckboxClicked:"));
        this.confirmDisconnectCheckbox.setState(this.preferences.getBoolean("browser.disconnect.confirm") ? 1 : 0);
    }

    public void confirmDisconnectCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("browser.disconnect.confirm", enabled);
    }

    private void configureDefaultProtocolHandlerCombobox(NSPopUpButton defaultProtocolHandlerCombobox, Scheme protocol) {
        Application defaultHandler = SchemeHandlerFactory.get().getDefaultHandler(protocol.name());
        if (Application.notfound.equals((Object)defaultHandler)) {
            defaultProtocolHandlerCombobox.addItemWithTitle(LocaleFactory.localizedString((String)"Unknown"));
            defaultProtocolHandlerCombobox.setEnabled(false);
        } else {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Default Protocol Handler for %s:%s", protocol, defaultHandler));
            }
            for (Application handler : SchemeHandlerFactory.get().getAllHandlers(protocol.name())) {
                defaultProtocolHandlerCombobox.addItemWithTitle(handler.getName());
                NSMenuItem item = defaultProtocolHandlerCombobox.lastItem();
                item.setImage((NSImage)IconCacheFactory.get().applicationIcon(handler, Integer.valueOf(16)));
                item.setRepresentedObject(handler.getIdentifier());
                if (!handler.getIdentifier().equals(defaultHandler.getIdentifier())) continue;
                defaultProtocolHandlerCombobox.selectItem(item);
            }
        }
    }

    public void setDefaultFTPHandlerCombobox(NSPopUpButton b) {
        this.defaultFTPHandlerCombobox = b;
        this.defaultFTPHandlerCombobox.setTarget(this.id());
        this.defaultFTPHandlerCombobox.setAction(Foundation.selector((String)"defaultFTPHandlerComboboxClicked:"));
        this.defaultFTPHandlerCombobox.removeAllItems();
    }

    public void defaultFTPHandlerComboboxClicked(NSPopUpButton sender) {
        String bundle = sender.selectedItem().representedObject();
        SchemeHandlerFactory.get().setDefaultHandler(new Application(bundle), Arrays.asList(Scheme.ftp.name(), Scheme.ftps.name()));
    }

    public void setDefaultSFTPHandlerCombobox(NSPopUpButton b) {
        this.defaultSFTPHandlerCombobox = b;
        this.defaultSFTPHandlerCombobox.setTarget(this.id());
        this.defaultSFTPHandlerCombobox.setAction(Foundation.selector((String)"defaultSFTPHandlerComboboxClicked:"));
        this.defaultSFTPHandlerCombobox.removeAllItems();
    }

    public void defaultSFTPHandlerComboboxClicked(NSPopUpButton sender) {
        String bundle = sender.selectedItem().representedObject();
        SchemeHandlerFactory.get().setDefaultHandler(new Application(bundle), Collections.singletonList(Scheme.sftp.name()));
    }

    public void setDefaultDownloadThrottleCombobox(NSPopUpButton b) {
        this.defaultDownloadThrottleCombobox = b;
        this.defaultDownloadThrottleCombobox.setTarget(this.id());
        this.defaultDownloadThrottleCombobox.setAction(Foundation.selector((String)"defaultDownloadThrottleComboboxClicked:"));
        int bandwidth = (int)this.preferences.getDouble("queue.download.bandwidth.bytes");
        StringTokenizer options = new StringTokenizer(this.preferences.getProperty("queue.bandwidth.options"), ",");
        while (options.hasMoreTokens()) {
            String bytes = options.nextToken();
            this.defaultDownloadThrottleCombobox.addItemWithTitle(SizeFormatterFactory.get().format((long)Integer.parseInt(bytes)) + "/s");
            this.defaultDownloadThrottleCombobox.lastItem().setRepresentedObject(bytes);
        }
        if (-1 == bandwidth) {
            this.defaultDownloadThrottleCombobox.selectItemWithTag(new NSInteger(-1L));
        } else {
            this.defaultDownloadThrottleCombobox.selectItemAtIndex(this.defaultDownloadThrottleCombobox.menu().indexOfItemWithRepresentedObject(String.valueOf(bandwidth)));
        }
    }

    public void defaultDownloadThrottleComboboxClicked(NSPopUpButton sender) {
        String bytes = sender.selectedItem().representedObject();
        if (null == bytes) {
            this.preferences.setProperty("queue.download.bandwidth.bytes", -1);
        } else {
            this.preferences.setProperty("queue.download.bandwidth.bytes", Integer.parseInt(bytes));
        }
    }

    public void setDefaultUploadThrottleCombobox(NSPopUpButton b) {
        this.defaultUploadThrottleCombobox = b;
        this.defaultUploadThrottleCombobox.setTarget(this.id());
        this.defaultUploadThrottleCombobox.setAction(Foundation.selector((String)"defaultUploadThrottleComboboxClicked:"));
        int bandwidth = (int)this.preferences.getDouble("queue.upload.bandwidth.bytes");
        StringTokenizer options = new StringTokenizer(this.preferences.getProperty("queue.bandwidth.options"), ",");
        while (options.hasMoreTokens()) {
            String bytes = options.nextToken();
            this.defaultUploadThrottleCombobox.addItemWithTitle(SizeFormatterFactory.get().format((long)Integer.parseInt(bytes)) + "/s");
            this.defaultUploadThrottleCombobox.lastItem().setRepresentedObject(bytes);
        }
        if (-1 == bandwidth) {
            this.defaultUploadThrottleCombobox.selectItemWithTag(new NSInteger(-1L));
        } else {
            this.defaultUploadThrottleCombobox.selectItemAtIndex(this.defaultUploadThrottleCombobox.menu().indexOfItemWithRepresentedObject(String.valueOf(bandwidth)));
        }
    }

    public void defaultUploadThrottleComboboxClicked(NSPopUpButton sender) {
        String bytes = sender.selectedItem().representedObject();
        if (null == bytes) {
            this.preferences.setProperty("queue.upload.bandwidth.bytes", -1);
        } else {
            this.preferences.setProperty("queue.upload.bandwidth.bytes", Integer.parseInt(bytes));
        }
    }

    public void setUpdateCheckbox(NSButton b) {
        this.updateCheckbox = b;
        this.updateCheckbox.setTarget(this.id());
        this.updateCheckbox.setAction(Foundation.selector((String)"updateCheckboxClicked:"));
        this.updateCheckbox.setState(this.preferences.getBoolean("update.check") ? 1 : 0);
    }

    public void updateCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("update.check", enabled);
    }

    public void setUpdateCheckButton(NSButton b) {
        this.updateCheckButton = b;
        this.updateCheckButton.setTarget(NSApplication.sharedApplication().delegate());
        this.updateCheckButton.setAction(Foundation.selector((String)"updateMenuClicked:"));
    }

    public void setUpdateFeedPopup(NSPopUpButton b) {
        this.updateFeedPopup = b;
        this.updateFeedPopup.removeAllItems();
        this.updateFeedPopup.setAction(Foundation.selector((String)"updateFeedPopupClicked:"));
        this.updateFeedPopup.addItemWithTitle(LocaleFactory.localizedString((String)"Release"));
        this.updateFeedPopup.lastItem().setRepresentedObject("release");
        if (this.preferences.getBoolean("update.feed.beta.enable")) {
            this.updateFeedPopup.addItemWithTitle(LocaleFactory.localizedString((String)"Beta"));
            this.updateFeedPopup.lastItem().setRepresentedObject("beta");
        }
        if (this.preferences.getBoolean("update.feed.nightly.enable")) {
            this.updateFeedPopup.addItemWithTitle(LocaleFactory.localizedString((String)"Snapshot Builds"));
            this.updateFeedPopup.lastItem().setRepresentedObject("nightly");
        }
        String feed = this.preferences.getProperty("update.feed");
        NSInteger selected = this.updateFeedPopup.menu().indexOfItemWithRepresentedObject(feed);
        if (-1 == selected.intValue()) {
            log.warn(String.format("Invalid feed setting %s", feed));
            this.updateFeedPopup.selectItemAtIndex(this.updateFeedPopup.menu().indexOfItemWithRepresentedObject("release"));
        } else {
            this.updateFeedPopup.selectItemAtIndex(selected);
        }
    }

    public void updateFeedPopupClicked(NSPopUpButton sender) {
        this.preferences.setProperty("update.feed", sender.selectedItem().representedObject());
    }

    public void setDefaultBucketLocation(NSPopUpButton b) {
        this.defaultBucketLocation = b;
        this.defaultBucketLocation.setAutoenablesItems(false);
        this.defaultBucketLocation.removeAllItems();
        for (Location.Name location : new S3Protocol().getRegions()) {
            this.defaultBucketLocation.addItemWithTitle(location.toString());
            this.defaultBucketLocation.lastItem().setRepresentedObject(location.getIdentifier());
        }
        this.defaultBucketLocation.setTarget(this.id());
        this.defaultBucketLocation.setAction(Foundation.selector((String)"defaultBucketLocationClicked:"));
        this.defaultBucketLocation.selectItemAtIndex(this.defaultBucketLocation.indexOfItemWithRepresentedObject(this.preferences.getProperty("s3.location")));
    }

    public void defaultBucketLocationClicked(NSPopUpButton sender) {
        this.preferences.setProperty("s3.location", sender.selectedItem().representedObject());
    }

    public void setDefaultStorageClassPopup(NSPopUpButton b) {
        this.defaultStorageClassPopup = b;
        this.defaultStorageClassPopup.setAutoenablesItems(false);
        this.defaultStorageClassPopup.removeAllItems();
        for (String s : this.preferences.getList("s3.storage.class.options")) {
            this.defaultStorageClassPopup.addItemWithTitle(LocaleFactory.localizedString((String)s, (String)"S3"));
            this.defaultStorageClassPopup.lastItem().setRepresentedObject(s);
        }
        this.defaultStorageClassPopup.setTarget(this.id());
        this.defaultStorageClassPopup.setAction(Foundation.selector((String)"defaultStorageClassPopupClicked:"));
        this.defaultStorageClassPopup.selectItemAtIndex(this.defaultStorageClassPopup.indexOfItemWithRepresentedObject(this.preferences.getProperty("s3.storage.class")));
    }

    public void defaultStorageClassPopupClicked(NSPopUpButton sender) {
        this.preferences.setProperty("s3.storage.class", sender.selectedItem().representedObject());
    }

    public void setDefaultEncryptionPopup(NSPopUpButton b) {
        this.defaultEncryptionPopup = b;
        this.defaultEncryptionPopup.setAutoenablesItems(false);
        this.defaultEncryptionPopup.removeAllItems();
        this.defaultEncryptionPopup.addItemWithTitle(LocaleFactory.localizedString((String)"None"));
        this.defaultEncryptionPopup.lastItem().setRepresentedObject(Encryption.Algorithm.NONE.toString());
        this.defaultEncryptionPopup.addItemWithTitle(LocaleFactory.localizedString((String)S3EncryptionFeature.SSE_AES256.getDescription(), (String)"S3"));
        this.defaultEncryptionPopup.lastItem().setRepresentedObject(S3EncryptionFeature.SSE_AES256.toString());
        this.defaultEncryptionPopup.addItemWithTitle(LocaleFactory.localizedString((String)KMSEncryptionFeature.SSE_KMS_DEFAULT.getDescription(), (String)"S3"));
        this.defaultEncryptionPopup.lastItem().setRepresentedObject(KMSEncryptionFeature.SSE_KMS_DEFAULT.toString());
        this.defaultEncryptionPopup.setTarget(this.id());
        this.defaultEncryptionPopup.setAction(Foundation.selector((String)"defaultEncryptionPopupClicked:"));
        if (StringUtils.isEmpty((CharSequence)this.preferences.getProperty("s3.encryption.algorithm"))) {
            this.defaultEncryptionPopup.selectItemWithTitle(LocaleFactory.localizedString((String)"None"));
        } else {
            this.defaultEncryptionPopup.selectItemAtIndex(this.defaultEncryptionPopup.indexOfItemWithRepresentedObject(this.preferences.getProperty("s3.encryption.algorithm")));
        }
    }

    public void defaultEncryptionPopupClicked(NSPopUpButton sender) {
        this.preferences.setProperty("s3.encryption.algorithm", sender.selectedItem().representedObject());
    }

    public void setCannedAclPopup(NSPopUpButton b) {
        this.cannedAclPopup = b;
        this.cannedAclPopup.setAutoenablesItems(false);
        this.cannedAclPopup.removeAllItems();
        this.cannedAclPopup.addItemWithTitle(LocaleFactory.localizedString((String)"None"));
        this.cannedAclPopup.lastItem().setRepresentedObject("none");
        for (Acl acl : S3AccessControlListFeature.CANNED_LIST) {
            this.cannedAclPopup.addItemWithTitle(LocaleFactory.localizedString((String)acl.getCannedString(), (String)"S3"));
            this.cannedAclPopup.lastItem().setRepresentedObject(acl.getCannedString());
        }
        this.cannedAclPopup.setTarget(this.id());
        this.cannedAclPopup.setAction(Foundation.selector((String)"cannedAclPopupClicked:"));
        this.cannedAclPopup.selectItemAtIndex(this.cannedAclPopup.indexOfItemWithRepresentedObject(this.preferences.getProperty("s3.acl.default")));
    }

    public void cannedAclPopupClicked(NSPopUpButton sender) {
        this.preferences.setProperty("s3.acl.default", sender.selectedItem().representedObject());
    }

    public void setDefaultBucketLocationGoogleStorage(NSPopUpButton b) {
        this.defaultBucketLocationGoogleStorage = b;
        this.defaultBucketLocationGoogleStorage.setAutoenablesItems(false);
        this.defaultBucketLocationGoogleStorage.removeAllItems();
        for (Location.Name location : new GoogleStorageProtocol().getRegions()) {
            this.defaultBucketLocationGoogleStorage.addItemWithTitle(location.toString());
            this.defaultBucketLocationGoogleStorage.lastItem().setRepresentedObject(location.getIdentifier());
        }
        this.defaultBucketLocationGoogleStorage.setTarget(this.id());
        this.defaultBucketLocationGoogleStorage.setAction(Foundation.selector((String)"defaultBucketLocationGoogleStorageClicked:"));
        this.defaultBucketLocationGoogleStorage.selectItemAtIndex(this.defaultBucketLocationGoogleStorage.indexOfItemWithRepresentedObject(this.preferences.getProperty("googlestorage.location")));
    }

    public void defaultBucketLocationGoogleStorageClicked(NSPopUpButton sender) {
        this.preferences.setProperty("googlestorage.location", sender.selectedItem().representedObject());
    }

    public void setDefaultStorageClassPopupGoogleStorage(NSPopUpButton b) {
        this.defaultStorageClassPopupGoogleStorage = b;
        this.defaultStorageClassPopupGoogleStorage.setAutoenablesItems(false);
        this.defaultStorageClassPopupGoogleStorage.removeAllItems();
        for (String s : this.preferences.getList("googlestorage.storage.class.options")) {
            this.defaultStorageClassPopupGoogleStorage.addItemWithTitle(LocaleFactory.localizedString((String)s, (String)"S3"));
            this.defaultStorageClassPopupGoogleStorage.lastItem().setRepresentedObject(s);
        }
        this.defaultStorageClassPopupGoogleStorage.setTarget(this.id());
        this.defaultStorageClassPopupGoogleStorage.setAction(Foundation.selector((String)"defaultStorageClassPopupGoogleStorageClicked:"));
        this.defaultStorageClassPopupGoogleStorage.selectItemAtIndex(this.defaultStorageClassPopupGoogleStorage.indexOfItemWithRepresentedObject(this.preferences.getProperty("googlestorage.storage.class")));
    }

    public void defaultStorageClassPopupGoogleStorageClicked(NSPopUpButton sender) {
        this.preferences.setProperty("googlestorage.storage.class", sender.selectedItem().representedObject());
    }

    public void setCannedAclPopupGoogleStorage(NSPopUpButton b) {
        this.cannedAclPopupGoogleStorage = b;
        this.cannedAclPopupGoogleStorage.setAutoenablesItems(false);
        this.cannedAclPopupGoogleStorage.removeAllItems();
        this.cannedAclPopupGoogleStorage.addItemWithTitle(LocaleFactory.localizedString((String)"None"));
        this.cannedAclPopupGoogleStorage.lastItem().setRepresentedObject("none");
        for (Acl acl : GoogleStorageAccessControlListFeature.CANNED_LIST) {
            this.cannedAclPopupGoogleStorage.addItemWithTitle(LocaleFactory.localizedString((String)acl.getCannedString(), (String)"S3"));
            this.cannedAclPopupGoogleStorage.lastItem().setRepresentedObject(acl.getCannedString());
        }
        this.cannedAclPopupGoogleStorage.setTarget(this.id());
        this.cannedAclPopupGoogleStorage.setAction(Foundation.selector((String)"cannedAclPopupGoogleStorageClicked:"));
        this.cannedAclPopupGoogleStorage.selectItemAtIndex(this.cannedAclPopupGoogleStorage.indexOfItemWithRepresentedObject(this.preferences.getProperty("googlestorage.acl.default")));
    }

    public void cannedAclPopupGoogleStorageClicked(NSPopUpButton sender) {
        this.preferences.setProperty("googlestorage.acl.default", sender.selectedItem().representedObject());
    }

    public void setLanguagePopup(NSPopUpButton b) {
        this.languagePopup = b;
        this.languagePopup.removeAllItems();
        this.languagePopup.setTarget(this.id());
        this.languagePopup.setAction(Foundation.selector((String)"languagePopupClicked:"));
        this.languagePopup.addItemWithTitle(LocaleFactory.localizedString((String)"Default"));
        this.languagePopup.menu().addItem(NSMenuItem.separatorItem());
        String custom = null;
        if (this.preferences.systemLocales().size() > 1) {
            this.languagePopup.selectItemWithTitle(LocaleFactory.localizedString((String)"Default"));
        } else {
            custom = this.preferences.locale();
        }
        for (String identifier : this.preferences.applicationLocales()) {
            this.languagePopup.addItemWithTitle(this.preferences.getDisplayName(identifier));
            this.languagePopup.lastItem().setRepresentedObject(identifier);
            if (!identifier.equals(custom)) continue;
            this.languagePopup.selectItem(this.languagePopup.lastItem());
        }
    }

    public void languagePopupClicked(NSPopUpButton sender) {
        LocaleFactory.get().setDefault(sender.selectedItem().representedObject());
    }

    public void setUseProxiesButton(NSButton b) {
        this.useProxiesButton = b;
        this.useProxiesButton.setTarget(this.id());
        this.useProxiesButton.setAction(Foundation.selector((String)"useProxiesButtonClicked:"));
        this.useProxiesButton.setState(this.preferences.getBoolean("connection.proxy.enable") ? 1 : 0);
    }

    public void useProxiesButtonClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.preferences.setProperty("connection.proxy.enable", enabled);
        this.configureProxiesButton.setEnabled(enabled);
    }

    public void setConfigureProxiesButton(NSButton b) {
        this.configureProxiesButton = b;
        this.configureProxiesButton.setTarget(this.id());
        this.configureProxiesButton.setAction(Foundation.selector((String)"configureProxiesButtonClicked:"));
        this.configureProxiesButton.setEnabled(this.preferences.getBoolean("connection.proxy.enable"));
    }

    public void configureProxiesButtonClicked(NSButton sender) {
        String script = "tell application \"System Preferences\"\nactivate\nreveal anchor \"Proxies\" of pane \"com.apple.preference.network\"\nend tell";
        NSAppleScript open = NSAppleScript.createWithSource((String)"tell application \"System Preferences\"\nactivate\nreveal anchor \"Proxies\" of pane \"com.apple.preference.network\"\nend tell");
        open.executeAndReturnError(null);
    }

    public void setLogCheckbox(NSButton b) {
        this.logCheckbox = b;
        this.logCheckbox.setTarget(this.id());
        this.logCheckbox.setAction(Foundation.selector((String)"logCheckboxClicked:"));
        this.logCheckbox.setState(Level.DEBUG.equals((Object)LoggerContext.getContext((boolean)false).getConfiguration().getRootLogger().getLevel()) ? 1 : 0);
    }

    public void logCheckboxClicked(NSButton sender) {
        switch (sender.state()) {
            case 1: {
                this.preferences.setLogging(Level.DEBUG.toString());
                break;
            }
            default: {
                this.preferences.setLogging(Level.ERROR.toString());
            }
        }
    }

    public void setLogShowButton(NSButton b) {
        this.logShowButton = b;
        this.logShowButton.setTitle(LocaleFactory.localizedString((String)"Show in Finder", (String)"Localizable"));
        this.logShowButton.setTarget(this.id());
        this.logShowButton.setAction(Foundation.selector((String)"logShowButtonClicked:"));
    }

    public void logShowButtonClicked(final NSButton sender) {
        sender.setEnabled(false);
        Executors.newSingleThreadExecutor().submit(new Callable<Void>(){

            @Override
            public Void call() {
                try {
                    Local file = LocalFactory.get((String)LogDirectoryFinderFactory.get().find().getAbsolute(), (String)String.format("%s.log", StringUtils.replaceChars((String)StringUtils.lowerCase((String)PreferencesController.this.preferences.getProperty("application.name")), (String)" ", (String)"")));
                    if (!RevealServiceFactory.get().reveal(file)) {
                        log.warn(String.format("Failure reveal log file %s", file));
                    }
                }
                catch (Throwable throwable) {
                    PreferencesController.this.invoke((MainAction)new DefaultMainAction(){

                        public void run() {
                            sender.setEnabled(true);
                        }
                    });
                    throw throwable;
                }
                PreferencesController.this.invoke((MainAction)new /* invalid duplicate definition of identical inner class */);
                return null;
            }
        });
    }

    public void setCryptomatorCheckbox(NSButton cryptomatorCheckbox) {
        this.cryptomatorCheckbox = cryptomatorCheckbox;
        this.cryptomatorCheckbox.setTarget(this.id());
        this.cryptomatorCheckbox.setAction(Foundation.selector((String)"cryptomatorCheckboxClicked:"));
        this.cryptomatorCheckbox.setState(this.preferences.getBoolean("cryptomator.vault.autodetect") ? 1 : 0);
    }

    public void cryptomatorCheckboxClicked(NSButton sender) {
        this.preferences.setProperty("cryptomator.vault.autodetect", sender.state() == 1);
    }

    private static class EditorOpenPanelDelegate
    extends ProxyController {
        private EditorOpenPanelDelegate() {
        }

        public boolean panel_shouldShowFilename(ID panel, String path) {
            Local f = LocalFactory.get((String)path);
            if (f.isDirectory()) {
                return true;
            }
            String extension = f.getExtension();
            if (StringUtils.isEmpty((CharSequence)extension)) {
                return false;
            }
            return extension.equals("app");
        }
    }

    protected static class PreferencesLabel
    extends ToolbarWindowController.Label {
        public PreferencesLabel(PreferencesToolbarItem item) {
            super(item.name(), item.label(), item.image());
        }
    }

    protected static enum PreferencesToolbarItem {
        general,
        browser,
        queue{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)"Transfers", (String)"Preferences");
            }
        }
        ,
        editor{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)"Editor", (String)"Preferences");
            }
        }
        ,
        ftp{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)StringUtils.upperCase((String)this.name()), (String)"Preferences");
            }
        }
        ,
        sftp{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)StringUtils.upperCase((String)this.name()), (String)"Preferences");
            }
        }
        ,
        s3{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)StringUtils.upperCase((String)this.name()), (String)"Preferences");
            }
        }
        ,
        googlestorage{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)new GoogleStorageProtocol().getName(), (String)"Preferences");
            }
        }
        ,
        bandwidth,
        connection,
        cryptomator,
        update,
        language,
        profiles{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)StringUtils.capitalize((String)this.name()), (String)"Profiles");
            }
        };


        public String label() {
            return LocaleFactory.localizedString((String)StringUtils.capitalize((String)this.name()), (String)"Preferences");
        }

        public String image() {
            return String.format("preferences-%s.pdf", this.name());
        }
    }
}

