/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.ProxyController;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.SheetCallback;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.cocoa.controller.BrowserController;
import java.util.List;

public class OverwriteController
extends ProxyController {
    private final BrowserController parent;
    private final Cache<Path> cache;

    public OverwriteController(BrowserController parent) {
        this.parent = parent;
        this.cache = parent.getCache();
    }

    public OverwriteController(BrowserController parent, Cache<Path> cache) {
        this.parent = parent;
        this.cache = cache;
    }

    public void overwrite(List<Path> selected, final MainAction action) {
        StringBuilder alertText = new StringBuilder(LocaleFactory.localizedString((String)"A file with the same name already exists. Do you want to replace the existing file?"));
        int i = 0;
        boolean shouldWarn = false;
        for (Path item : selected) {
            if (this.cache.get((Referenceable)item.getParent()).contains((Referenceable)item)) {
                if (i < 10) {
                    alertText.append('\n').append('\u2022').append(' ').append(item.getName());
                }
                shouldWarn = true;
            }
            ++i;
        }
        if (i >= 10) {
            alertText.append('\n').append('\u2022').append(' ').append('\u2026');
        }
        if (shouldWarn) {
            NSAlert alert = NSAlert.alert((String)LocaleFactory.localizedString((String)"Overwrite"), (String)alertText.toString(), (String)LocaleFactory.localizedString((String)"Overwrite"), (String)LocaleFactory.localizedString((String)"Cancel"), null);
            this.parent.alert(alert, new SheetCallback(){

                public void callback(int returncode) {
                    if (returncode == 1) {
                        action.run();
                    }
                }
            });
        } else {
            action.run();
        }
    }
}

