/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.ui.cocoa.controller.BrowserController;
import ch.cyberduck.ui.cocoa.controller.InfoController;
import ch.cyberduck.ui.cocoa.controller.ReloadCallback;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class InfoControllerFactory {
    private static final Map<BrowserController, InfoController> open = new HashMap<BrowserController, InfoController>();
    private static final Preferences preferences = PreferencesFactory.get();

    private InfoControllerFactory() {
    }

    public static InfoController create(final BrowserController controller, final List<Path> selected) {
        if (preferences.getBoolean("browser.info.inspector") && open.containsKey((Object)controller)) {
            InfoController c = open.get((Object)controller);
            c.setFiles(selected);
            return c;
        }
        InfoController info = new InfoController((Controller)controller, controller.getSession(), selected, new ReloadCallback(){

            @Override
            public void done(List<Path> files) {
                controller.reload(controller.workdir(), selected, (List<Path>)selected);
            }
        }){

            @Override
            public void windowWillClose(NSNotification notification) {
                open.remove((Object)controller);
                super.windowWillClose(notification);
            }
        };
        info.loadBundle();
        open.put(controller, info);
        return info;
    }

    public static InfoController get(BrowserController controller) {
        return open.get((Object)controller);
    }
}

