/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSMenuItem;
import ch.cyberduck.binding.application.NSPopUpButton;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.binding.foundation.NSAttributedString;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSMutableAttributedString;
import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.StringAppender;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.ui.browser.UploadTargetFinder;
import ch.cyberduck.ui.cocoa.controller.FileController;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.rococoa.cocoa.foundation.NSPoint;
import org.rococoa.cocoa.foundation.NSRect;

public class FolderController
extends FileController {
    private final Path workdir;
    private final Path selected;
    private final Set<Location.Name> regions;
    private final Location.Name defaultRegion;
    private final Callback callback;
    private NSView view;
    private NSPopUpButton regionPopup;

    public FolderController(Path workdir, Path selected, Cache<Path> cache, Set<Location.Name> regions, Location.Name defaultRegion, Callback callback) {
        super(workdir, selected, cache);
        this.workdir = workdir;
        this.selected = selected;
        this.regions = regions;
        this.defaultRegion = defaultRegion;
        this.callback = callback;
    }

    public void loadBundle() {
        NSAlert alert = NSAlert.alert();
        alert.setAlertStyle(1);
        alert.setMessageText(LocaleFactory.localizedString((String)"Create new folder", (String)"Folder"));
        String message = LocaleFactory.localizedString((String)"Enter the name for the new folder", (String)"Folder");
        alert.setInformativeText(new StringAppender().append(message).toString());
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Create", (String)"Folder"));
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Cancel", (String)"Folder"));
        alert.setIcon((NSImage)IconCacheFactory.get().iconNamed("folderplus.tiff", Integer.valueOf(64)));
        super.loadBundle(alert);
    }

    @Override
    public NSView getAccessoryView(NSAlert alert) {
        if (this.hasLocation()) {
            this.view = NSView.create((NSRect)new NSRect(alert.window().frame().size.width.doubleValue(), 0.0));
            this.regionPopup = NSPopUpButton.buttonWithFrame((NSRect)new NSRect(alert.window().frame().size.width.doubleValue(), 26.0));
            this.regions.stream().sorted(Comparator.comparing(Location.Name::toString)).forEach(region -> {
                this.regionPopup.addItemWithTitle(region.toString());
                NSMenuItem item = this.regionPopup.itemWithTitle(region.toString());
                item.setRepresentedObject(region.getIdentifier());
                if (!StringUtils.equals((CharSequence)region.getIdentifier(), (CharSequence)region.toString())) {
                    NSMutableAttributedString description = NSMutableAttributedString.create((String)item.title());
                    description.appendAttributedString((NSAttributedString)NSMutableAttributedString.create((String)String.format("\n%s", region.getIdentifier()), (NSDictionary)MENU_HELP_FONT_ATTRIBUTES));
                    item.setAttributedTitle((NSAttributedString)description);
                }
                if (region.equals((Object)this.defaultRegion)) {
                    this.regionPopup.selectItem(this.regionPopup.lastItem());
                }
            });
            this.regionPopup.setFrameOrigin(new NSPoint(0.0, 0.0));
            this.view.addSubview((NSView)this.regionPopup);
            this.inputField.setFrameOrigin(new NSPoint(0.0, this.getFrame((NSAlert)alert, (NSView)this.view).size.height.doubleValue() + this.view.subviews().count().doubleValue() * 4.0));
            this.view.addSubview((NSView)this.inputField);
            return this.view;
        }
        return super.getAccessoryView(alert);
    }

    protected boolean hasLocation() {
        return !this.regions.isEmpty() && new UploadTargetFinder(this.workdir).find(this.selected).isRoot();
    }

    protected String getLocation() {
        return this.hasLocation() ? this.regionPopup.selectedItem().representedObject() : null;
    }

    @Override
    public void callback(int returncode, Path file) {
        file.setType(EnumSet.of(AbstractPath.Type.directory));
        this.callback.callback(file, this.getLocation());
    }

    public static interface Callback {
        public void callback(Path var1, String var2);
    }
}

